/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.oss.unbearable.messages;

import com.pingidentity.oss.unbearable.messages.TokenBindingKeyParameters;
import com.pingidentity.oss.unbearable.utils.In;
import com.pingidentity.oss.unbearable.utils.Out;
import com.pingidentity.oss.unbearable.utils.RsaKeyUtil;
import com.pingidentity.oss.unbearable.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public abstract class Rsa2048
extends TokenBindingKeyParameters {
    @Override
    PublicKey readPublicKey(In in, int length) throws IOException, GeneralSecurityException {
        byte[] modulus = in.readTwoBytesOfBytes();
        byte[] publicExponent = in.readOneByteOfBytes();
        return RsaKeyUtil.rsaPublicKey(modulus, publicExponent);
    }

    @Override
    public byte[] encodeTokenBindingPublicKey(PublicKey publicKey) {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
        BigInteger modulusInt = rsaPublicKey.getModulus();
        byte[] modulus = Util.toUnsignedMagnitudeByteArray(modulusInt);
        BigInteger publicExponentInt = rsaPublicKey.getPublicExponent();
        byte[] publicExponent = Util.toUnsignedMagnitudeByteArray(publicExponentInt);
        Out out = new Out();
        out.putTwoBytesOfBytes(modulus);
        out.putOneByteOfBytes(publicExponent);
        return out.toByteArray();
    }

    @Override
    String checkPublicKey(PublicKey publicKey) {
        try {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            int bitLen = rsaPublicKey.getModulus().bitLength();
            if (bitLen < 2048) {
                return "RSA key too small (" + bitLen + ")";
            }
        }
        catch (ClassCastException e) {
            return "Wrong key type (expecting RSA Public Key): " + e;
        }
        return null;
    }

    static class Pss
    extends Rsa2048 {
        AlgorithmParameterSpec PSS_SPEC = new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1);

        Pss() {
        }

        @Override
        byte getIdentifier() {
            return 1;
        }

        @Override
        String getJavaAlgorithm() {
            return "SHA256withRSAandMGF1";
        }

        @Override
        AlgorithmParameterSpec getJavaAlgorithmParameterSpec() {
            return this.PSS_SPEC;
        }
    }

    static class Pkcs15
    extends Rsa2048 {
        Pkcs15() {
        }

        @Override
        byte getIdentifier() {
            return 0;
        }

        @Override
        String getJavaAlgorithm() {
            return "SHA256withRSA";
        }
    }
}

