/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.oss.unbearable.messages;

import com.pingidentity.oss.unbearable.messages.EcdsaP256;
import com.pingidentity.oss.unbearable.messages.Rsa2048;
import com.pingidentity.oss.unbearable.messages.SignatureResult;
import com.pingidentity.oss.unbearable.utils.ExceptionUtil;
import com.pingidentity.oss.unbearable.utils.In;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TokenBindingKeyParameters {
    public static final byte RSA2048_PKCS1_5 = 0;
    public static final byte RSA2048_PSS = 1;
    public static final byte ECDSAP256 = 2;

    public static TokenBindingKeyParameters fromIdentifier(byte identifier) {
        switch (identifier) {
            case 2: {
                return new EcdsaP256();
            }
            case 0: {
                return new Rsa2048.Pkcs15();
            }
            case 1: {
                return new Rsa2048.Pss();
            }
        }
        return new UnknownKeyParameters(identifier);
    }

    abstract byte getIdentifier();

    abstract PublicKey readPublicKey(In var1, int var2) throws IOException, GeneralSecurityException;

    public abstract byte[] encodeTokenBindingPublicKey(PublicKey var1);

    abstract String getJavaAlgorithm();

    abstract String checkPublicKey(PublicKey var1);

    AlgorithmParameterSpec getJavaAlgorithmParameterSpec() {
        return null;
    }

    SignatureResult evaluateSignature(byte[] signatureInput, byte[] signature, PublicKey publicKey) throws IOException {
        Signature verifier;
        String keyProblem = this.checkPublicKey(publicKey);
        if (keyProblem != null) {
            SignatureResult signatureResult = new SignatureResult(SignatureResult.Status.INVALID);
            signatureResult.addComment("Unacceptable public key in TokenBindingID: " + keyProblem);
            return signatureResult;
        }
        try {
            verifier = this.getSignatureObject();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            SignatureResult signatureResult = new SignatureResult(SignatureResult.Status.UNEVALUATED);
            signatureResult.addComment("Unsupported TokenBindingKeyParameters type ( " + this.getIdentifier() + "):" + ExceptionUtil.toStringWithCauses(e));
            return signatureResult;
        }
        try {
            verifier.initVerify(publicKey);
            verifier.update(signatureInput);
            boolean legit = verifier.verify(signature);
            return legit ? SignatureResult.VALID : SignatureResult.INVALID;
        }
        catch (InvalidKeyException | SignatureException e) {
            SignatureResult signatureResult = new SignatureResult(SignatureResult.Status.INVALID);
            signatureResult.addComment("Problem encountered during verification: " + ExceptionUtil.toStringWithCauses(e));
            return signatureResult;
        }
    }

    public byte[] sign(byte[] signatureInput, PrivateKey privateKey) throws GeneralSecurityException {
        Signature signer = this.getSignatureObject();
        signer.initSign(privateKey);
        signer.update(signatureInput);
        return signer.sign();
    }

    Signature getSignatureObject() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Signature instance;
        block3: {
            String javaAlgorithm = this.getJavaAlgorithm();
            instance = Signature.getInstance(javaAlgorithm);
            AlgorithmParameterSpec algorithmParameterSpec = this.getJavaAlgorithmParameterSpec();
            if (algorithmParameterSpec != null) {
                try {
                    instance.setParameter(algorithmParameterSpec);
                }
                catch (UnsupportedOperationException e) {
                    Logger log = Logger.getLogger(this.getClass().getName());
                    if (!log.isLoggable(Level.INFO)) break block3;
                    log.log(Level.INFO, "Unable to set algorithm parameter spec on Signature (java algorithm name: " + javaAlgorithm + ") so ignoring the UnsupportedOperationException and relying on the default parameters.", e);
                }
            }
        }
        return instance;
    }

    public boolean isSupportedAndAvailable() {
        try {
            this.getSignatureObject();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static class UnknownKeyParameters
    extends TokenBindingKeyParameters {
        byte identifier;

        UnknownKeyParameters(byte identifier) {
            this.identifier = identifier;
        }

        @Override
        byte getIdentifier() {
            return this.identifier;
        }

        @Override
        PublicKey readPublicKey(In in, int length) throws IOException {
            for (int i = 0; i < length; ++i) {
                in.read();
            }
            return null;
        }

        @Override
        public byte[] encodeTokenBindingPublicKey(PublicKey publicKey) {
            return new byte[0];
        }

        @Override
        String getJavaAlgorithm() {
            return "UNKNOWN";
        }

        @Override
        String checkPublicKey(PublicKey publicKey) {
            return null;
        }

        @Override
        public boolean isSupportedAndAvailable() {
            return false;
        }

        @Override
        SignatureResult evaluateSignature(byte[] signatureInput, byte[] signature, PublicKey publicKey) throws IOException {
            SignatureResult signatureResult = new SignatureResult(SignatureResult.Status.UNEVALUATED);
            signatureResult.addComment("Unknown Token Binding Key Parameters type: " + this.getIdentifier());
            return signatureResult;
        }

        @Override
        public byte[] sign(byte[] signatureInput, PrivateKey privateKey) throws GeneralSecurityException {
            throw new GeneralSecurityException("Cannot sign with unknown Token Binding Key Parameters type: " + this.getIdentifier());
        }
    }
}

