/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.oss.unbearable.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;

public class In
extends ByteArrayInputStream {
    private static final byte[] EMPTY = new byte[0];

    public In(byte[] buf) {
        super(buf);
    }

    public int readOneByteInt() throws IOException {
        return this.read();
    }

    public int readTwoByteInt() throws IOException {
        return this.readOneByteInt() << 8 | this.readOneByteInt();
    }

    public byte[] readOneByteOfBytes() throws IOException {
        int len = this.readOneByteInt();
        return this.readBytes(len);
    }

    public byte[] readTwoBytesOfBytes() throws IOException {
        int len = this.readTwoByteInt();
        return this.readBytes(len);
    }

    public void mark() {
        this.mark(Integer.MIN_VALUE);
    }

    public byte[] readBytesFromMark() throws IOException {
        int len = this.pos - this.mark;
        this.reset();
        return this.readBytes(len);
    }

    private byte[] readBytes(int length) throws IOException {
        int howMany;
        this.checkLength(length);
        byte[] bytes = EMPTY;
        if (length != 0 && (howMany = this.read(bytes = new byte[length], 0, length)) != length) {
            throw new IOException("Needed to read " + length + " but only able to read " + howMany);
        }
        return bytes;
    }

    private void checkLength(int len) throws IOException {
        int available = this.available();
        if (len > available) {
            throw new IOException("Indicated length " + len + " exceeds available bytes " + available);
        }
    }
}

