/*
 * Decompiled with CFR 0.152.
 */
package com.sailthru.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sailthru.client.ApiAction;
import com.sailthru.client.DefaultSailthruHttpClientConfiguration;
import com.sailthru.client.LastRateLimitInfo;
import com.sailthru.client.SailthruHttpClientConfiguration;
import com.sailthru.client.SailthruUtil;
import com.sailthru.client.handler.JsonHandler;
import com.sailthru.client.handler.SailthruResponseHandler;
import com.sailthru.client.handler.response.JsonResponse;
import com.sailthru.client.http.SailthruHandler;
import com.sailthru.client.http.SailthruHttpClient;
import com.sailthru.client.params.ApiFileParams;
import com.sailthru.client.params.ApiParams;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public abstract class AbstractSailthruClient {
    private static final Gson GSON = SailthruUtil.createGson();
    public static final String DEFAULT_API_URL = "https://api.sailthru.com";
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final String DEFAULT_USER_AGENT = "Sailthru Java Client";
    public static final String DEFAULT_ENCODING = "UTF-8";
    protected String apiKey;
    protected String apiSecret;
    protected String apiUrl;
    protected SailthruHttpClient httpClient;
    private SailthruHandler handler;
    private Map<String, String> customHeaders = null;
    private final SailthruHttpClientConfiguration sailthruHttpClientConfiguration;
    private final Map<ApiActionHttpMethod, LastRateLimitInfo> lastRateLimitInfoMap = new HashMap<ApiActionHttpMethod, LastRateLimitInfo>();

    public AbstractSailthruClient(String apiKey, String apiSecret, String apiUrl) {
        this(apiKey, apiSecret, apiUrl, new DefaultSailthruHttpClientConfiguration());
    }

    public AbstractSailthruClient(String apiKey, String apiSecret, String apiUrl, SailthruHttpClientConfiguration sailthruHttpClientConfiguration) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.apiUrl = apiUrl;
        this.handler = new SailthruHandler(new JsonHandler());
        this.sailthruHttpClientConfiguration = sailthruHttpClientConfiguration;
        this.httpClient = this.create();
    }

    private SailthruHttpClient create() {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)DEFAULT_ENCODING);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)DEFAULT_USER_AGENT);
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)true);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.sailthruHttpClientConfiguration.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.sailthruHttpClientConfiguration.getSoTimeout());
        HttpConnectionParams.setSoReuseaddr((HttpParams)params, (boolean)this.sailthruHttpClientConfiguration.getSoReuseaddr());
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)this.sailthruHttpClientConfiguration.getTcpNoDelay());
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(this.getScheme());
        ThreadSafeClientConnManager connManager = new ThreadSafeClientConnManager(schemeRegistry);
        connManager.setMaxTotal(this.sailthruHttpClientConfiguration.getMaxTotalConnections());
        connManager.setDefaultMaxPerRoute(this.sailthruHttpClientConfiguration.getDefaultMaxConnectionsPerRoute());
        return new SailthruHttpClient(connManager, (HttpParams)params);
    }

    public SailthruHttpClient getSailthruHttpClient() {
        return this.httpClient;
    }

    protected Scheme getScheme() {
        String scheme;
        try {
            URI uri = new URI(this.apiUrl);
            scheme = uri.getScheme();
        }
        catch (URISyntaxException e) {
            scheme = "http";
        }
        if (scheme.equals("https")) {
            return new Scheme(scheme, 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory());
        }
        return new Scheme(scheme, 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
    }

    protected Object httpRequest(ApiAction action, HttpRequestMethod method, Map<String, Object> data) throws IOException {
        String url = this.apiUrl + "/" + action.toString().toLowerCase();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        String json = GSON.toJson(data, type);
        Map<String, String> params = this.buildPayload(json);
        Object response = this.httpClient.executeHttpRequest(url, method, params, this.handler, this.customHeaders);
        this.recordRateLimitInfo(action, method, response);
        return response;
    }

    protected Object httpRequest(HttpRequestMethod method, ApiParams apiParams) throws IOException {
        ApiAction action = apiParams.getApiCall();
        String url = this.apiUrl + "/" + action.toString().toLowerCase();
        String json = GSON.toJson((Object)apiParams, apiParams.getType());
        Map<String, String> params = this.buildPayload(json);
        Object response = this.httpClient.executeHttpRequest(url, method, params, this.handler, this.customHeaders);
        this.recordRateLimitInfo(action, method, response);
        return response;
    }

    protected Object httpRequest(HttpRequestMethod method, ApiParams apiParams, ApiFileParams fileParams) throws IOException {
        ApiAction action = apiParams.getApiCall();
        String url = this.apiUrl + "/" + action.toString().toLowerCase();
        String json = GSON.toJson((Object)apiParams, apiParams.getType());
        Map<String, String> params = this.buildPayload(json);
        Object response = this.httpClient.executeHttpRequest(url, method, params, fileParams.getFileParams(), this.handler, this.customHeaders);
        this.recordRateLimitInfo(action, method, response);
        return response;
    }

    protected JsonResponse httpRequestJson(HttpRequestMethod method, ApiParams apiParams) throws IOException {
        return new JsonResponse(this.httpRequest(method, apiParams));
    }

    protected JsonResponse httpRequestJson(HttpRequestMethod method, ApiParams apiParams, ApiFileParams fileParams) throws IOException {
        return new JsonResponse(this.httpRequest(method, apiParams, fileParams));
    }

    protected JsonResponse httpRequestJson(ApiAction action, HttpRequestMethod method, Map<String, Object> data) throws IOException {
        return new JsonResponse(this.httpRequest(action, method, data));
    }

    private Map<String, String> buildPayload(String jsonPayload) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.apiKey);
        params.put("format", this.handler.getSailthruResponseHandler().getFormat());
        params.put("json", jsonPayload);
        params.put("sig", this.getSignatureHash(params));
        return params;
    }

    protected String getSignatureHash(Map<String, String> parameters) {
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder data = new StringBuilder();
        data.append(this.apiSecret);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            values.add(entry.getValue());
        }
        Collections.sort(values);
        for (String value : values) {
            data.append(value);
        }
        return SailthruUtil.md5(data.toString());
    }

    public JsonResponse apiGet(ApiAction action, Map<String, Object> data) throws IOException {
        return this.httpRequestJson(action, HttpRequestMethod.GET, data);
    }

    public JsonResponse apiGet(ApiParams data) throws IOException {
        return this.httpRequestJson(HttpRequestMethod.GET, data);
    }

    public JsonResponse apiPost(ApiAction action, Map<String, Object> data) throws IOException {
        return this.httpRequestJson(action, HttpRequestMethod.POST, data);
    }

    public JsonResponse apiPost(ApiParams data) throws IOException {
        return this.httpRequestJson(HttpRequestMethod.POST, data);
    }

    public JsonResponse apiPost(ApiParams data, ApiFileParams fileParams) throws IOException {
        return this.httpRequestJson(HttpRequestMethod.POST, data, fileParams);
    }

    public JsonResponse apiDelete(ApiAction action, Map<String, Object> data) throws IOException {
        return this.httpRequestJson(action, HttpRequestMethod.DELETE, data);
    }

    public JsonResponse apiDelete(ApiParams data) throws IOException {
        return this.httpRequestJson(HttpRequestMethod.DELETE, data);
    }

    public LastRateLimitInfo getLastRateLimitInfo(ApiAction action, HttpRequestMethod method) {
        return this.lastRateLimitInfoMap.get(new ApiActionHttpMethod(action, method));
    }

    public void setResponseHandler(SailthruResponseHandler responseHandler) {
        this.handler.setSailthruResponseHandler(responseHandler);
    }

    public void setCustomHeaders(Map<String, String> headers) {
        this.customHeaders = headers;
    }

    @VisibleForTesting
    void setSailthruHttpClient(SailthruHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    private void recordRateLimitInfo(ApiAction action, HttpRequestMethod method, Object response) {
        Map responseMap = (Map)response;
        Object lastRateLimitInfo = responseMap.get("x_rate_limit_info");
        responseMap.remove("x_rate_limit_info");
        if (lastRateLimitInfo instanceof LastRateLimitInfo) {
            ApiActionHttpMethod key = new ApiActionHttpMethod(action, method);
            this.lastRateLimitInfoMap.put(key, (LastRateLimitInfo)lastRateLimitInfo);
        }
    }

    private class ApiActionHttpMethod {
        private final ApiAction action;
        private final HttpRequestMethod method;

        private ApiActionHttpMethod(ApiAction action, HttpRequestMethod method) {
            this.action = action;
            this.method = method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApiActionHttpMethod that = (ApiActionHttpMethod)o;
            if (this.action != that.action) {
                return false;
            }
            return this.method == that.method;
        }

        public int hashCode() {
            int result = this.action.hashCode();
            result = 31 * result + this.method.hashCode();
            return result;
        }
    }

    public static enum HttpRequestMethod {
        GET,
        POST,
        DELETE;

    }
}

