/*
 * Decompiled with CFR 0.152.
 */
package com.sailthru.client;

import com.sailthru.client.AbstractSailthruClient;
import com.sailthru.client.ApiAction;
import com.sailthru.client.SailthruHttpClientConfiguration;
import com.sailthru.client.handler.response.JsonResponse;
import com.sailthru.client.params.Alert;
import com.sailthru.client.params.Blast;
import com.sailthru.client.params.BlastStat;
import com.sailthru.client.params.Content;
import com.sailthru.client.params.Email;
import com.sailthru.client.params.Event;
import com.sailthru.client.params.ListStat;
import com.sailthru.client.params.MultiSend;
import com.sailthru.client.params.Purchase;
import com.sailthru.client.params.Send;
import com.sailthru.client.params.Stats;
import com.sailthru.client.params.Template;
import com.sailthru.client.params.User;
import com.sailthru.client.params.job.BlastQueryJob;
import com.sailthru.client.params.job.ExportListDataJob;
import com.sailthru.client.params.job.ImportJob;
import com.sailthru.client.params.job.PurchaseImportJob;
import com.sailthru.client.params.job.SnapshotJob;
import com.sailthru.client.params.job.UpdateJob;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SailthruClient
extends AbstractSailthruClient {
    private static SailthruClient _instance;

    public SailthruClient(String apiKey, String apiSecret, String apiUrl) {
        super(apiKey, apiSecret, apiUrl);
    }

    public SailthruClient(String apiKey, String apiSecret) {
        super(apiKey, apiSecret, "https://api.sailthru.com");
    }

    public SailthruClient(String apiKey, String apiSecret, String apiUrl, SailthruHttpClientConfiguration sailthruHttpClientConfiguration) {
        super(apiKey, apiSecret, apiUrl, sailthruHttpClientConfiguration);
    }

    public SailthruClient(String apiKey, String apiSecret, SailthruHttpClientConfiguration sailthruHttpClientConfiguration) {
        super(apiKey, apiSecret, "https://api.sailthru.com", sailthruHttpClientConfiguration);
    }

    public static synchronized SailthruClient getInstance(String apiKey, String apiSecret) {
        if (_instance == null) {
            _instance = new SailthruClient(apiKey, apiSecret, "https://api.sailthru.com");
        }
        return _instance;
    }

    public static synchronized SailthruClient getInstance(String apiKey, String apiSecret, String apiUrl) {
        if (_instance == null) {
            _instance = new SailthruClient(apiKey, apiSecret, apiUrl);
        }
        return _instance;
    }

    public JsonResponse getEmail(String email) throws IOException {
        Email emailObj = new Email();
        emailObj.setEmail(email);
        return this.apiGet(emailObj);
    }

    public JsonResponse setEmail(Email email) throws IOException {
        return this.apiPost(email);
    }

    public JsonResponse getSend(String sendId) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("send_id", sendId);
        return this.apiGet(ApiAction.send, data);
    }

    public JsonResponse send(Send send) throws IOException {
        return this.apiPost(send);
    }

    public JsonResponse multiSend(MultiSend multiSend) throws IOException {
        return this.apiPost(multiSend);
    }

    public JsonResponse cancelSend(String sendId) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("send_id", sendId);
        return this.apiDelete(ApiAction.send, data);
    }

    public JsonResponse cancelSend(Send send) throws IOException {
        return this.apiDelete(send);
    }

    public JsonResponse getBlast(Integer blastId) throws IOException {
        Blast blast = new Blast();
        blast.setBlastId(blastId);
        return this.apiGet(blast);
    }

    public JsonResponse scheduleBlast(Blast blast) throws IOException {
        return this.apiPost(blast);
    }

    public JsonResponse scheduleBlastFromTemplate(String template, String list, Date scheduleTime, Blast blast) throws IOException {
        blast.setCopyTemplate(template);
        blast.setList(list);
        blast.setScheduleTime(scheduleTime);
        return this.apiPost(blast);
    }

    public JsonResponse scheduleBlastFromTemplate(String template, String list, Date scheduleTime) throws IOException {
        Blast blast = new Blast();
        blast.setCopyTemplate(template);
        blast.setList(list);
        blast.setScheduleTime(scheduleTime);
        return this.apiPost(blast);
    }

    public JsonResponse scheduleBlastFromBlast(Integer blastId, Date scheduleTime, Blast blast) throws IOException {
        blast.setCopyBlast(blastId);
        blast.setScheduleTime(scheduleTime);
        return this.apiPost(blast);
    }

    public JsonResponse scheduleBlastFromBlast(Integer blastId, Date scheduleTime) throws IOException {
        Blast blast = new Blast();
        blast.setCopyBlast(blastId);
        blast.setScheduleTime(scheduleTime);
        return this.apiPost(blast);
    }

    public JsonResponse updateBlast(Integer blastId) throws IOException {
        Blast blast = new Blast();
        blast.setBlastId(blastId);
        return this.apiPost(blast);
    }

    public JsonResponse updateBlast(Integer blastId, Blast blast) throws IOException {
        blast.setBlastId(blastId);
        return this.apiPost(blast);
    }

    public JsonResponse deleteBlast(Integer blastId) throws IOException {
        Blast blast = new Blast();
        blast.setBlastId(blastId);
        return this.apiDelete(blast);
    }

    public JsonResponse cancelBlast(Integer blastId) throws IOException {
        Blast blast = new Blast();
        Date d = null;
        blast.setBlastId(blastId).setScheduleTime(d);
        return this.apiPost(blast);
    }

    public JsonResponse getTemplate(String template) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("template", template);
        return this.apiGet(ApiAction.template, data);
    }

    public JsonResponse saveTemplate(Template template) throws IOException {
        return this.apiPost(template);
    }

    public JsonResponse deleteTemplate(String template) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("template", template);
        return this.apiDelete(ApiAction.template, data);
    }

    public JsonResponse pushContent(Content content) throws IOException {
        return this.apiPost(content);
    }

    public JsonResponse pushEvent(Event event) throws IOException {
        return this.apiPost(event);
    }

    public JsonResponse getAlert(String email) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("email", email);
        return this.apiGet(ApiAction.alert, data);
    }

    public JsonResponse saveAlert(Alert alert) throws IOException {
        return this.apiPost(alert);
    }

    public JsonResponse deleteAlert(String email, String alertId) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("email", email);
        data.put("alert_id", alertId);
        return this.apiDelete(ApiAction.alert, data);
    }

    public JsonResponse purchase(Purchase purchase) throws IOException {
        return this.apiPost(purchase);
    }

    protected JsonResponse stats(Stats stats) throws IOException {
        return this.apiGet(stats);
    }

    public Map<String, Object> listStats(ListStat stat) throws IOException {
        return (Map)((Object)this.stats(stat));
    }

    public Map<String, Object> blastStats(BlastStat stat) throws IOException {
        return (Map)((Object)this.stats(stat));
    }

    public JsonResponse getJobStatus(String jobId) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("job_id", jobId);
        return this.apiGet(ApiAction.job, params);
    }

    public JsonResponse processImportJob(ImportJob job) throws IOException {
        return this.apiPost(job, job);
    }

    public JsonResponse processSnapshotJob(SnapshotJob job) throws IOException {
        return this.apiPost(job);
    }

    public JsonResponse processBlastQueryJob(BlastQueryJob job) throws IOException {
        return this.apiPost(job);
    }

    public JsonResponse processExportListDataJob(ExportListDataJob job) throws IOException {
        return this.apiPost(job);
    }

    public JsonResponse processUpdateJob(UpdateJob job) throws IOException {
        return this.apiPost(job, job);
    }

    public JsonResponse processPurchaseImportJob(PurchaseImportJob job) throws IOException {
        return this.apiPost(job, job);
    }

    public JsonResponse getUser(User user) throws IOException {
        return this.apiGet(user);
    }

    public JsonResponse saveUser(User user) throws IOException {
        return this.apiPost(user);
    }
}

