/*
 * Decompiled with CFR 0.152.
 */
package com.sailthru.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sailthru.client.NullSerializingMapTypeAdapter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class SailthruUtil {
    public static final String SAILTHRU_API_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss Z";

    public static String md5(String data) {
        try {
            return DigestUtils.md5Hex((byte[])data.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return DigestUtils.md5Hex((String)data.toString());
        }
    }

    public static String arrayListToCSV(List<String> list) {
        StringBuilder csv = new StringBuilder();
        for (String str : list) {
            csv.append(str);
            csv.append(",");
        }
        int lastIndex = csv.length() - 1;
        char last = csv.charAt(lastIndex);
        if (last == ',') {
            return csv.substring(0, lastIndex);
        }
        return csv.toString();
    }

    public static Gson createGson() {
        return new GsonBuilder().setDateFormat(SAILTHRU_API_DATE_FORMAT).registerTypeHierarchyAdapter(Map.class, (Object)new NullSerializingMapTypeAdapter()).create();
    }

    public static Map<String, Map<String, String>> putImage(Map<String, Map<String, String>> images, String key, String url) {
        if (images == null) {
            images = new HashMap<String, Map<String, String>>();
        }
        HashMap<String, String> urlMap = new HashMap<String, String>();
        urlMap.put("url", url);
        images.put(key, urlMap);
        return images;
    }
}

