/*
 * Decompiled with CFR 0.152.
 */
package com.sailthru.client.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sailthru.client.handler.SailthruResponseHandler;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class JsonHandler
implements SailthruResponseHandler {
    public static final String format = "json";

    @Override
    public Object parseResponse(String response) {
        GsonBuilder builder = new GsonBuilder();
        builder.setDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        builder.registerTypeAdapter(Object.class, (Object)new NaturalDeserializer());
        Gson gson = builder.create();
        return gson.fromJson(response, Object.class);
    }

    @Override
    public String getFormat() {
        return format;
    }

    class NaturalDeserializer
    implements JsonDeserializer<Object> {
        NaturalDeserializer() {
        }

        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonPrimitive()) {
                return this.handlePrimitive(json.getAsJsonPrimitive());
            }
            if (json.isJsonArray()) {
                return this.handleArray(json.getAsJsonArray(), context);
            }
            return this.handleObject(json.getAsJsonObject(), context);
        }

        private Object handlePrimitive(JsonPrimitive json) {
            if (json.isString()) {
                return json.getAsString();
            }
            if (json.isBoolean()) {
                return json.getAsBoolean();
            }
            BigDecimal bigDec = json.getAsBigDecimal();
            try {
                bigDec.toBigIntegerExact();
                try {
                    return bigDec.intValueExact();
                }
                catch (ArithmeticException arithmeticException) {
                    return bigDec.longValue();
                }
            }
            catch (ArithmeticException arithmeticException) {
                return bigDec.doubleValue();
            }
        }

        private Object handleArray(JsonArray json, JsonDeserializationContext context) {
            Object[] array = new Object[json.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = json.get(i).isJsonObject() ? this.handleObject((JsonObject)json.get(i), context) : context.deserialize(json.get(i), Object.class);
            }
            return array;
        }

        private Object handleObject(JsonObject json, JsonDeserializationContext context) {
            HashMap map = new HashMap();
            for (Map.Entry entry : json.entrySet()) {
                map.put(entry.getKey(), context.deserialize((JsonElement)entry.getValue(), Object.class));
            }
            return map;
        }
    }
}

