/*
 * Decompiled with CFR 0.152.
 */
package com.sailthru.client.params.query;

import com.google.gson.Gson;
import com.sailthru.client.SailthruUtil;
import com.sailthru.client.handler.JsonHandler;
import com.sailthru.client.params.query.Criteria;
import com.sailthru.client.params.query.QueryMode;
import com.sailthru.client.params.query.TimeRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Query {
    protected String source_list;
    protected QueryMode query_mode;
    protected List<String> criteria = new ArrayList<String>();
    protected List<String> value = new ArrayList<String>();
    protected List<Integer> engagement = new ArrayList<Integer>();
    protected List<Integer> geo_frequency = new ArrayList<Integer>();
    protected List<Integer> threshold = new ArrayList<Integer>();
    protected List<String> timerange = new ArrayList<String>();
    protected List<String> field = new ArrayList<String>();

    public Query setSourceList(String list) {
        this.source_list = list;
        return this;
    }

    public Query addCriteria(Criteria criteria) {
        this.criteria.add(criteria.toString());
        return this;
    }

    public Query addValue(String value) {
        this.value.add(value);
        return this;
    }

    public Query addEngagement(int level) {
        this.engagement.add(level);
        return this;
    }

    public Query addGeoFrequency(int geoFrequency) {
        this.geo_frequency.add(geoFrequency);
        return this;
    }

    public Query addThreshold(int threshold) {
        this.threshold.add(threshold);
        return this;
    }

    public Query addTimeRange(TimeRange timeRange) {
        this.timerange.add(timeRange.toString());
        return this;
    }

    public Map<String, Object> toHashMap() {
        Gson gson = SailthruUtil.createGson();
        String json = gson.toJson((Object)this);
        JsonHandler handler = new JsonHandler();
        return (Map)handler.parseResponse(json);
    }
}

