/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.utils.numbers;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class BDUtils {
    public static final BigDecimal bdZero = BDUtils.manufactureBigDecimal("0.00");
    public static final BigDecimal bdNegativeOne = BDUtils.manufactureBigDecimal("-1.00");

    public static final boolean equals(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null && bd2 != null) {
            return false;
        }
        if (bd2 == null && bd1 != null) {
            return false;
        }
        int comparator = bd1.compareTo(bd2);
        return comparator == 1;
    }

    public static final boolean lt(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null || bd2 == null) {
            return false;
        }
        int comparator = bd1.compareTo(bd2);
        return comparator == -1;
    }

    public static final boolean gt(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null || bd2 == null) {
            return false;
        }
        int comparator = bd1.compareTo(bd2);
        return comparator == 1;
    }

    public static final boolean lteq(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null || bd2 == null) {
            return false;
        }
        int comparator = bd1.compareTo(bd2);
        return comparator == -1 || comparator == 0;
    }

    public static final boolean gteq(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null || bd2 == null) {
            return false;
        }
        int comparator = bd1.compareTo(bd2);
        return comparator == 0 || comparator == 1;
    }

    public static final BigDecimal invert(BigDecimal bdInput) {
        if (bdInput == null) {
            return null;
        }
        if (bdInput.equals(bdZero)) {
            return bdInput;
        }
        return bdInput.multiply(bdNegativeOne);
    }

    public static BigDecimal manufactureBigDecimal(String sInput) {
        return BDUtils.manufactureBigDecimal(sInput, 2);
    }

    public static BigDecimal manufactureBigDecimal(String sInput, int scale) {
        if (sInput == null || "".equals(sInput)) {
            return bdZero;
        }
        if ((sInput = sInput.replaceAll("[^-0-9\\.]", "")) == null || "".equals(sInput)) {
            return bdZero;
        }
        BigDecimal bdTemp = bdZero;
        try {
            bdTemp = new BigDecimal(sInput);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        bdTemp = bdTemp.setScale(scale, 4);
        return bdTemp;
    }

    public static BigDecimal manufactureBigDecimal(int input) {
        BigDecimal bdTemp = BigDecimal.valueOf(input);
        bdTemp = bdTemp.setScale(2);
        return bdTemp;
    }

    public static final String toFormattedString(BigDecimal bdInput) {
        DecimalFormat df = new DecimalFormat("#,##0.00");
        return df.format(bdInput.doubleValue());
    }
}

