/**
 * Copyright (C) 2014 Sappenin Inc. (developers@sappenin.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.sappenin.utils;

/**
 * Utilities for Converting Exceptions into String for display purposes.
 * 
 * @author David Fuelling
 */
public class StackTraceUtils
{
	/**
	 * Transforms an Exception's StackTrace into a Printable format.
	 * 
	 * @param e
	 * @return
	 */
	public static StringBuilder getStackTrace(Exception e)
	{
		return StackTraceUtils.getStackTrace(e, 0);
	}

	/**
	 * Transforms an Exception's StackTrace into a Printable format.
	 * 
	 * @param e
	 * @return
	 */
	public static StringBuilder getStackTrace(Throwable t)
	{
		return StackTraceUtils.getStackTrace(t, 0);
	}

	/**
	 * Transforms an Exception's StackTrace into a Printable format.
	 * 
	 * @param e
	 * @return
	 */
	public static StringBuilder getStackTrace(Throwable t, int infiniteLoopProtector)
	{
		// Get the StackTrace as a StringBuilder.
		StringBuilder sb = new StringBuilder();

		if (t != null)
		{
			StackTraceElement[] stacks = t.getStackTrace();
			if (stacks != null)
			{
				StackTraceElement tempSTE = null;
				for (StackTraceElement stack : stacks)
				{
					tempSTE = stack;
					if (tempSTE != null)
					{
						sb.append(tempSTE.toString());
						sb.append("\n");
					}
				}
			}

			// Get StackTrace for all embedded Cause Exceptions/Errors.
			t = t.getCause();
			if (infiniteLoopProtector < 10)
			{
				sb.append(StackTraceUtils.getStackTrace(t, infiniteLoopProtector++));
			}
		}

		return sb;
	}
}
