/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.utils;

import com.sappenin.utils.numbers.BDUtils;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BDUtilsTest {
    BigDecimal bd1 = null;
    BigDecimal bd2 = null;

    @Before
    public void setUp() throws Exception {
        this.bd1 = new BigDecimal(5);
        this.bd2 = new BigDecimal(15);
    }

    @Test
    public void testLt() {
        Assert.assertTrue((boolean)BDUtils.lt((BigDecimal)this.bd1, (BigDecimal)this.bd2));
        Assert.assertFalse((boolean)BDUtils.lt((BigDecimal)this.bd2, (BigDecimal)this.bd1));
        Assert.assertFalse((boolean)BDUtils.lt((BigDecimal)this.bd1, (BigDecimal)this.bd1));
        Assert.assertFalse((boolean)BDUtils.lt((BigDecimal)this.bd2, (BigDecimal)this.bd2));
    }

    @Test
    public void testGt() {
        Assert.assertTrue((boolean)BDUtils.gt((BigDecimal)this.bd2, (BigDecimal)this.bd1));
        Assert.assertFalse((boolean)BDUtils.gt((BigDecimal)this.bd1, (BigDecimal)this.bd2));
        Assert.assertFalse((boolean)BDUtils.gt((BigDecimal)this.bd1, (BigDecimal)this.bd1));
        Assert.assertFalse((boolean)BDUtils.gt((BigDecimal)this.bd2, (BigDecimal)this.bd2));
    }

    @Test
    public void testLteq() {
        Assert.assertTrue((boolean)BDUtils.lteq((BigDecimal)this.bd1, (BigDecimal)this.bd2));
        Assert.assertFalse((boolean)BDUtils.lteq((BigDecimal)this.bd2, (BigDecimal)this.bd1));
        Assert.assertTrue((boolean)BDUtils.lteq((BigDecimal)this.bd1, (BigDecimal)this.bd1));
        Assert.assertTrue((boolean)BDUtils.lteq((BigDecimal)this.bd2, (BigDecimal)this.bd2));
    }

    @Test
    public void testGteq() {
        Assert.assertFalse((boolean)BDUtils.gteq((BigDecimal)this.bd1, (BigDecimal)this.bd2));
        Assert.assertTrue((boolean)BDUtils.gteq((BigDecimal)this.bd2, (BigDecimal)this.bd1));
        Assert.assertTrue((boolean)BDUtils.gteq((BigDecimal)this.bd1, (BigDecimal)this.bd1));
        Assert.assertTrue((boolean)BDUtils.gteq((BigDecimal)this.bd2, (BigDecimal)this.bd2));
    }

    @Test
    public void testInvert() {
        BigDecimal tempBD1 = BDUtils.invert((BigDecimal)this.bd1);
        Assert.assertTrue((boolean)BDUtils.lt((BigDecimal)tempBD1, (BigDecimal)BDUtils.bdZero));
        tempBD1 = BDUtils.invert((BigDecimal)tempBD1);
        Assert.assertTrue((boolean)BDUtils.gt((BigDecimal)tempBD1, (BigDecimal)BDUtils.bdZero));
        BigDecimal tempBD2 = BDUtils.invert((BigDecimal)this.bd2);
        Assert.assertTrue((boolean)BDUtils.lt((BigDecimal)tempBD2, (BigDecimal)BDUtils.bdZero));
        tempBD2 = BDUtils.invert((BigDecimal)tempBD2);
        Assert.assertTrue((boolean)BDUtils.gt((BigDecimal)tempBD2, (BigDecimal)BDUtils.bdZero));
        tempBD1 = BDUtils.invert((BigDecimal)this.bd1);
        tempBD2 = BDUtils.invert((BigDecimal)this.bd2);
        Assert.assertTrue((boolean)BDUtils.lt((BigDecimal)tempBD1, (BigDecimal)BDUtils.bdZero));
        Assert.assertTrue((boolean)BDUtils.lt((BigDecimal)tempBD2, (BigDecimal)BDUtils.bdZero));
        Assert.assertTrue((boolean)BDUtils.lt((BigDecimal)tempBD2, (BigDecimal)tempBD1));
        Assert.assertFalse((boolean)BDUtils.lt((BigDecimal)tempBD1, (BigDecimal)tempBD2));
        Assert.assertFalse((boolean)BDUtils.gt((BigDecimal)tempBD2, (BigDecimal)tempBD1));
        Assert.assertTrue((boolean)BDUtils.gt((BigDecimal)tempBD1, (BigDecimal)tempBD2));
    }

    @Test
    public void testBDCreation() {
        this.bd1 = BigDecimal.valueOf(5L);
        this.bd1 = this.bd1.setScale(2);
        this.bd2 = new BigDecimal("5.00");
        this.bd2 = this.bd1.setScale(2);
        Assert.assertTrue((boolean)this.bd1.equals(this.bd2));
        this.bd1 = BigDecimal.valueOf(15L);
        this.bd1 = this.bd1.setScale(2);
        this.bd2 = new BigDecimal("15.00");
        this.bd2 = this.bd1.setScale(2);
        Assert.assertTrue((boolean)this.bd1.equals(this.bd2));
        this.bd1 = BigDecimal.valueOf(35423L);
        this.bd1 = this.bd1.setScale(2);
        this.bd2 = new BigDecimal("35423.00");
        this.bd2 = this.bd1.setScale(2);
        Assert.assertTrue((boolean)this.bd1.equals(this.bd2));
        this.bd1 = BigDecimal.valueOf(2000000000L);
        this.bd1 = this.bd1.setScale(2);
        this.bd2 = new BigDecimal("2000000000.00");
        this.bd2 = this.bd1.setScale(2);
        Assert.assertTrue((boolean)this.bd1.equals(this.bd2));
        this.bd1 = BigDecimal.valueOf(5L);
        this.bd1 = this.bd1.setScale(2);
        this.bd2 = new BigDecimal("5");
        this.bd2 = this.bd1.setScale(2);
        Assert.assertTrue((boolean)this.bd1.equals(this.bd2));
        this.bd1 = BigDecimal.valueOf(15L);
        this.bd1 = this.bd1.setScale(2);
        this.bd2 = new BigDecimal("15");
        this.bd2 = this.bd1.setScale(2);
        Assert.assertTrue((boolean)this.bd1.equals(this.bd2));
        this.bd1 = BigDecimal.valueOf(35423L);
        this.bd1 = this.bd1.setScale(2);
        this.bd2 = new BigDecimal("35423");
        this.bd2 = this.bd1.setScale(2);
        Assert.assertTrue((boolean)this.bd1.equals(this.bd2));
        this.bd1 = BigDecimal.valueOf(2000000000L);
        this.bd1 = this.bd1.setScale(2);
        this.bd2 = new BigDecimal("2000000000");
        this.bd2 = this.bd1.setScale(2);
        Assert.assertTrue((boolean)this.bd1.equals(this.bd2));
    }

    @Test
    public void testBDStringFormatting() {
        this.bd1 = BigDecimal.valueOf(5L);
        Assert.assertTrue((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("5.00"));
        this.bd1 = new BigDecimal("5.00");
        Assert.assertTrue((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("5.00"));
        this.bd1 = BigDecimal.valueOf(15L);
        Assert.assertTrue((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("15.00"));
        this.bd1 = new BigDecimal("15.00");
        Assert.assertTrue((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("15.00"));
        this.bd1 = BigDecimal.valueOf(35423L);
        Assert.assertTrue((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("35,423.00"));
        this.bd1 = new BigDecimal("35423.00");
        Assert.assertTrue((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("35,423.00"));
        this.bd1 = BigDecimal.valueOf(2000000000L);
        Assert.assertTrue((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("2,000,000,000.00"));
        this.bd1 = new BigDecimal("2000000000.00");
        Assert.assertTrue((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("2,000,000,000.00"));
        this.bd1 = BigDecimal.valueOf(5L);
        Assert.assertFalse((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("5"));
        this.bd1 = new BigDecimal("5.00");
        Assert.assertFalse((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("5"));
        this.bd1 = BigDecimal.valueOf(15L);
        Assert.assertFalse((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("15"));
        this.bd1 = new BigDecimal("15.00");
        Assert.assertFalse((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("15"));
        this.bd1 = BigDecimal.valueOf(35423L);
        Assert.assertFalse((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("35,423"));
        this.bd1 = new BigDecimal("35423.00");
        Assert.assertFalse((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("35,423"));
        this.bd1 = BigDecimal.valueOf(2000000000L);
        Assert.assertFalse((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("2,000,000,000"));
        this.bd1 = new BigDecimal("2000000000.00");
        Assert.assertFalse((boolean)BDUtils.toFormattedString((BigDecimal)this.bd1).equals("2,000,000,000"));
    }
}

