/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.utils.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public interface JsonUtils {
    public <P> String toJson(P var1) throws JsonProcessingException;

    public <P> String toJsonUnchecked(P var1) throws RuntimeException;

    public <P> P fromJson(HttpServletRequest var1) throws IOException, ClassNotFoundException;

    public <P> P fromJson(JsonNode var1) throws ClassNotFoundException;

    public JsonNode getJsonContentFromRequest(HttpServletRequest var1) throws IOException, ClassNotFoundException;

    public static class Impl
    implements JsonUtils {
        protected static final Logger logger = Logger.getLogger(Impl.class.getName());
        private final ObjectMapper objectMapper;

        public Impl(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public <T> String toJson(T payload) throws JsonProcessingException {
            Preconditions.checkNotNull(payload);
            String jsonString = this.objectMapper.writeValueAsString(payload);
            return jsonString;
        }

        @Override
        public <P> String toJsonUnchecked(P payload) throws RuntimeException {
            try {
                return this.toJson((T)payload);
            }
            catch (JsonProcessingException jpe) {
                throw new RuntimeException(jpe);
            }
        }

        @Override
        public <P> P fromJson(JsonNode jsonNode) throws ClassNotFoundException {
            Preconditions.checkNotNull((Object)jsonNode);
            logger.info("Converting to Java Class from the following JsonNode: \"" + jsonNode + "\"");
            JsonNode classNameJsonNode = jsonNode.get("@class");
            Preconditions.checkNotNull((Object)classNameJsonNode, (Object)"Cannot DeSerialize Json using this method without an @Class node!");
            Class<?> payloadClass = Class.forName(classNameJsonNode.asText().toString());
            Object payload = this.objectMapper.convertValue((Object)jsonNode, payloadClass);
            return (P)payload;
        }

        @Override
        public JsonNode getJsonContentFromRequest(HttpServletRequest request) throws IOException, ClassNotFoundException {
            Preconditions.checkNotNull((Object)request);
            String jsonPayload = null;
            try (ServletInputStream stream = request.getInputStream();){
                jsonPayload = CharStreams.toString((Readable)new InputStreamReader((InputStream)stream, Charsets.UTF_8));
            }
            Preconditions.checkNotNull((Object)jsonPayload);
            logger.info("Retrieved the following JSON Payload from HttpServletRequest: \"" + jsonPayload + "\"");
            JsonParser jp = this.objectMapper.getFactory().createParser(jsonPayload);
            JsonNode jsonNode = (JsonNode)this.objectMapper.readTree(jp);
            return jsonNode;
        }

        @Override
        public <P> P fromJson(HttpServletRequest request) throws IOException, ClassNotFoundException {
            Preconditions.checkNotNull((Object)request);
            JsonNode jsonNode = this.getJsonContentFromRequest(request);
            return this.fromJson(jsonNode);
        }
    }
}

