/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.utils.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.sappenin.utils.json.JsonUtilsClassTypeMapper;

public class JsonUtilsClassTypeMapperForJackson
implements JsonUtilsClassTypeMapper {
    public static final String KIND = "kind";
    public static final String AT_CLASS = "@class";
    private final String jsonTypeAttributeName;

    public JsonUtilsClassTypeMapperForJackson() {
        this.jsonTypeAttributeName = AT_CLASS;
    }

    public JsonUtilsClassTypeMapperForJackson(String jsonTypeAttributeName) {
        Preconditions.checkNotNull((Object)jsonTypeAttributeName);
        this.jsonTypeAttributeName = jsonTypeAttributeName;
    }

    public Class<?> getJsonClassType(JsonNode jsonNode) {
        JsonNode classNameJsonNode = jsonNode.get(this.jsonTypeAttributeName);
        Preconditions.checkNotNull((Object)classNameJsonNode, (Object)String.format("Cannot DeSerialize polymorphic JSON payload via Jackson when the Payload has no @JsonTypeInfo with 'property' value of '%s' specified!", this.jsonTypeAttributeName));
        try {
            Class<?> payloadClass = Class.forName(classNameJsonNode.asText());
            return payloadClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

