/**
 * Copyright (C) 2014 Sappenin Inc. (developers@sappenin.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.sappenin.utils;

import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * A typed Id that holds a String identifier for use in Java Api's.
 * 
 * @param <T>
 *
 * @author David Fuelling
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class StringId<T> extends Id<String>
{
	public StringId(final String id)
	{
		super(id);
	}

	/**
	 * Helper method to create an instance of {@link StringId}.
	 * 
	 * @param id
	 * @return
	 */
	public static <T> StringId<T> of(final String id)
	{
		return new StringId<T>(id);
	}
}
