package com.sappenin.utils.json;

import com.fasterxml.jackson.databind.JsonNode;

/**
 * An interface for defining how an instance of {@link JsonNode} can be
 * transformed into a typed {@link Class}.
 */
public interface JsonUtilsClassTypeMapper
{
	/**
	 * Return the class value that the Jackson library should deserialize the
	 * {@code jsonNode} to. For example, if a payload had the following
	 * annotation values, then an implementation of this interface would convert
	 * the value found in the "kind" attribute to an actual {@link Class}. <br/>
	 * 
	 * <pre>
	 * 	 @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
	 * </pre>
	 * 
	 * @see "http://stackoverflow.com/questions/4838608/use-different-bean-class-in-jackson-json-based-on-variable"
	 * @return
	 */
	<T> Class<T> getJsonClassType(final JsonNode jsonNode);
}
