/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.utils.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sappenin.utils.json.JsonUtils;
import com.sappenin.utils.json.JsonUtilsClassTypeMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class JsonUtilsImplTest {
    private static final String PAYLOAD_JSON_STRING = "{\"name\":\"Test Name\",\"numThings\":3}";
    private static final String PAYLOAD_JSON_STRING_JACKSON = "{\"@class\":\"com.sappenin.utils.json.JsonUtilsImplTest$JacksonPayload\",\"name\":\"Test Name\",\"numThings\":3}";
    private ObjectMapper objectMapper;
    private HttpServletRequest httpServletRequest;
    private JsonUtils jsonUtils;
    private JsonUtils.Impl jsonUtilsImpl;

    @Before
    public void setUp() throws Exception {
        this.httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(PAYLOAD_JSON_STRING.getBytes(StandardCharsets.UTF_8));
        ServletInputStream servletInputStream = new ServletInputStream(){

            public int read() throws IOException {
                return inputStream.read();
            }
        };
        Mockito.when((Object)this.httpServletRequest.getInputStream()).thenReturn((Object)servletInputStream);
        this.objectMapper = new ObjectMapper();
        this.jsonUtilsImpl = new JsonUtils.Impl(this.objectMapper);
        this.jsonUtils = this.jsonUtilsImpl;
    }

    @Test(expected=NullPointerException.class)
    public void testToJsonNull() throws Exception {
        this.jsonUtils.toJson(null);
    }

    @Test
    public void testToJson_Payload() throws Exception {
        Payload payload = this.getTestablePayload();
        String json = this.jsonUtils.toJson((Object)payload);
        Assert.assertThat((Object)json, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)json, (Matcher)Is.is((Object)PAYLOAD_JSON_STRING));
    }

    @Test
    public void testToJson_JacksonPayload() throws Exception {
        JacksonPayload jacksonPayload = this.getTestableJacksonPayload();
        String json = this.jsonUtils.toJson((Object)jacksonPayload);
        Assert.assertThat((Object)json, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)json, (Matcher)Is.is((Object)PAYLOAD_JSON_STRING_JACKSON));
    }

    @Test(expected=NullPointerException.class)
    public void testToJsonUnchecked_Null() throws Exception {
        this.jsonUtils.toJsonUnchecked(null);
    }

    @Test
    public void testToJsonUnchecked() throws Exception {
        Payload payload = this.getTestablePayload();
        String json = this.jsonUtils.toJsonUnchecked((Object)payload);
        Assert.assertThat((Object)json, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)json, (Matcher)Is.is((Object)PAYLOAD_JSON_STRING));
    }

    @Test(expected=NullPointerException.class)
    public void testFromJson_HttpServletRequest_NullHttpServletRequest() throws Exception {
        HttpServletRequest httpServletRequest = null;
        JsonUtilsClassTypeMapper jsonUtilsTypeMapper = (JsonUtilsClassTypeMapper)Mockito.mock(JsonUtilsClassTypeMapper.class);
        this.jsonUtils.fromJson(httpServletRequest, jsonUtilsTypeMapper);
    }

    @Test(expected=NullPointerException.class)
    public void testFromJson_HttpServletRequest_NullJsonNode() throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        JsonUtilsClassTypeMapper jsonUtilsTypeMapper = null;
        this.jsonUtils.fromJson(httpServletRequest, jsonUtilsTypeMapper);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromJson_InvalidJacksonClassType() throws Exception {
        JsonUtilsClassTypeMapper jsonUtilsTypeMapper = new JsonUtilsClassTypeMapper(){

            public Class<String> getJsonClassType(JsonNode jsonNode) {
                return String.class;
            }
        };
        Payload payload = (Payload)this.jsonUtils.fromJson(this.httpServletRequest, jsonUtilsTypeMapper);
        Assert.assertThat((Object)payload, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)payload.getName(), (Matcher)Is.is((Object)"Test Name"));
        Assert.assertThat((Object)payload.getNumThings(), (Matcher)Is.is((Object)3L));
    }

    @Test
    public void testFromJson() throws Exception {
        JsonUtilsClassTypeMapper jsonUtilsTypeMapper = new JsonUtilsClassTypeMapper(){

            public Class<Payload> getJsonClassType(JsonNode jsonNode) {
                return Payload.class;
            }
        };
        Payload payload = (Payload)this.jsonUtils.fromJson(this.httpServletRequest, jsonUtilsTypeMapper);
        Assert.assertThat((Object)payload, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)payload.getName(), (Matcher)Is.is((Object)"Test Name"));
        Assert.assertThat((Object)payload.getNumThings(), (Matcher)Is.is((Object)3L));
    }

    @Test(expected=NullPointerException.class)
    public void testFromJson_JsonNode_NullJsonNode() throws Exception {
        JsonNode jsonNodeMock = null;
        Class<Payload> payloadClass = Payload.class;
        this.jsonUtils.fromJson(jsonNodeMock, payloadClass);
    }

    @Test(expected=NullPointerException.class)
    public void testFromJson_JsonNode_NullPayloadClass() throws Exception {
        JsonNode jsonNodeMock = (JsonNode)Mockito.mock(JsonNode.class);
        Class payloadClass = null;
        this.jsonUtils.fromJson(jsonNodeMock, payloadClass);
    }

    @Test
    public void testFromJson_JsonNode_NoJackson() throws Exception {
        JsonNode jsonNode = this.getJsonNodeFromJsonString(PAYLOAD_JSON_STRING);
        Class<Payload> payloadClass = Payload.class;
        Payload actualPayload = (Payload)this.jsonUtils.fromJson(jsonNode, payloadClass);
        Assert.assertThat((Object)actualPayload, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)actualPayload.getName(), (Matcher)Is.is((Object)"Test Name"));
        Assert.assertThat((Object)actualPayload.getNumThings(), (Matcher)Is.is((Object)3L));
    }

    @Test
    public void testFromJson_JsonNode_UseJacksonAnnotations() throws Exception {
        JsonNode jsonNode = this.getJsonNodeFromJsonString(PAYLOAD_JSON_STRING_JACKSON);
        Class<JacksonPayload> jacksonPayloadClass = JacksonPayload.class;
        JacksonPayload actualPayload = (JacksonPayload)this.jsonUtils.fromJson(jsonNode, jacksonPayloadClass);
        Assert.assertThat((Object)actualPayload, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)actualPayload.getName(), (Matcher)Is.is((Object)"Test Name"));
        Assert.assertThat((Object)actualPayload.getNumThings(), (Matcher)Is.is((Object)3L));
    }

    @Test(expected=NullPointerException.class)
    public void testFromJson_JsonNodeWithMapper_NullJsonUtilsClassTypeMapper() throws Exception {
        JsonNode jsonNodeMock = null;
        JsonUtilsClassTypeMapper jsonUtilsClassTypeMapper = (JsonUtilsClassTypeMapper)Mockito.mock(JsonUtilsClassTypeMapper.class);
        this.jsonUtils.fromJson(jsonNodeMock, jsonUtilsClassTypeMapper);
    }

    @Test(expected=NullPointerException.class)
    public void testFromJson_JsonNodeWithMapper_NullOptPayloadClass() throws Exception {
        JsonNode jsonNodeMock = (JsonNode)Mockito.mock(JsonNode.class);
        JsonUtilsClassTypeMapper jsonUtilsClassTypeMapper = null;
        this.jsonUtils.fromJson(jsonNodeMock, jsonUtilsClassTypeMapper);
    }

    @Test
    public void testFromJson_JsonNodeWithMapper_NoJackson() throws Exception {
        JsonNode jsonNode = this.getJsonNodeFromJsonString(PAYLOAD_JSON_STRING);
        JsonUtilsClassTypeMapper jsonUtilsClassTypeMapper = new JsonUtilsClassTypeMapper(){

            public Class<Payload> getJsonClassType(JsonNode jsonNode) {
                return Payload.class;
            }
        };
        Payload actualPayload = (Payload)this.jsonUtils.fromJson(jsonNode, jsonUtilsClassTypeMapper);
        Assert.assertThat((Object)actualPayload, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)actualPayload.getName(), (Matcher)Is.is((Object)"Test Name"));
        Assert.assertThat((Object)actualPayload.getNumThings(), (Matcher)Is.is((Object)3L));
    }

    @Test
    public void testFromJson_JsonNodeWithMapper_UseJacksonAnnotations() throws Exception {
        JsonNode jsonNode = this.getJsonNodeFromJsonString(PAYLOAD_JSON_STRING_JACKSON);
        JsonUtilsClassTypeMapper jsonUtilsClassTypeMapper = new JsonUtilsClassTypeMapper(){

            public Class<JacksonPayload> getJsonClassType(JsonNode jsonNode) {
                return JacksonPayload.class;
            }
        };
        JacksonPayload actualPayload = (JacksonPayload)this.jsonUtils.fromJson(jsonNode, jsonUtilsClassTypeMapper);
        Assert.assertThat((Object)actualPayload, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)actualPayload.getName(), (Matcher)Is.is((Object)"Test Name"));
        Assert.assertThat((Object)actualPayload.getNumThings(), (Matcher)Is.is((Object)3L));
    }

    @Test(expected=NullPointerException.class)
    public void testGetRequestPayloadAsJsonNode_NullHttpServletRequest() throws Exception {
        this.jsonUtilsImpl.getRequestPayloadAsJsonNode(null);
    }

    @Test
    public void testGetRequestPayloadAsJsonNode() throws Exception {
        JsonNode actualPayload = this.jsonUtilsImpl.getRequestPayloadAsJsonNode(this.httpServletRequest);
        Assert.assertThat((Object)actualPayload, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)actualPayload.get("name").toString(), (Matcher)Is.is((Object)"\"Test Name\""));
        Assert.assertThat((Object)actualPayload.get("numThings").asLong(), (Matcher)Is.is((Object)3L));
    }

    @Test(expected=NullPointerException.class)
    public void testGetRequestPayloadAsJsonString_NullHttpServletRequest() throws Exception {
        HttpServletRequest nullHttpServletRequest = null;
        this.jsonUtilsImpl.getRequestPayloadAsJsonString(nullHttpServletRequest);
    }

    @Test
    public void testGetRequestPayloadAsJsonString() throws Exception {
        String actualPayload = this.jsonUtilsImpl.getRequestPayloadAsJsonString(this.httpServletRequest);
        Assert.assertThat((Object)actualPayload, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)actualPayload, (Matcher)Is.is((Object)PAYLOAD_JSON_STRING));
    }

    @Test(expected=NullPointerException.class)
    public void testGetRequestPayloadAsJsonString_InputStream_Null() throws Exception {
        InputStream inputStream = null;
        this.jsonUtilsImpl.getRequestPayloadAsJsonString(inputStream);
    }

    @Test
    public void testGetRequestPayloadAsJsonString_InputStream() throws Exception {
        String actualPayload = this.jsonUtilsImpl.getRequestPayloadAsJsonString((InputStream)this.httpServletRequest.getInputStream());
        Assert.assertThat((Object)actualPayload, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)actualPayload, (Matcher)Is.is((Object)PAYLOAD_JSON_STRING));
    }

    private Payload getTestablePayload() {
        return new Payload("Test Name", 3L);
    }

    private JacksonPayload getTestableJacksonPayload() {
        return new JacksonPayload("Test Name", 3L);
    }

    private JsonNode getJsonNodeFromJsonString(String jsonString) throws IOException {
        JsonParser jp = this.objectMapper.getFactory().createParser(jsonString);
        JsonNode jsonNode = (JsonNode)this.objectMapper.readTree(jp);
        return jsonNode;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    private static final class JacksonPayload {
        private final String name;
        private final long numThings;

        public JacksonPayload(@JsonProperty(value="name") String name, @JsonProperty(value="numThings") long numThings) {
            this.name = name;
            this.numThings = numThings;
        }

        public String getName() {
            return this.name;
        }

        public long getNumThings() {
            return this.numThings;
        }
    }

    private static final class Payload {
        private final String name;
        private final long numThings;

        public Payload(@JsonProperty(value="name") String name, @JsonProperty(value="numThings") long numThings) {
            this.name = name;
            this.numThings = numThings;
        }

        public String getName() {
            return this.name;
        }

        public long getNumThings() {
            return this.numThings;
        }
    }
}

