/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.utils.json.jackson.mappers.modules;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sappenin.utils.json.jackson.mappers.modules.LowerEnumModule;
import java.beans.ConstructorProperties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class LowerEnumModuleTest {
    private ObjectMapper objectMapper;

    @Before
    public void setUp() throws Exception {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new LowerEnumModule());
    }

    @Test
    public void testSerializeDeserializeEnum() throws Exception {
        TestClass foos = new TestClass(Foo.BIG);
        String serializedHrefUrl = this.objectMapper.writeValueAsString((Object)foos);
        MatcherAssert.assertThat((Object)serializedHrefUrl, (Matcher)CoreMatchers.is((Object)"{\"foo\":\"big\"}"));
        TestClass deserializedTestClass = (TestClass)this.objectMapper.readValue(serializedHrefUrl, TestClass.class);
        MatcherAssert.assertThat((Object)((Object)deserializedTestClass.getFoo()), (Matcher)CoreMatchers.is((Object)((Object)foos.getFoo())));
    }

    public static enum Foo {
        BIG;

    }

    private static final class TestClass {
        @JsonProperty(value="foo")
        private final Foo foo;

        private TestClass() {
            this.foo = null;
        }

        public Foo getFoo() {
            return this.foo;
        }

        @ConstructorProperties(value={"foo"})
        public TestClass(Foo foo) {
            this.foo = foo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestClass)) {
                return false;
            }
            TestClass other = (TestClass)o;
            Foo this$foo = this.getFoo();
            Foo other$foo = other.getFoo();
            return !(this$foo == null ? other$foo != null : !((Object)((Object)this$foo)).equals((Object)other$foo));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Foo $foo = this.getFoo();
            result = result * 59 + ($foo == null ? 43 : ((Object)((Object)$foo)).hashCode());
            return result;
        }

        public String toString() {
            return "LowerEnumModuleTest.TestClass(foo=" + (Object)((Object)this.getFoo()) + ")";
        }
    }
}

