/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.utils;

public class StackTraceUtils {
    public static StringBuilder getStackTrace(Exception e) {
        return StackTraceUtils.getStackTrace(e, 0);
    }

    public static StringBuilder getStackTrace(Throwable t) {
        return StackTraceUtils.getStackTrace(t, 0);
    }

    public static StringBuilder getStackTrace(Throwable t, int infiniteLoopProtector) {
        StringBuilder sb = new StringBuilder();
        if (t != null) {
            StackTraceElement[] stacks = t.getStackTrace();
            if (stacks != null) {
                StackTraceElement tempSTE = null;
                for (StackTraceElement stack : stacks) {
                    tempSTE = stack;
                    if (tempSTE == null) continue;
                    sb.append(tempSTE.toString());
                    sb.append("\n");
                }
            }
            t = t.getCause();
            if (infiniteLoopProtector < 10) {
                sb.append((CharSequence)StackTraceUtils.getStackTrace(t, infiniteLoopProtector++));
            }
        }
        return sb;
    }
}

