/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.utils.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sappenin.utils.json.JsonUtilsClassTypeMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public interface JsonUtils {
    public <P> String toJson(P var1) throws JsonProcessingException;

    public <P> String toJsonUnchecked(P var1) throws RuntimeException;

    public <P> P fromJson(HttpServletRequest var1, JsonUtilsClassTypeMapper var2) throws IOException, ClassNotFoundException;

    public <P> P fromJson(JsonNode var1, Class<P> var2) throws ClassNotFoundException;

    public <P> P fromJson(JsonNode var1, JsonUtilsClassTypeMapper var2) throws ClassNotFoundException;

    public static class Impl
    implements JsonUtils {
        protected static final Logger logger = Logger.getLogger(Impl.class.getName());
        private final ObjectMapper objectMapper;

        public Impl(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public <T> String toJson(T payload) throws JsonProcessingException {
            Preconditions.checkNotNull(payload);
            String jsonString = this.objectMapper.writeValueAsString(payload);
            return jsonString;
        }

        @Override
        public <P> String toJsonUnchecked(P payload) throws RuntimeException {
            try {
                return this.toJson((T)payload);
            }
            catch (JsonProcessingException jpe) {
                throw new RuntimeException(jpe);
            }
        }

        @Override
        public <P> P fromJson(JsonNode jsonNode, JsonUtilsClassTypeMapper jsonUtilsClassTypeMapper) throws ClassNotFoundException {
            Preconditions.checkNotNull((Object)jsonNode);
            Preconditions.checkNotNull((Object)jsonUtilsClassTypeMapper);
            Class jsonPayloadClass = jsonUtilsClassTypeMapper.getJsonClassType(jsonNode);
            return (P)this.fromJson(jsonNode, jsonPayloadClass);
        }

        @Override
        public <P> P fromJson(JsonNode jsonNode, Class<P> jsonNodeClass) throws ClassNotFoundException {
            Preconditions.checkNotNull((Object)jsonNode);
            Preconditions.checkNotNull(jsonNodeClass);
            logger.info(String.format("Converting the JsonNode \"%s\" to a Java Class of type: \"%s\"))", jsonNode, jsonNodeClass.getName()));
            Object payload = this.objectMapper.convertValue((Object)jsonNode, jsonNodeClass);
            return (P)payload;
        }

        @Override
        public <P> P fromJson(HttpServletRequest httpServletRequest, JsonUtilsClassTypeMapper jsonUtilsClassTypeMapper) throws IOException, ClassNotFoundException {
            Preconditions.checkNotNull((Object)httpServletRequest);
            JsonNode jsonNode = this.getRequestPayloadAsJsonNode(httpServletRequest);
            return this.fromJson(jsonNode, jsonUtilsClassTypeMapper);
        }

        @VisibleForTesting
        protected JsonNode getRequestPayloadAsJsonNode(HttpServletRequest request) throws IOException, ClassNotFoundException {
            Preconditions.checkNotNull((Object)request);
            String jsonPayload = this.getRequestPayloadAsJsonString(request);
            JsonParser jp = this.objectMapper.getFactory().createParser(jsonPayload);
            JsonNode jsonNode = (JsonNode)this.objectMapper.readTree(jp);
            return jsonNode;
        }

        @VisibleForTesting
        protected String getRequestPayloadAsJsonString(HttpServletRequest httpServletRequest) throws IOException {
            Preconditions.checkNotNull((Object)httpServletRequest);
            return this.getRequestPayloadAsJsonString((InputStream)httpServletRequest.getInputStream());
        }

        /*
         * Exception decompiling
         */
        @VisibleForTesting
        protected String getRequestPayloadAsJsonString(InputStream inputStream) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

