/**
 * Copyright (C) 2014 Sappenin Inc. (developers@sappenin.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.sappenin.utils;

import java.util.UUID;

/**
 * A utility class used for creating globally unique indentifiers (UUID). Note
 * that this interface's conception is not the same as that of the {@link UUID}
 * class, although implementations will generally use that class as a
 * foundation.
 * 
 * @author David Fuelling
 */
public interface UuidUtils
{
	/**
	 * Create a Universally Unique Identifier (as a String) that contains only
	 * latin characters (i.e., no dashes).
	 * 
	 * @return
	 */
	String randomUUID();

	/**
	 * An implementation of {@link UuidUtils}.
	 */
	class Impl implements UuidUtils
	{
		@Override
		public String randomUUID()
		{
			return UUID.randomUUID().toString().replace("-", "");
		}
	}
}
