/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.utils.json.jackson.mappers.modules;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sappenin.utils.json.jackson.mappers.modules.HttpUrlModule;
import com.squareup.okhttp.HttpUrl;
import java.beans.ConstructorProperties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class HttpUrlModuleTest {
    private ObjectMapper objectMapper;

    @Before
    public void setUp() throws Exception {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new HttpUrlModule());
    }

    @Test
    public void testSerializeDeserializeHttpUrl() throws Exception {
        Earl earl = new Earl(HttpUrl.parse((String)"https://api.example.com/foo"));
        String serializedHrefUrl = this.objectMapper.writeValueAsString((Object)earl);
        MatcherAssert.assertThat((Object)serializedHrefUrl, (Matcher)CoreMatchers.is((Object)"{\"href\":\"https://api.example.com/foo\"}"));
        Earl deserializedEarl = (Earl)this.objectMapper.readValue(serializedHrefUrl, Earl.class);
        MatcherAssert.assertThat((Object)deserializedEarl.getHref(), (Matcher)CoreMatchers.is((Object)earl.getHref()));
    }

    @Test
    public void testSerializeDeserializeHttpUrl_WeirdEncoding() throws Exception {
        Earl earl = new Earl(HttpUrl.parse((String)"https://api.example.com").newBuilder().addEncodedPathSegment("foo").addEncodedPathSegment("http:%2F%2Fwww.cnn.com%2Fstory%2F123").build());
        String serializedHrefUrl = this.objectMapper.writeValueAsString((Object)earl);
        MatcherAssert.assertThat((Object)serializedHrefUrl, (Matcher)CoreMatchers.is((Object)"{\"href\":\"https://api.example.com/foo/http:%2F%2Fwww.cnn.com%2Fstory%2F123\"}"));
        Earl deserializedEarl = (Earl)this.objectMapper.readValue(serializedHrefUrl, Earl.class);
        MatcherAssert.assertThat((Object)deserializedEarl.getHref(), (Matcher)CoreMatchers.is((Object)earl.getHref()));
    }

    @Test
    public void testSerializeDeserializeHttpUrl_MandarinEncoding() throws Exception {
        Earl earl = new Earl(HttpUrl.parse((String)"https://api.example.com").newBuilder().addEncodedPathSegment("foo").addEncodedPathSegment("\u8bf6\u6bd4\u897f\u8fea\u4f0a").build());
        String serializedHrefUrl = this.objectMapper.writeValueAsString((Object)earl);
        MatcherAssert.assertThat((Object)serializedHrefUrl, (Matcher)CoreMatchers.is((Object)"{\"href\":\"https://api.example.com/foo/%E8%AF%B6%E6%AF%94%E8%A5%BF%E8%BF%AA%E4%BC%8A\"}"));
        Earl deserializedEarl = (Earl)this.objectMapper.readValue(serializedHrefUrl, Earl.class);
        MatcherAssert.assertThat((Object)deserializedEarl.getHref(), (Matcher)CoreMatchers.is((Object)earl.getHref()));
    }

    private static final class Earl {
        private final HttpUrl href;

        private Earl() {
            this.href = null;
        }

        public HttpUrl getHref() {
            return this.href;
        }

        @ConstructorProperties(value={"href"})
        public Earl(HttpUrl href) {
            this.href = href;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Earl)) {
                return false;
            }
            Earl other = (Earl)o;
            HttpUrl this$href = this.getHref();
            HttpUrl other$href = other.getHref();
            return !(this$href == null ? other$href != null : !this$href.equals(other$href));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            HttpUrl $href = this.getHref();
            result = result * 59 + ($href == null ? 43 : $href.hashCode());
            return result;
        }

        public String toString() {
            return "HttpUrlModuleTest.Earl(href=" + this.getHref() + ")";
        }
    }
}

