/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.utils.json.jackson.mappers.modules.serializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.lang.reflect.Method;

public class LowerEnumDeserializer
extends StdScalarDeserializer<Enum<?>> {
    private static final long serialVersionUID = 1L;

    public LowerEnumDeserializer(Class<Enum<?>> clazz) {
        super(clazz);
    }

    public Enum<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String text = jp.getText().toUpperCase();
        try {
            Method valueOfMethod = this.handledType().getDeclaredMethod("valueOf", String.class);
            return (Enum)valueOfMethod.invoke(null, text);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot deserialize enum " + this.handledType().getName() + " from " + text, e);
        }
    }
}

