/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.utils.servletfilters;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public abstract class RequestHeadersLoggingFilter
implements Filter {
    protected abstract Set<String> getObfuscatedHeaderNames();

    protected abstract Logger getLogger();

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            StringBuilder sbHeaders = new StringBuilder();
            sbHeaders.append("Request Headers: ");
            Enumeration headerNames = httpServletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = headerNames.nextElement().toString();
                if (headerName == null) continue;
                String headerValue = this.getObfuscatedHeaderNames().contains(headerName.toLowerCase(Locale.ENGLISH)) ? "**********" : httpServletRequest.getHeader(headerName);
                sbHeaders.append(String.format("\n%s: %s", headerName, headerValue));
            }
            this.getLogger().info(sbHeaders.toString());
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

