/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.utils;

import RefData.LEI.Header;
import RefData.LEI.OtherEntityName;
import RefData.LEI.Record;
import com.schemarise.alfa.runtime.Alfa;
import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.codec.json.JsonCodecConfig;
import com.schemarise.alfa.runtime.utils.AlfaRandomizer;
import com.schemarise.alfa.utils.testing.AlfaFunSuite;
import java.io.Serializable;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001i1AAA\u0002\u0001\u001d!)a\u0003\u0001C\u0001/\tI!j]8o)\u0016\u001cHo\u001d\u0006\u0003\t\u0015\tQ!\u001e;jYNT!AB\u0004\u0002\u000fI,h\u000e^5nK*\u0011\u0001\"C\u0001\u0005C24\u0017M\u0003\u0002\u000b\u0017\u0005Q1o\u00195f[\u0006\u0014\u0018n]3\u000b\u00031\t1aY8n\u0007\u0001\u0019\"\u0001A\b\u0011\u0005A!R\"A\t\u000b\u0005I\u0019\u0012a\u0002;fgRLgn\u001a\u0006\u0003\t\u001dI!!F\t\u0003\u0019\u0005cg-\u0019$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005A\u0002CA\r\u0001\u001b\u0005\u0019\u0001")
public class JsonTests
extends AlfaFunSuite {
    public JsonTests() {
        this.test("JSON encode decode A", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            AlfaRandomizer r = new AlfaRandomizer();
            Header a = (Header)r.random(Header.HeaderDescriptor.TYPE_NAME);
            JsonCodecConfig cc = JsonCodecConfig.builder().setWriteChecksum(true).setIgnoreDateFormat(true).build();
            String json = Alfa.jsonCodec().toFormattedJson(cc, (AlfaObject)a);
            System.out.println(json);
            Header obj = (Header)Alfa.jsonCodec().fromJsonString(cc, json);
            String mock = new StringOps(Predef$.MODULE$.augmentString("\n        |{\n        |  \"$type\" : \"RefData.LEI.Header\",\n        |  \"$csum\" : \"f4548csa:\",\n        |  \"ContentDate\" : \"1548-06-11T11:51:58\",\n        |  \"Originator\" : \"jtfha\",\n        |  \"FileContent\" : \"ywbjk\",\n        |  \"RecordCount\" : \"48963906631338742\"\n        |}\n      ")).stripMargin();
            return this.assertThrows((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Alfa.jsonCodec().fromJsonString(cc, mock), ClassTag$.MODULE$.apply(AlfaRuntimeException.class), new Position("JsonTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        }, new Position("JsonTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 10));
        this.test("JSON encode decode B", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            AlfaRandomizer r = new AlfaRandomizer();
            Record a = (Record)r.random(Record.RecordDescriptor.TYPE_NAME);
            JsonCodecConfig cc = JsonCodecConfig.builder().setWriteChecksum(true).setIgnoreDateFormat(true).build();
            String json = Alfa.jsonCodec().toFormattedJson(cc, (AlfaObject)a);
            System.out.println(json);
            Record obj = (Record)Alfa.jsonCodec().fromJsonString(cc, json);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(obj.equals(a), "obj.equals(a)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JsonTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        }, new Position("JsonTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("JSON encode decode C", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            OtherEntityName a = OtherEntityName.builder().setType("AAA").setValue("BBB").build();
            JsonCodecConfig cc = JsonCodecConfig.builder().setWriteChecksum(true).setIgnoreDateFormat(true).build();
            String json = Alfa.jsonCodec().toFormattedJson(cc, (AlfaObject)a);
            String $org_scalatest_assert_macro_left = a.descriptor().getChecksum();
            String $org_scalatest_assert_macro_right = "3ea048cd:a1823582";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JsonTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            Predef$.MODULE$.println((Object)json);
            String modAllCheckSum = new StringOps(Predef$.MODULE$.augmentString("\n        |{\n        |  \"$type\" : \"RefData.LEI.OtherEntityName\",\n        |  \"$csum\" : \"3ea048cxx:a1823582\",\n        |  \"type\" : \"AAA\",\n        |  \"Value\" : \"BBB\"\n        |}\n      ")).stripMargin();
            OtherEntityName obj = (OtherEntityName)Alfa.jsonCodec().fromJsonString(cc, modAllCheckSum);
            String modAllAndMandCheckSum = new StringOps(Predef$.MODULE$.augmentString("\n        |{\n        |  \"$type\" : \"RefData.LEI.OtherEntityName\",\n        |  \"$csum\" : \"3ea048cxx:a18235xx\",\n        |  \"type\" : \"AAA\",\n        |  \"Value\" : \"BBB\"\n        |}\n      ")).stripMargin();
            return this.assertThrows((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Alfa.jsonCodec().fromJsonString(cc, modAllAndMandCheckSum), ClassTag$.MODULE$.apply(AlfaRuntimeException.class), new Position("JsonTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        }, new Position("JsonTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
    }
}

