/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.utils;

import com.schemarise.alfa.runtime.Alfa;
import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.ITable;
import com.schemarise.alfa.runtime.IValidationListener;
import com.schemarise.alfa.runtime.ValidationCollectingListener;
import com.schemarise.alfa.runtime.codec.CodecConfig;
import com.schemarise.alfa.runtime.codec.Converters;
import com.schemarise.alfa.runtime.codec.table.TableCodec;
import com.schemarise.alfa.runtime.utils.AlfaRandomizer;
import com.schemarise.alfa.runtime.utils.AlfaUtils;
import com.schemarise.alfa.runtime_int.table.Table;
import com.schemarise.alfa.utils.testing.TestUtils;
import flattentest.DeeplyNestedVectors;
import flattentest.EntityObj;
import flattentest.EntityObjKey;
import flattentest.FlatObj;
import flattentest.PlainObj;
import flattentest.RecOfUnions;
import flattentest.SampleEnum;
import flattentest.SampleTraitImplA;
import flattentest.SampleTraitImplB;
import flattentest.SimpleObj;
import flattentest.SmallRec;
import flattentest.UnionObj;
import flattentest.WithCompositeMapKey;
import flattentest.WithList;
import flattentest.WithListOfSmallRec;
import flattentest.WithMap;
import flattentest.WithMapAndList;
import flattentest.WithMapOfLists;
import flattentest.WithMapOfSmallRec;
import flattentest.WithSet;
import flattentest.WithTraitRec;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import schemarise.alfa.runtime.model.ColBasedTable;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.Try;
import schemarise.alfa.runtime.model.asserts.ValidationReport;

public class TableCodecTest {
    private Table testSimpleObjTable;
    private Table testSimpleObjTryFailTable;

    @Test
    public void testDecodePlainObjStream() {
        List<String> cols = Arrays.asList("StrVal", "IntVal", "OptVal", "EnVal");
        Stream data = Arrays.asList(Arrays.asList("Bob", "200000", "2", "R")).stream();
        Stream stream = TableCodec.importRowBasedObjects((CodecConfig)CodecConfig.defaultCodecConfig(), (String)"flattentest.PlainObj", Optional.of(cols), data, Collections.emptyMap());
        List list = stream.collect(Collectors.toList());
        Assert.assertEquals((long)list.size(), (long)1L);
    }

    @Test
    public void testReadCsvFile() throws Exception {
        AlfaRandomizer r = new AlfaRandomizer();
        CodecConfig cfg = CodecConfig.builder().setAssertListener((IValidationListener)new ValidationCollectingListener()).build();
        Path csvPath = Paths.get(TestUtils.getTestResourcesPath(this.getClass()) + "plain-obj.csv", new String[0]);
        Stream res = TableCodec.importCsv((Path)csvPath, (TableCodec.CsvReaderConfig)TableCodec.CsvReaderConfig.defaultCsvReaderConfig(), (CodecConfig)cfg, (String)PlainObj.PlainObjDescriptor.TYPE_NAME, Optional.empty(), Collections.emptyMap());
        long d = res.count();
        long count = 0L;
        for (int i = 0; i < 5; ++i) {
            res = TableCodec.importCsv((Path)csvPath, (TableCodec.CsvReaderConfig)TableCodec.CsvReaderConfig.defaultCsvReaderConfig(), (CodecConfig)CodecConfig.defaultCodecConfig(), (String)PlainObj.PlainObjDescriptor.TYPE_NAME, Optional.empty(), Collections.emptyMap());
            count = res.count();
        }
        ValidationReport vr = cfg.getAssertListener().getValidationReport().build();
        Assert.assertEquals((long)5001L, (long)vr.getTotalErrors());
        Assert.assertEquals((long)94999L, (long)count);
    }

    @Test
    public void testDecodePlainObj() {
        List<String> data = Arrays.asList("Australia and Oceania", "Tuvalu", "Food", "Offline", "H", "5/28/2010", "1669165933", "6/27/2010", "9925", "255.28", "159.42", "2533654.00", "1582243.50", "951410.50");
        for (int i = 0; i < 1000; ++i) {
            AlfaObject alfaObject = TableCodec.importRowBasedObject((CodecConfig)CodecConfig.defaultCodecConfig(), (String)FlatObj.FlatObjDescriptor.TYPE_NAME, Optional.empty(), data, (String)("Line:" + i), Collections.emptyMap());
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            AlfaObject alfaObject = TableCodec.importRowBasedObject((CodecConfig)CodecConfig.defaultCodecConfig(), (String)FlatObj.FlatObjDescriptor.TYPE_NAME, Optional.empty(), data, (String)("Line:" + i), Collections.emptyMap());
        }
        long end = System.currentTimeMillis();
        System.out.println(end - start);
    }

    @Test
    public void testSimpleObj() {
        SimpleObj.SimpleObjBuilder b = SimpleObj.builder();
        b.setEitherVal((Either<String, Double>)AlfaUtils.createEitherLeft((Object)"EitherLeftStr1")).setIntVal(20).setStrVal("RandStr").setOptVal(Optional.of((short)1)).setTryVal((Try<String>)AlfaUtils.createTryValue((Object)"TryStr")).setEnVal(SampleEnum.B);
        SimpleObj o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        Assert.assertEquals((Object)"[StrVal, IntVal, __OptVal_IsSet, OptVal, __TryVal_IsFailure, TryVal, __EitherVal_IsLeft, EitherVal_Left, EnVal]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[RandStr, 20, true, 1, false, TryStr, true, EitherLeftStr1, B]", (Object)t.getValues(0).toString());
        System.out.println(t);
        this.testSimpleObjTable = t;
    }

    @Test
    public void testSimpleObjTryFail() {
        SimpleObj.SimpleObjBuilder b = SimpleObj.builder();
        b.setEitherVal((Either<String, Double>)AlfaUtils.createEitherRight((Object)123.21)).setIntVal(20).setStrVal("RandStr").setOptVal(Optional.of((short)1)).setTryVal((Try<String>)AlfaUtils.createTryFailure((String)"TryFailure")).setEnVal(SampleEnum.B);
        SimpleObj o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        Assert.assertEquals((Object)"[StrVal, IntVal, __OptVal_IsSet, OptVal, __TryVal_IsFailure, TryVal_Message, __EitherVal_IsLeft, EitherVal_Right, EnVal]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[RandStr, 20, true, 1, true, TryFailure, false, 123.21, B]", (Object)t.getValues(0).toString());
        System.out.println(t);
        this.testSimpleObjTryFailTable = t;
    }

    @Test
    public void mergeTables() {
        this.testSimpleObj();
        this.testSimpleObjTryFail();
        Table t3 = Table.merge((ITable[])new ITable[]{this.testSimpleObjTable, this.testSimpleObjTryFailTable});
        System.out.println(t3);
        Assert.assertEquals((Object)"[StrVal, IntVal, __OptVal_IsSet, OptVal, __TryVal_IsFailure, TryVal, __EitherVal_IsLeft, EitherVal_Left, EnVal, TryVal_Message, EitherVal_Right]", (Object)t3.getColumnNames().toString());
        Assert.assertEquals((long)t3.getRowCount(), (long)2L);
    }

    @Test
    public void testWithList() {
        WithList.WithListBuilder b = WithList.builder();
        b.setStrVal("Str1");
        b.addListVal(14);
        WithList o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __ListVal__Id, ListVal]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, 1, 14]", (Object)t.getValues(0).toString());
        b.addListVal(9121);
        b.addListVal(2152);
        b.addListVal(6533);
        o = b.build();
        t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __ListVal__Id, ListVal]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, 4, 6533]", (Object)t.getValues(0).toString());
        Assert.assertEquals((Object)"[Str1, 2, 9121]", (Object)t.getValues(2).toString());
        Assert.assertEquals((long)4L, (long)t.getRowCount());
    }

    @Test
    public void testWithSet() {
        WithSet.WithSetBuilder b = WithSet.builder();
        b.setStrVal("Str1");
        b.addAllSetVal(new HashSet<Integer>());
        WithSet o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __SetVal_IsEmpty]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, true]", (Object)t.getValues(0).toString());
        b.addSetVal(9121);
        b.addSetVal(2152);
        b.addSetVal(6533);
        o = b.build();
        t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __SetVal_IsEmpty, __SetVal__Id, SetVal]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, false, 3, 9121]", (Object)t.getValues(0).toString());
        Assert.assertEquals((Object)"[Str1, false, 1, 2152]", (Object)t.getValues(2).toString());
        Assert.assertEquals((long)3L, (long)t.getRowCount());
    }

    @Test
    public void testWithMap() {
        WithMap.WithMapBuilder b = WithMap.builder();
        b.setStrVal("Str1");
        b.putAllMapVal(new HashMap<String, Integer>());
        WithMap o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __MapVal_IsEmpty]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, true]", (Object)t.getValues(0).toString());
        b.putMapVal("a", 9121);
        b.putMapVal("b", 2152);
        b.putMapVal("c", 6533);
        o = b.build();
        t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __MapVal_IsEmpty, MapVal_Key, MapVal_Value]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, false, a, 9121]", (Object)t.getValues(0).toString());
        Assert.assertEquals((Object)"[Str1, false, c, 6533]", (Object)t.getValues(2).toString());
        Assert.assertEquals((long)3L, (long)t.getRowCount());
    }

    @Test
    public void testWithListOfSmallRec() {
        WithListOfSmallRec.WithListOfSmallRecBuilder b = WithListOfSmallRec.builder();
        b.setStrVal("Str1");
        b.addAllListVal(new ArrayList<SmallRec>());
        WithListOfSmallRec o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __ListVal_IsEmpty]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, true]", (Object)t.getValues(0).toString());
        b.addListVal(SmallRec.builder().setIntVal(10).setStrVal("a").build());
        b.addListVal(SmallRec.builder().setIntVal(20).setStrVal("b").build());
        b.addListVal(SmallRec.builder().setIntVal(30).setStrVal("c").build());
        o = b.build();
        t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __ListVal_IsEmpty, __ListVal__Id, ListVal_StrVal, ListVal_IntVal]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, false, 3, c, 30]", (Object)t.getValues(0).toString());
        Assert.assertEquals((Object)"[Str1, false, 1, a, 10]", (Object)t.getValues(2).toString());
        Assert.assertEquals((long)3L, (long)t.getRowCount());
    }

    @Test
    public void testWithMapOfRecs() {
        WithMapOfSmallRec.WithMapOfSmallRecBuilder b = WithMapOfSmallRec.builder();
        b.setStrVal("Str1");
        b.putAllRecMapsVal(new HashMap<String, SmallRec>());
        WithMapOfSmallRec o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __RecMapsVal_IsEmpty]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, true]", (Object)t.getValues(0).toString());
        b.putRecMapsVal("ak", SmallRec.builder().setIntVal(10).setStrVal("a").build());
        b.putRecMapsVal("bk", SmallRec.builder().setIntVal(20).setStrVal("b").build());
        b.putRecMapsVal("ck", SmallRec.builder().setIntVal(30).setStrVal("c").build());
        o = b.build();
        t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __RecMapsVal_IsEmpty, RecMapsVal_K, RecMapsVal_V_StrVal, RecMapsVal_V_IntVal]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, false, ak, a, 10]", (Object)t.getValues(0).toString());
        Assert.assertEquals((Object)"[Str1, false, ck, c, 30]", (Object)t.getValues(2).toString());
        Assert.assertEquals((long)3L, (long)t.getRowCount());
    }

    @Test
    public void testWithMapWithCompositeKey() {
        WithCompositeMapKey.WithCompositeMapKeyBuilder b = WithCompositeMapKey.builder();
        b.setStrVal("Str1");
        b.putAllMoL(new HashMap<SmallRec, String>());
        WithCompositeMapKey o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __MoL_IsEmpty]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, true]", (Object)t.getValues(0).toString());
        b.putMoL(SmallRec.builder().setIntVal(10).setStrVal("a").build(), "x");
        b.putMoL(SmallRec.builder().setIntVal(20).setStrVal("b").build(), "y");
        b.putMoL(SmallRec.builder().setIntVal(30).setStrVal("c").build(), "z");
        o = b.build();
        t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __MoL_IsEmpty, MoL_CK_StrVal, MoL_CK_IntVal, MoL_Value]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, false, a, 10, x]", (Object)t.getValues(0).toString());
        Assert.assertEquals((Object)"[Str1, false, c, 30, z]", (Object)t.getValues(2).toString());
        Assert.assertEquals((long)3L, (long)t.getRowCount());
    }

    @Test
    public void testWithMapOfLists() {
        WithMapOfLists.WithMapOfListsBuilder b = WithMapOfLists.builder();
        b.setStrVal("Str1");
        b.putAllMoL(new HashMap<Integer, List<String>>());
        WithMapOfLists o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __MoL_IsEmpty]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, true]", (Object)t.getValues(0).toString());
        b.putMoL(100, Arrays.asList("p", "q", "r"));
        b.putMoL(200, Arrays.asList("a", "b"));
        b.putMoL(300, Arrays.asList("w", "x", "y", "z"));
        o = b.build();
        t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, __MoL_IsEmpty, MoL_Key, __MoL_Value_IsEmpty_L1, __MoL_Value__Id_L1, MoL_Value]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, false, 100, false, 3, r]", (Object)t.getValues(0).toString());
        Assert.assertEquals((Object)"[Str1, false, 300, false, 1, w]", (Object)t.getValues(8).toString());
        Assert.assertEquals((long)9L, (long)t.getRowCount());
    }

    @Test
    public void testWithMapAndList() {
        WithMapAndList.WithMapAndListBuilder b = WithMapAndList.builder();
        b.setStrVal("Str1");
        b.setIntVal(99);
        b.putAllMapVal(new HashMap<String, Integer>());
        b.addAllListVal(new ArrayList<String>());
        WithMapAndList o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((long)2L, (long)t.getRowCount());
        Assert.assertEquals((Object)"[StrVal, IntVal, __Dimension, __MapVal_IsEmpty, __ListVal_IsEmpty]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, 99, MapVal, true]", (Object)t.getValues(0).toString());
        Assert.assertEquals((Object)"[Str1, 99, ListVal, true]", (Object)t.getValues(1).toString());
        b.putMapVal("x", 10);
        b.putMapVal("y", 11);
        b.putMapVal("z", 12);
        b.addListVal("a");
        b.addListVal("b");
        b.addListVal("c");
        o = b.build();
        t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[StrVal, IntVal, __Dimension, __MapVal_IsEmpty, MapVal_Key, MapVal_Value, __ListVal_IsEmpty, __ListVal__Id, ListVal]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[Str1, 99, MapVal, false, x, 10]", (Object)t.getValues(0).toString());
        Assert.assertEquals((Object)"[Str1, 99, false, ListVal, 1, a]", (Object)t.getValues(5).toString());
        Assert.assertEquals((long)6L, (long)t.getRowCount());
    }

    @Test
    public void testWithRandom() {
        AlfaRandomizer r = new AlfaRandomizer();
        AlfaObject o = r.random("flattentest.WithMapAndList");
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        ScalarDataType ct = t.getColumnType("MapVal_Value");
        Assert.assertEquals((Object)Converters.DataTypeInt, (Object)ct);
        System.out.println(t);
    }

    @Test
    public void testWithEntity() {
        EntityObj.EntityObjBuilder b = EntityObj.builder();
        b.setStrVal("Str1");
        b.addAllListVal(new ArrayList<String>());
        b.set$key(EntityObjKey.builder().setId(UUID.fromString("378eaf7c-24dc-482c-af9e-e59ea81c9591")).build());
        EntityObj o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((long)1L, (long)t.getRowCount());
        Assert.assertEquals((Object)"[id, StrVal, __ListVal_IsEmpty]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[378eaf7c-24dc-482c-af9e-e59ea81c9591, Str1, true]", (Object)t.getValues(0).toString());
        b.addListVal("a");
        b.addListVal("b");
        b.addListVal("c");
        o = b.build();
        t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((Object)"[id, StrVal, __ListVal_IsEmpty, __ListVal__Id, ListVal]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[378eaf7c-24dc-482c-af9e-e59ea81c9591, Str1, false, 3, c]", (Object)t.getValues(0).toString());
        Assert.assertEquals((Object)"[378eaf7c-24dc-482c-af9e-e59ea81c9591, Str1, false, 1, a]", (Object)t.getValues(2).toString());
        Assert.assertEquals((long)3L, (long)t.getRowCount());
    }

    @Test
    public void testUnionObj() {
        UnionObj.UnionObjBuilder b = UnionObj.builder();
        b.setUdtVal(SmallRec.builder().setIntVal(10).setStrVal("x").build());
        UnionObj o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((long)1L, (long)t.getRowCount());
        Assert.assertEquals((Object)"[__Case, UdtVal_StrVal, UdtVal_IntVal]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[UdtVal, x, 10]", (Object)t.getValues(0).toString());
    }

    @Test
    public void testRecOfUnions() throws IOException, SQLException {
        RecOfUnions.RecOfUnionsBuilder b = RecOfUnions.builder();
        b.setStrVal("abc");
        b.addUnis(UnionObj.builder().setStrVal("us1").build());
        b.addUnis(UnionObj.builder().setStrVal("us2").build());
        b.addUnis(UnionObj.builder().setUdtVal(SmallRec.builder().setIntVal(10).setStrVal("so1").build()).build());
        b.addUnis(UnionObj.builder().setUdtVal(SmallRec.builder().setIntVal(15).setStrVal("so2").build()).build());
        RecOfUnions o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((long)4L, (long)t.getRowCount());
        Assert.assertEquals((Object)"[StrVal, __Unis_IsEmpty, __Unis__Id, Unis__Case, Unis_UdtVal_StrVal, Unis_UdtVal_IntVal, Unis_StrVal]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[abc, false, 4, UdtVal, so2, 15]", (Object)t.getValues(0).toString());
        ColBasedTable cbt = t.getColBasedTable();
        String json = Alfa.jsonCodec().toFormattedJson((AlfaObject)cbt);
        ResultSet rs = t.getResultSet();
        ResultSetMetaData md = rs.getMetaData();
        Assert.assertEquals((long)7L, (long)md.getColumnCount());
        while (rs.next()) {
            Assert.assertEquals((Object)rs.getString("StrVal"), (Object)"abc");
        }
    }

    @Test
    public void testWithTrait() throws IOException {
        WithTraitRec.WithTraitRecBuilder b = WithTraitRec.builder();
        b.addTVal(SampleTraitImplA.builder().setF1("a").setF2(20).build());
        b.addTVal(SampleTraitImplB.builder().setF1("a").setF3(30L).build());
        WithTraitRec o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
        Assert.assertEquals((long)2L, (long)t.getRowCount());
        Assert.assertEquals((Object)"[__TVal_IsEmpty, __TVal__Id, TVal__Type, TVal_F1, TVal_F3, TVal_F2]", (Object)t.getColumnNames().toString());
        Assert.assertEquals((Object)"[false, 2, flattentest.SampleTraitImplB, a, 30]", (Object)t.getValues(0).toString());
        Assert.assertEquals((Object)"[false, 1, flattentest.SampleTraitImplA, a, 20]", (Object)t.getValues(1).toString());
    }

    @Test
    public void testNested() throws IOException {
        DeeplyNestedVectors.DeeplyNestedVectorsBuilder b = DeeplyNestedVectors.builder();
        b.addF2(Arrays.asList(1, 2, 3));
        b.addF2(Arrays.asList(4, 5, 6));
        b.addF2(Arrays.asList(7, 8, 9));
        DeeplyNestedVectors o = b.build();
        Table t = (Table)TableCodec.toTable((AlfaObject)o);
        System.out.println(t);
    }
}

