/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.schemarise.alfa.runtime.Alfa;
import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.codec.json.JsonCodecConfig;
import com.schemarise.alfa.runtime.codec.json.JsonTypeWriteMode;
import com.schemarise.alfa.runtime_int.IntImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.stream.Stream;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.asserts.ConstraintType;
import schemarise.alfa.runtime.model.asserts.ValidationAlert;

public class JsonCodec {
    public static JsonCodecConfig CfgMapAsArrayWithNoMeta = JsonCodecConfig.builder().setWriteTypeMode(JsonTypeWriteMode.NeverWriteType).setWriteMapAsJsonObject(false).build();

    public String toJsonString(AlfaObject alfaObject) throws IOException {
        Objects.requireNonNull(alfaObject);
        if (alfaObject instanceof Builder) {
            throw new RuntimeException("Unexpected Builder instance. Pass result of build() method");
        }
        return this.exportObj(JsonCodecConfig.getInstance(), alfaObject).toString();
    }

    public String toJsonString(JsonCodecConfig jsonCfg, AlfaObject alfaObject) throws IOException {
        Objects.requireNonNull(alfaObject);
        return this.exportObj(jsonCfg, alfaObject).toString();
    }

    public OutputStream exportObj(JsonCodecConfig jsonCodecConfig, AlfaObject alfaObject) throws IOException {
        Objects.requireNonNull(alfaObject);
        return IntImpl.getJsonWriterInstance().write(jsonCodecConfig, alfaObject);
    }

    public void exportObj(JsonCodecConfig jsonCodecConfig, AlfaObject alfaObject, OutputStream os) throws IOException {
        Objects.requireNonNull(alfaObject);
        Objects.requireNonNull(os);
        IntImpl.getJsonWriterInstance().write(jsonCodecConfig, alfaObject, os);
    }

    public String toFormattedJson(AlfaObject alfaObject) throws IOException {
        Objects.requireNonNull(alfaObject);
        return IntImpl.getJsonWriterInstance().asFormattedJson(alfaObject);
    }

    public String toFormattedJson(JsonCodecConfig cc, AlfaObject alfaObject) throws IOException {
        Objects.requireNonNull(alfaObject);
        return IntImpl.getJsonWriterInstance().asFormattedJson(cc, alfaObject);
    }

    public <T extends AlfaObject> T fromJsonString(String json) throws IOException {
        Objects.requireNonNull(json);
        return IntImpl.getJsonReaderInstance().read(json);
    }

    public <T extends AlfaObject> T fromJsonString(JsonCodecConfig readerCfg, String json) throws IOException {
        Objects.requireNonNull(json);
        return IntImpl.getJsonReaderInstance().read(readerCfg, json);
    }

    public <T extends AlfaObject> T uncheckedFromJson(String ... json) {
        Objects.requireNonNull(json);
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < json.length; ++i) {
                sb.append(json[i]);
            }
            return IntImpl.getJsonReaderInstance().read(sb.toString());
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public <T extends AlfaObject> T uncheckedFromJson(InputStream is) {
        Objects.requireNonNull(is);
        try {
            return IntImpl.getJsonReaderInstance().read(JsonCodecConfig.getInstance(), is);
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    public <T extends AlfaObject> T importObj(JsonCodecConfig jsonCodecConfig, InputStream inputStream) throws IOException {
        Objects.requireNonNull(jsonCodecConfig);
        Objects.requireNonNull(inputStream);
        return IntImpl.getJsonReaderInstance().read(jsonCodecConfig, inputStream);
    }

    public <T extends AlfaObject> T importObj(InputStream inputStream) throws IOException {
        return this.importObj(Alfa.jsonCodecConfigDefault(), inputStream);
    }

    public <T extends AlfaObject> T importObj(JsonCodecConfig jsonCodecConfig, JsonParser jsonParser) throws IOException {
        Objects.requireNonNull(jsonCodecConfig);
        Objects.requireNonNull(jsonParser);
        return IntImpl.getJsonReaderInstance().read(jsonCodecConfig, jsonParser);
    }

    public <T extends AlfaObject> Stream<Either<AlfaObject, ValidationAlert.ValidationAlertBuilder>> importObjects(JsonCodecConfig jsonCodecConfig, InputStream is) throws IOException {
        return IntImpl.getJsonReaderInstance().readToStream(jsonCodecConfig, is);
    }

    public <T extends AlfaObject> Stream<Either<AlfaObject, ValidationAlert.ValidationAlertBuilder>> importObjects(InputStream is) throws IOException {
        return this.importObjects(Alfa.jsonCodecConfigDefault(), is);
    }

    public DataConsumer jsonDataConsumer(JsonCodecConfig wc, JsonGenerator jGenerator, OutputStream stream) {
        return IntImpl.jsonDataConsumer(wc, jGenerator, stream);
    }

    public DataSupplier jsonDataSupplier(JsonCodecConfig cc, JsonParser jParser) {
        return IntImpl.jsonDataSupplier(cc, jParser);
    }
}

