/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.utils;

import com.schemarise.alfa.runtime.Alfa;
import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.utils.ClassUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.IDataType;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.OptionalDataType;
import schemarise.alfa.runtime.model.Pair;
import schemarise.alfa.runtime.model.UdtBaseNode;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UnionDataType;

public abstract class DefaultTypeDescriptor
implements TypeDescriptor {
    private Map<String, String> fieldsOfUnionFields = new HashMap<String, String>();
    private Map<String, List<String>> typeNameAssignableToField = null;
    private Set<String> allDescendants = null;
    private List<String> fieldNames;

    protected void init() {
        List unionDts = this.getAllFieldsMeta().entrySet().stream().map(e -> {
            IDataType t = ((FieldMeta)e.getValue()).getDataType();
            UnionDataType u = this.locateNestedUnion(t);
            if (u == null) {
                return null;
            }
            return Pair.builder().setLeft(e.getKey()).setRight(u).build();
        }).filter(f -> f != null).collect(Collectors.toList());
        for (Pair ax : unionDts) {
            UnionDataType u = (UnionDataType)ax.getRight();
            ClassUtils.ClassMeta cm = ClassUtils.getMeta(u.getSynthFullyQualifiedName());
            DefaultTypeDescriptor dtd = (DefaultTypeDescriptor)cm.getModel();
            this.fieldsOfUnionFields.putAll(dtd.fieldsOfUnionFields);
            u.getFields().keySet().forEach(k -> this.fieldsOfUnionFields.put((String)k, (String)ax.getLeft()));
        }
        List l = this.getAllFieldsMeta().values().stream().map(e -> e.getField().getName()).collect(Collectors.toList());
        this.fieldNames = new ArrayList(l);
    }

    @Override
    public List<String> getAllFieldNames() {
        return this.fieldNames;
    }

    @Override
    public Optional<Map<String, Expression>> getAnnotations() {
        return Optional.empty();
    }

    private UnionDataType locateNestedUnion(IDataType t) {
        if (t instanceof UnionDataType) {
            return (UnionDataType)t;
        }
        if (t instanceof OptionalDataType) {
            return this.locateNestedUnion(((OptionalDataType)t).getComponentType());
        }
        if (t instanceof ListDataType) {
            return this.locateNestedUnion(((ListDataType)t).getComponentType());
        }
        return null;
    }

    @Override
    public Set<String> getAllDescendants() {
        if (this.allDescendants == null) {
            HashSet<String> set = new HashSet<String>();
            set.addAll(this.getImmediateDescendants());
            for (String dep : this.getImmediateDescendants()) {
                if (set.contains(dep)) continue;
                ClassUtils.ClassMeta cm = ClassUtils.getMeta(dep);
                set.addAll(cm.getModel().getAllDescendants());
            }
            this.allDescendants = set;
        }
        return this.allDescendants;
    }

    @Override
    public Optional<String> getFieldContainingNestedUnionField(String name) {
        String f = this.fieldsOfUnionFields.get(name);
        return Optional.ofNullable(f);
    }

    @Override
    public <T extends AlfaObject> Optional<BiConsumer<T, DataConsumer>> getFieldSupplier(String fieldName) {
        return Optional.empty();
    }

    @Override
    public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
        return Optional.empty();
    }

    @Override
    public <T extends AlfaObject> Map<String, FieldMeta<T>> getAllFieldsMeta() {
        return Collections.emptyMap();
    }

    @Override
    public UdtDataType getUdtDataType() {
        return null;
    }

    @Override
    public Optional<TypeDescriptor> getEntityKeyModel() {
        return Optional.empty();
    }

    @Override
    public boolean hasAbstractTypeFieldsInClosure() {
        return false;
    }

    @Override
    public boolean convertableToBuilder() {
        return false;
    }

    @Override
    public boolean hasBuilder() {
        return false;
    }

    @Override
    public Builder builder() {
        return null;
    }

    @Override
    public Builder builder(IBuilderConfig cc) {
        throw new AlfaRuntimeException("newBuilder not implemented for " + this.getClass().getName());
    }

    @Override
    public Set<String> getImmediateDescendants() {
        return Collections.emptySet();
    }

    @Override
    public List<String> getFieldAssignableToTypeName(String fqn) {
        if (this.typeNameAssignableToField == null) {
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            this.getAllFieldsMeta().entrySet().stream().forEach(e -> {
                String fname = (String)e.getKey();
                IDataType dt = ((FieldMeta)e.getValue()).getDataType();
                ArrayList<String> path = new ArrayList<String>();
                path.add(fname);
                this.findAssignalbleTypes(m, dt, path);
            });
            this.typeNameAssignableToField = m;
        }
        return this.typeNameAssignableToField.get(fqn);
    }

    private void findAssignalbleTypes(Map<String, List<String>> m, IDataType dt, List<String> path) {
        if (dt instanceof UdtDataType) {
            UdtDataType udt = (UdtDataType)dt;
            m.put(udt.getFullyQualifiedName(), path);
            Set<String> fieldTypeDesc = ClassUtils.getMeta(udt.getFullyQualifiedName()).getModel().getAllDescendants();
            fieldTypeDesc.forEach(a -> {
                m.put((String)a, path);
                TypeDescriptor cms = ClassUtils.getMeta(a).getModel();
                this.findAssignalbleTypes(m, cms.getUdtDataType(), path);
            });
        } else if (dt instanceof UnionDataType) {
            UnionDataType ut = (UnionDataType)dt;
            ut.getFields().forEach((k, v) -> {
                ArrayList<String> copy = new ArrayList<String>(path);
                copy.add((String)k);
                this.findAssignalbleTypes(m, v.getDataType(), copy);
            });
        } else if (dt instanceof OptionalDataType) {
            OptionalDataType t = (OptionalDataType)dt;
            this.findAssignalbleTypes(m, t.getComponentType(), path);
        } else if (dt instanceof ListDataType) {
            ListDataType t = (ListDataType)dt;
            this.findAssignalbleTypes(m, t.getComponentType(), path);
        }
    }

    @Override
    public Map<String, Assert> getAsserts() {
        return Collections.emptyMap();
    }

    protected <T extends UdtBaseNode> T loadModel(Class<?> context, UdtDataType udt) {
        String p = "META-INF/alfa-schemas/" + udt.getFullyQualifiedName() + ".json";
        InputStream is = context.getClassLoader().getResourceAsStream(p);
        if (is == null) {
            throw new AlfaRuntimeException("Failed to load schema " + p + " from context class " + context.getName() + " in " + context.getProtectionDomain().getCodeSource().getLocation());
        }
        try {
            UdtBaseNode res = (UdtBaseNode)Alfa.jsonCodec().uncheckedFromJson(is);
            return (T)res;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

