/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.utils;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Compressed;
import com.schemarise.alfa.runtime.Encrypted;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.IValidationListener;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.Union;
import com.schemarise.alfa.runtime.codec.Converters;
import com.schemarise.alfa.runtime.utils.PathCreator;
import com.schemarise.alfa.runtime_int.IntImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import schemarise.alfa.runtime.model.Pair;
import schemarise.alfa.runtime.model.Try;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtVersionedName;
import schemarise.alfa.runtime.model.asserts.ConstraintType;
import schemarise.alfa.runtime.model.asserts.DataQualityType;
import schemarise.alfa.runtime.model.asserts.SeverityType;
import schemarise.alfa.runtime.model.asserts.ValidationAlert;
import schemarise.alfa.runtime.model.path.Path;

public class Utils {
    private static Map<String, Pattern> _patterns = new HashMap<String, Pattern>();

    public static boolean or(boolean l, boolean r) {
        return l || r;
    }

    public static DataQualityType constraintTypeToDqType(ConstraintType ct) {
        switch (ct) {
            case MandatoryFieldNotSet: {
                return DataQualityType.Completeness;
            }
            case OutsidePermittedRange: {
                return DataQualityType.Accuracy;
            }
            case DataFormatError: {
                return DataQualityType.Conformity;
            }
            case Unknown: {
                return DataQualityType.Unclassified;
            }
            case UnknownField: {
                return DataQualityType.Conformity;
            }
            case InvalidConstant: {
                return DataQualityType.Conformity;
            }
            case UserDefinedAssert: {
                return DataQualityType.Unclassified;
            }
            case InvalidTypeForField: {
                return DataQualityType.Conformity;
            }
            case Duplicate: {
                return DataQualityType.Uniqueness;
            }
            case InvalidPattern: {
                return DataQualityType.Conformity;
            }
            case InvalidDecimalScale: {
                return DataQualityType.Accuracy;
            }
            case InvalidDecimalPrecision: {
                return DataQualityType.Accuracy;
            }
        }
        return DataQualityType.Unclassified;
    }

    public static void validateCollectionSize(IValidationListener listener, Supplier<PathCreator> path, Collection<?> l, Integer min, Integer max) {
        Utils.validate(listener, path, l.size(), min, max);
    }

    public static void validateCollectionSize(IValidationListener listener, Supplier<PathCreator> path, Map<?, ?> l, Integer min, Integer max) {
        Utils.validate(listener, path, l.size(), min, max);
    }

    private static String reportablePathToFieldName(Path p) {
        return p.getField();
    }

    private static String reportablePathIdentification(Path p) {
        String val = "";
        if (p.getElement().isScalarValue()) {
            val = p.getElement().getScalarValue();
        }
        return val;
    }

    public static void validateDecimalScaleAndPrecision(IValidationListener listener, Supplier<PathCreator> path, BigDecimal value, int precision, int scale) {
        if (value.scale() > scale) {
            listener.addFailure(ValidationAlert.builder().setSeverity(SeverityType.Error).setDataQualityCategory(Optional.of(DataQualityType.Accuracy)).setViolatedConstraint(Optional.of(ConstraintType.InvalidDecimalScale)).setFieldName(Optional.of(Utils.reportablePathToFieldName(path.get().toReportablePath()))).setIdentification(Optional.of(Utils.reportablePathIdentification(path.get().toReportablePath()))).setMessage("Invalid value " + value + " that exceeds the decimal scale '" + scale + "'"));
        }
        if (value.precision() > precision) {
            listener.addFailure(ValidationAlert.builder().setSeverity(SeverityType.Error).setDataQualityCategory(Optional.of(DataQualityType.Accuracy)).setViolatedConstraint(Optional.of(ConstraintType.InvalidDecimalPrecision)).setFieldName(Optional.of(Utils.reportablePathToFieldName(path.get().toReportablePath()))).setIdentification(Optional.of(Utils.reportablePathIdentification(path.get().toReportablePath()))).setMessage("Invalid value " + value + " that exceeds the decimal precision '" + precision + "'"));
        }
    }

    public static <T extends Comparable> void validateScalarRange(IValidationListener listener, Supplier<PathCreator> path, T value, T min, T max) {
        Utils.validate(listener, path, value, min, max);
    }

    public static <T extends Comparable> void validateScalarRange(IValidationListener listener, Supplier<PathCreator> path, Optional<T> value, T min, T max) {
        if (value.isPresent()) {
            Utils.validate(listener, path, (Comparable)value.get(), min, max);
        }
    }

    public static Pattern getOrCreatePattern(String pattern) {
        Pattern pat = _patterns.get(pattern);
        if (pat == null) {
            pat = Pattern.compile(pattern);
            _patterns.put(pattern, pat);
        }
        return pat;
    }

    public static void validateWithPattern(IValidationListener listener, Supplier<PathCreator> path, String value, String origPattern) {
        String pattern = origPattern.replace("\\\\", "\\");
        Pattern pat = _patterns.get(pattern);
        if (pat == null) {
            try {
                pat = Pattern.compile(pattern);
                _patterns.put(pattern, pat);
            }
            catch (Exception e) {
                listener.addFailure(ValidationAlert.builder().setSeverity(SeverityType.Error).setDataQualityCategory(Optional.of(DataQualityType.Accuracy)).setViolatedConstraint(Optional.of(ConstraintType.InvalidPattern)).setFieldName(Optional.of(Utils.reportablePathToFieldName(path.get().toReportablePath()))).setIdentification(Optional.of(Utils.reportablePathIdentification(path.get().toReportablePath()))).setMessage("Invalid pattern '" + origPattern + "'"));
            }
        }
        if (!pat.matcher(value).matches()) {
            listener.addFailure(ValidationAlert.builder().setSeverity(SeverityType.Error).setDataQualityCategory(Optional.of(DataQualityType.Accuracy)).setViolatedConstraint(Optional.of(ConstraintType.InvalidPattern)).setFieldName(Optional.of(Utils.reportablePathToFieldName(path.get().toReportablePath()))).setIdentification(Optional.of(Utils.reportablePathIdentification(path.get().toReportablePath()))).setMessage("Value '" + value + "' does not conform to regex pattern '" + origPattern + "'"));
        }
    }

    public static void validateScalarRange(IValidationListener listener, Supplier<PathCreator> path, byte[] value, int min, int max) {
        Utils.validate(listener, path, value.length, min, max);
    }

    private static <T extends Comparable> void validate(IValidationListener listener, Supplier<PathCreator> path, T sz, T min, T max) {
        if (min != null && sz.getClass() != min.getClass() || max != null && sz.getClass() != max.getClass()) {
            Utils.validate(listener, path, ((Number)((Object)sz)).doubleValue(), min == null ? min : Double.valueOf(((Number)((Object)min)).doubleValue()), max == null ? max : Double.valueOf(((Number)((Object)max)).doubleValue()));
            return;
        }
        if (min != null && sz.compareTo(min) < 0) {
            listener.addFailure(ValidationAlert.builder().setSeverity(SeverityType.Error).setDataQualityCategory(Optional.of(DataQualityType.Accuracy)).setViolatedConstraint(Optional.of(ConstraintType.OutsidePermittedRange)).setFieldName(Optional.of(Utils.reportablePathToFieldName(path.get().toReportablePath()))).setIdentification(Optional.of(Utils.reportablePathIdentification(path.get().toReportablePath()))).setMessage("Minimum " + min + ", result " + sz));
        }
        if (max != null && sz.compareTo(max) > 0) {
            listener.addFailure(ValidationAlert.builder().setSeverity(SeverityType.Error).setDataQualityCategory(Optional.of(DataQualityType.Accuracy)).setViolatedConstraint(Optional.of(ConstraintType.OutsidePermittedRange)).setFieldName(Optional.of(Utils.reportablePathToFieldName(path.get().toReportablePath()))).setIdentification(Optional.of(Utils.reportablePathIdentification(path.get().toReportablePath()))).setMessage("Maximum " + max + ", result " + sz));
        }
    }

    public static String udtToString(String udtName, String[] fields, Object[] objs) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n\t\"type\":\"" + udtName + "\",\n");
        for (int i = 0; i < fields.length; ++i) {
            String val = Utils.fmtString(objs[i]);
            if (val == null) continue;
            sb.append("\t\"" + fields[i] + "\":" + val);
            if (i + i < fields.length) {
                sb.append(",");
            }
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String fmtString(Object e) {
        if (e == null) {
            return "null";
        }
        if (e instanceof Number || e instanceof AlfaObject) {
            return e.toString();
        }
        if (e instanceof Map) {
            return Utils.fmtMapString((Map)e);
        }
        if (e instanceof List) {
            return Utils.fmtListString((List)e);
        }
        if (e instanceof Set) {
            return Utils.fmtSetString((Set)e);
        }
        if (e instanceof Optional) {
            Optional o = (Optional)e;
            if (o != null && o.isPresent()) {
                return Utils.fmtString(o.get());
            }
            return null;
        }
        String s = e.toString();
        return "\"" + s + "\"";
    }

    private static String fmtMapString(Map<Object, Object> m) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        List l = m.entrySet().stream().map(e -> {
            StringBuilder i = new StringBuilder();
            i.append("[");
            i.append(Utils.fmtString(e.getKey()));
            i.append(", ");
            i.append(Utils.fmtString(e.getValue()));
            i.append("]");
            return i.toString();
        }).collect(Collectors.toList());
        sb.append(String.join((CharSequence)", ", l));
        sb.append("]");
        return sb.toString();
    }

    private static String fmtSetString(Set<?> m) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        List l = m.stream().map(e -> Utils.fmtString(e)).collect(Collectors.toList());
        sb.append(String.join((CharSequence)", ", l));
        sb.append("]");
        return sb.toString();
    }

    private static String fmtListString(List<?> m) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        List l = m.stream().map(e -> Utils.fmtString(e)).collect(Collectors.toList());
        sb.append(String.join((CharSequence)", ", l));
        sb.append("]");
        return sb.toString();
    }

    public static boolean assertMandatoryFieldsSet(IBuilderConfig cc, BitSet missingFields, int totalFields, TypeDescriptor desc) {
        IValidationListener l = cc.getAssertListener();
        if (missingFields.isEmpty()) {
            return false;
        }
        int nextBit = 0;
        ArrayList<String> names = new ArrayList<String>();
        while (true) {
            if ((nextBit = missingFields.nextSetBit(nextBit)) >= 0) {
                String name = desc.fieldIdName(nextBit);
                names.add(name);
            } else if (nextBit == -1 || nextBit + 1 == totalFields) break;
            ++nextBit;
        }
        if (names.size() > 0 && !cc.assertMandatoryFieldsSet()) {
            l.addFailure(ValidationAlert.builder().setViolatedConstraint(Optional.of(ConstraintType.MandatoryFieldNotSet)).setMessage("Mandatory fields " + names + " not set").setTypeName(Optional.of(desc.getUdtDataType().getFullyQualifiedName())).setDataQualityCategory(Optional.of(DataQualityType.Completeness)));
            return true;
        }
        long c = cc.getAssertListener().getErrorCount();
        Object msg = "";
        if (c > 0L) {
            msg = ". Found " + c + " errors. 1st error : " + cc.getAssertListener().getValidationReport().getAlerts().get(0).getMessage();
        }
        throw new AlfaRuntimeException(ConstraintType.MandatoryFieldNotSet, "Mandatory fields " + names + " not set" + (String)msg);
    }

    public static void enforceNoFieldSet(BitSet missingFields, TypeDescriptor desc, int totalFields, short fieldId) {
        BitSet copy = (BitSet)missingFields.clone();
        copy.flip(0, totalFields);
        if (!copy.isEmpty() && missingFields.nextClearBit(0) != fieldId) {
            String alreadySet = desc.fieldIdName(missingFields.nextClearBit(0));
            String attempted = desc.fieldIdName(fieldId);
            throw new AlfaRuntimeException(ConstraintType.MandatoryFieldNotSet, "Field " + alreadySet + " already set. Cannot set " + attempted + " in type " + desc.getUdtDataType().getFullyQualifiedName());
        }
    }

    public static void assertNotNull(Object k) {
        if (k == null) {
            throw new AlfaRuntimeException("Null object encountered");
        }
    }

    public static int unionHashCode(Union u) {
        return Objects.hash(u.caseName(), u.caseValue());
    }

    public static String unionToString(Union u) {
        return "{\"@type\":\"" + u.descriptor().getUdtDataType().getFullyQualifiedName() + "\",\"" + u.caseName() + "\":" + u.caseValue() + ",}";
    }

    public static boolean unionEquals(Union lhs, Object o) {
        if (lhs == o) {
            return true;
        }
        if (!lhs.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        Union rhs = (Union)o;
        return rhs.caseName().equals(lhs.caseName()) && rhs.caseValue().equals(lhs.caseValue());
    }

    public static UdtVersionedName toUdtVersionedName(UdtDataType udtDataType) {
        return UdtVersionedName.builder().setFullyQualifiedName(udtDataType.getFullyQualifiedName()).setUdtType(udtDataType.getUdtType()).build();
    }

    public static <T> Encrypted<T> defaultEncryptedFromValue(Converters.SupplierConsumer<T> convertor, IBuilderConfig builderConfig, T unencodedObject) {
        return IntImpl.defaultEncryptedFromValue(convertor, builderConfig, unencodedObject);
    }

    public static <T> Compressed<T> defaultCompressedFromValue(Converters.SupplierConsumer<T> convertor, IBuilderConfig builderConfig, T unencodedObject) {
        return IntImpl.defaultCompressedFromValue(convertor, builderConfig, unencodedObject);
    }

    public static <A, B> List<Pair<A, B>> zip(List<A> as, List<B> bs) {
        return IntStream.range(0, Math.min(as.size(), bs.size())).mapToObj(i -> Pair.builder().setLeft(as.get(i)).setRight(bs.get(i)).build()).collect(Collectors.toList());
    }

    public static <T> List<T> asList(T ... l) {
        ArrayList<T> res = new ArrayList<T>();
        for (int i = 0; i < l.length; ++i) {
            res.add(l[i]);
        }
        return res;
    }

    public static <T> Optional<T> tryFlatMap(Try<T> t) {
        if (t.isResult()) {
            return Optional.of(t.getResult());
        }
        return Optional.empty();
    }
}

