/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.BuilderConfig;
import com.schemarise.alfa.runtime.Compressed;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Encrypted;
import com.schemarise.alfa.runtime.EntityBuilder;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.ITable;
import com.schemarise.alfa.runtime.NativeAlfaObject;
import com.schemarise.alfa.runtime.NormalizedPeriod;
import com.schemarise.alfa.runtime.Record;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.Union;
import com.schemarise.alfa.runtime.UnionUntypedCase;
import com.schemarise.alfa.runtime.codec.CodecConfig;
import com.schemarise.alfa.runtime.codec.Converters;
import com.schemarise.alfa.runtime.utils.ClassUtils;
import com.schemarise.alfa.runtime.utils.Utils;
import com.schemarise.alfa.runtime_int.DefaultCompressed;
import com.schemarise.alfa.runtime_int.DefaultEncrypted;
import com.schemarise.alfa.runtime_int.IntImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import schemarise.alfa.runtime.model.CompressedDataType;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.EitherDataType;
import schemarise.alfa.runtime.model.EnumDataType;
import schemarise.alfa.runtime.model.FutureDataType;
import schemarise.alfa.runtime.model.IDataType;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.MapDataType;
import schemarise.alfa.runtime.model.MetaDataType;
import schemarise.alfa.runtime.model.OptionalDataType;
import schemarise.alfa.runtime.model.Pair;
import schemarise.alfa.runtime.model.PairDataType;
import schemarise.alfa.runtime.model.RangeValue;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.SetDataType;
import schemarise.alfa.runtime.model.StreamDataType;
import schemarise.alfa.runtime.model.TabularDataType;
import schemarise.alfa.runtime.model.Try;
import schemarise.alfa.runtime.model.TryDataType;
import schemarise.alfa.runtime.model.TryFailure;
import schemarise.alfa.runtime.model.TupleDataType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;
import schemarise.alfa.runtime.model.UnionDataType;
import schemarise.alfa.runtime.model.asserts.ConstraintType;

final class AlfaRandomGenerator
extends DataSupplier
implements IntImpl.AlfaRandomGeneratorIfc {
    private final List<String> allTypes;
    private Random r = new Random();
    private Stack<IDataType> currentTypeStack = new Stack();
    private final IBuilderConfig cfg;

    public AlfaRandomGenerator(IBuilderConfig c, List<String> allTypes) {
        super(new CodecConfig.Builder().build());
        this.allTypes = allTypes;
        this.cfg = c;
    }

    @Override
    public boolean randomizable(String typeName) {
        try {
            ClassUtils.ClassMeta cm = ClassUtils.getMeta(typeName);
            Class<?> tc = ClassUtils.getMeta(typeName).getTypeClass();
            return cm.hasBuilderClass();
        }
        catch (RuntimeException cnf) {
            return false;
        }
    }

    @Override
    public <T extends AlfaObject> T randomWithValues(String typeName, Map<String, Object> values) {
        int attempts = 0;
        while (true) {
            Object value = null;
            try {
                ++attempts;
                value = this._random(typeName, values);
                return (T)((AlfaObject)value);
            }
            catch (AlfaRuntimeException e) {
                if (attempts <= 100) continue;
                throw new AlfaRuntimeException(ConstraintType.Unknown, "Vaildation on " + typeName + " fails after 10000 attempts", e);
            }
            break;
        }
    }

    @Override
    public <T extends AlfaObject> T random(String typeName) {
        return this.randomWithValues(typeName, Collections.emptyMap());
    }

    private <T extends AlfaObject> T _random(String typeName, Map<String, Object> values) {
        TypeDescriptor model;
        ClassUtils.ClassMeta meta = ClassUtils.getMeta(typeName);
        if (meta.getModel() != null && meta.getModel().getUdtDataType().getUdtType() == UdtMetaType.traitType) {
            ClassUtils.ClassMeta finalMeta = meta;
            List compat = this.allTypes.stream().filter(t -> {
                ClassUtils.ClassMeta tm = ClassUtils.getMeta(t);
                TypeDescriptor m = tm.getModel();
                if (m != null) {
                    UdtMetaType ut = m.getUdtDataType().getUdtType();
                    if (tm.getModel() != null && ut != UdtMetaType.traitType && ut != UdtMetaType.libraryType && ut != UdtMetaType.testcaseType) {
                        return finalMeta.isTypeAssignable(tm);
                    }
                }
                return false;
            }).collect(Collectors.toList());
            if (compat.size() > 0) {
                meta = ClassUtils.getMeta((String)compat.get(this.r.nextInt(compat.size())));
            } else {
                throw new AlfaRuntimeException("Failed to find trait implementation for " + typeName);
            }
        }
        if ((model = meta.getModel()) == null) {
            throw new UnsupportedOperationException();
        }
        if (model.getUdtDataType().getUdtType() == UdtMetaType.enumType) {
            EnumDataType.EnumDataTypeBuilder et = EnumDataType.builder().setSynthFullyQualifiedName(typeName);
            meta.getModel().getAllFieldsMeta().keySet().forEach(f -> et.addFields((String)f));
            return this.enumValue(et.build());
        }
        Builder builder = meta.getNewBuilder(this.cfg);
        Set<String> fnames = model.getAllFieldsMeta().keySet();
        UdtMetaType mt = meta.getModel().getUdtDataType().getUdtType();
        if (mt == UdtMetaType.unionType || mt == UdtMetaType.untaggedUnionType) {
            int d = this.r.nextInt(fnames.size());
            String randFName = fnames.toArray(new String[0])[d];
            fnames = new HashSet<String>();
            fnames.add(randFName);
        }
        for (String fn : fnames) {
            if (values.containsKey(fn)) {
                builder.modify(fn, values.get(fn));
                continue;
            }
            BiConsumer<Builder, DataSupplier> c = model.getFieldConsumer(fn).get();
            this.currentTypeStack.push(model.getAllFieldsMeta().get(fn).getDataType());
            c.accept(builder, this);
            this.currentTypeStack.pop();
        }
        if (builder instanceof EntityBuilder) {
            EntityBuilder eb = (EntityBuilder)((Object)builder);
            String keyClassName = null;
            for (Method m : builder.getClass().getMethods()) {
                if (!m.getName().equals("set$key") || m.getParameters()[0].getType().getName().equals("java.lang.Object")) continue;
                keyClassName = m.getParameters()[0].getType().getName();
                break;
            }
            if (keyClassName == null) {
                throw new RuntimeException("set$key method not found for " + keyClassName);
            }
            T k = this.random(keyClassName);
            eb.set$key(k);
        }
        return builder.build();
    }

    @Override
    public int intValue(ScalarDataType scalarDataType) {
        RangeValue max = scalarDataType.getMax().orElse(RangeValue.builder().setIntValue(Integer.MAX_VALUE).build());
        RangeValue min = scalarDataType.getMin().orElse(RangeValue.builder().setIntValue(Integer.MIN_VALUE).build());
        int mx = ((Number)max.caseValue()).intValue();
        int mn = ((Number)min.caseValue()).intValue();
        return this.r.ints(1L, mn, mx).findFirst().getAsInt();
    }

    @Override
    public String stringValue(ScalarDataType scalarDataType) {
        RangeValue max = scalarDataType.getMax().orElse(RangeValue.builder().setLongValue(5L).build());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while ((long)i < max.getLongValue()) {
            sb.append((char)(97 + this.r.nextInt(26)));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public double doubleValue(ScalarDataType scalarDataType) {
        RangeValue min = scalarDataType.getMin().orElse(RangeValue.builder().setDoubleValue(Double.MIN_VALUE).build());
        RangeValue max = scalarDataType.getMax().orElse(RangeValue.builder().setDoubleValue(Double.MAX_VALUE).build());
        return ThreadLocalRandom.current().nextDouble(min.getDoubleValue(), max.getDoubleValue());
    }

    @Override
    public short shortValue(ScalarDataType scalarDataType) {
        RangeValue max = scalarDataType.getMax().orElse(RangeValue.builder().setIntValue(Short.MAX_VALUE).build());
        RangeValue min = scalarDataType.getMin().orElse(RangeValue.builder().setIntValue(Short.MIN_VALUE).build());
        int mx = ((Number)max.caseValue()).intValue();
        int mn = ((Number)min.caseValue()).intValue();
        return (short)this.r.ints(1L, mn, mx).findFirst().getAsInt();
    }

    @Override
    public long longValue(ScalarDataType scalarDataType) {
        RangeValue max = scalarDataType.getMax().orElse(RangeValue.builder().setLongValue(Long.MAX_VALUE).build());
        RangeValue min = scalarDataType.getMin().orElse(RangeValue.builder().setLongValue(Long.MIN_VALUE).build());
        long mx = ((Number)max.caseValue()).longValue();
        long mn = ((Number)min.caseValue()).longValue();
        return this.r.longs(1L, mn, mx).findFirst().getAsLong();
    }

    @Override
    public byte byteValue(ScalarDataType scalarDataType) {
        return ("" + this.r.nextInt()).getBytes()[0];
    }

    @Override
    public char charValue(ScalarDataType scalarDataType) {
        return (char)(this.r.nextInt(26) + 97);
    }

    @Override
    public boolean booleanValue(ScalarDataType scalarDataType) {
        return this.r.nextInt(2) == 0;
    }

    @Override
    public BigDecimal decimalValue(ScalarDataType scalarDataType) {
        double d = this.doubleValue(scalarDataType);
        BigDecimal bd = new BigDecimal(d);
        if (scalarDataType.getPrecision().isPresent()) {
            String s = bd.toPlainString().substring(0, scalarDataType.getPrecision().get().getPrecision());
            return new BigDecimal(s);
        }
        return bd;
    }

    @Override
    public LocalDate dateValue(ScalarDataType scalarDataType) {
        RangeValue max = scalarDataType.getMax().orElse(RangeValue.builder().setDateValue(LocalDate.of(2100, 1, 1)).build());
        RangeValue min = scalarDataType.getMin().orElse(RangeValue.builder().setDateValue(LocalDate.of(1000, 1, 1)).build());
        long mn = ((LocalDate)min.caseValue()).toEpochDay();
        long mx = ((LocalDate)max.caseValue()).toEpochDay();
        long ldate = this.r.longs(1L, mn, mx).findFirst().getAsLong();
        return LocalDate.ofEpochDay(ldate);
    }

    @Override
    public LocalDateTime datetimeValue(ScalarDataType scalarDataType) {
        RangeValue max = scalarDataType.getMax().orElse(RangeValue.builder().setDatetimeValue(LocalDateTime.of(2100, 1, 1, 0, 0)).build());
        RangeValue min = scalarDataType.getMin().orElse(RangeValue.builder().setDatetimeValue(LocalDateTime.of(1000, 1, 1, 0, 0)).build());
        long mn = ((LocalDateTime)min.caseValue()).toEpochSecond(ZoneOffset.UTC);
        long mx = ((LocalDateTime)max.caseValue()).toEpochSecond(ZoneOffset.UTC);
        long ldate = this.r.longs(1L, mn, mx).findFirst().getAsLong();
        return LocalDateTime.ofEpochSecond(ldate, 0, ZoneOffset.UTC);
    }

    @Override
    public ZonedDateTime datetimetzValue(ScalarDataType scalarDataType) {
        RangeValue max = scalarDataType.getMax().orElse(RangeValue.builder().setDatetimetzValue(ZonedDateTime.of(2100, 1, 1, 0, 0, 0, 0, ZoneId.systemDefault())).build());
        RangeValue min = scalarDataType.getMin().orElse(RangeValue.builder().setDatetimetzValue(ZonedDateTime.of(1000, 1, 1, 0, 0, 0, 0, ZoneId.systemDefault())).build());
        long mn = ((LocalDateTime)min.caseValue()).toEpochSecond(ZoneOffset.UTC);
        long mx = ((LocalDateTime)max.caseValue()).toEpochSecond(ZoneOffset.UTC);
        long ldate = this.r.longs(1L, mn, mx).findFirst().getAsLong();
        return ZonedDateTime.of(LocalDateTime.ofEpochSecond(ldate, 0, ZoneOffset.UTC), ZoneId.systemDefault());
    }

    @Override
    public LocalTime timeValue(ScalarDataType scalarDataType) {
        RangeValue max = scalarDataType.getMax().orElse(RangeValue.builder().setTimeValue(LocalTime.of(23, 59, 59)).build());
        RangeValue min = scalarDataType.getMin().orElse(RangeValue.builder().setTimeValue(LocalTime.of(0, 0, 0)).build());
        long mn = ((LocalTime)min.caseValue()).toSecondOfDay();
        long mx = ((LocalTime)max.caseValue()).toSecondOfDay();
        long ltime = this.r.longs(1L, mn, mx).findFirst().getAsLong();
        return LocalTime.ofSecondOfDay(ltime);
    }

    @Override
    public float floatValue(ScalarDataType scalarDataType) {
        return this.r.nextFloat();
    }

    @Override
    public byte[] binaryValue(ScalarDataType scalarDataType) {
        return ("" + this.r.nextInt()).getBytes();
    }

    @Override
    public Duration durationValue(ScalarDataType scalarDataType) {
        return Duration.ofDays(this.r.nextInt(3650));
    }

    @Override
    public NormalizedPeriod periodValue(ScalarDataType scalarDataType) {
        return NormalizedPeriod.of(Period.ofMonths(this.r.nextInt(12)));
    }

    @Override
    public UUID uuidValue(ScalarDataType scalarDataType) {
        return UUID.randomUUID();
    }

    @Override
    public URI uriValue(ScalarDataType scalarDataType) {
        String proto = scalarDataType.getStrPattern().orElse("http");
        return URI.create(proto + "://192.168.0.1:" + this.r.nextInt(50000));
    }

    @Override
    public String patternValue(ScalarDataType scalarDataType) {
        return "notarandompattern";
    }

    @Override
    public UnionUntypedCase voidValue(ScalarDataType scalarDataType) {
        return UnionUntypedCase.getInstance();
    }

    @Override
    public <T extends Enum> T enumValue(EnumDataType t) {
        return this._enumValue(t.getSynthFullyQualifiedName(), t.getFields().size());
    }

    private <T extends Enum> T _enumValue(String n, int size) {
        ClassUtils.ClassMeta cm = ClassUtils.getMeta(n);
        int i = 0;
        if (size > 1) {
            this.r.nextInt(size - 1);
        }
        try {
            Field field = cm.getTypeClass().getDeclaredFields()[i];
            Object v = java.lang.Enum.valueOf(field.getType(), field.getName());
            return (T)((Enum)v);
        }
        catch (Exception e) {
            if (e instanceof AlfaRuntimeException) {
                throw (AlfaRuntimeException)e;
            }
            throw new AlfaRuntimeException(ConstraintType.InvalidConstant, (Throwable)e);
        }
    }

    @Override
    public <T extends Union> T unionValue(UnionDataType t) {
        String n = t.getSynthFullyQualifiedName();
        if (this.randomizable(n)) {
            return (T)((Union)this.random(n));
        }
        throw new RuntimeException();
    }

    @Override
    public <T> T metaValue(MetaDataType t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends AlfaObject> T objectValue(UdtDataType t) {
        return this.objectValue(t, Collections.emptyMap());
    }

    @Override
    public <T extends AlfaObject> T objectValue(Optional<Class> clz) {
        return this.objectValue(Optional.empty(), Collections.emptyMap());
    }

    @Override
    public <T extends AlfaObject> T objectValue(Optional<ClassUtils.ClassMeta> cm, Map<String, Function> templateFieldSuppliers) {
        throw new RuntimeException();
    }

    @Override
    public <T extends AlfaObject> T objectValue(UdtDataType t, Map<String, Function> templateFieldSuppliers) {
        String n = t.getFullyQualifiedName();
        ClassUtils.ClassMeta m = ClassUtils.getMeta(n);
        if (this.randomizable(n)) {
            return this.random(n);
        }
        if (NativeAlfaObject.class.isAssignableFrom(m.getTypeClass())) {
            Builder v = m.getNewBuilder(BuilderConfig.getInstance());
            v.modify(null, "ignore");
            return v.build();
        }
        if (m.getModel().getUdtDataType().getUdtType() == UdtMetaType.enumType) {
            return this._enumValue(n, m.getModel().getAllFieldsMeta().size());
        }
        throw new RuntimeException();
    }

    @Override
    public <T extends Record> T tupleValue(TupleDataType t) {
        String n = t.getSynthFullyQualifiedName();
        if (this.randomizable(n)) {
            return (T)((Record)this.random(n));
        }
        throw new RuntimeException();
    }

    @Override
    public <T> Optional<T> optionalValue(OptionalDataType f, Function<DataSupplier, T> c) {
        if (this.r.nextInt(10) == 5) {
            return Optional.empty();
        }
        this.currentTypeStack.push(f.getComponentType());
        T r = c.apply(this);
        this.currentTypeStack.pop();
        Optional<T> v = Optional.ofNullable(r);
        return v;
    }

    @Override
    public <T> Try<T> tryValue(TryDataType f, Function<DataSupplier, T> c) {
        if (this.r.nextInt(10) == 1) {
            TryFailure fmsg = TryFailure.builder().setMessage("Failed on checked value").build();
            return Try.builder().setFailure(fmsg).build();
        }
        this.currentTypeStack.push(f.getComponentType());
        T res = c.apply(this);
        AlfaObject v = Try.builder().setResult(res).build();
        return v;
    }

    @Override
    public <T> Compressed compressedValue(CompressedDataType f, Function<DataSupplier, T> compressedConsumer) {
        T v = compressedConsumer.apply(this);
        Converters.SupplierConsumer cs = Converters.createSupplierConsumer(f.getComponentType());
        return DefaultCompressed.fromValue(cs, BuilderConfig.getInstance(), v);
    }

    @Override
    public <T> Compressed compressedValue(Function<DataSupplier, T> compressedConsumer) {
        throw new IllegalStateException();
    }

    @Override
    public <T> Encrypted<T> encryptedValue(Function<DataSupplier, T> encryptedConsumer) {
        return DefaultEncrypted.fromValue(encryptedConsumer, this.binaryValue(null));
    }

    @Override
    public <T> List<T> streamValue(StreamDataType std, Function<DataSupplier, T> c) {
        T v = c.apply(this);
        return Stream.of(v).collect(Collectors.toList());
    }

    @Override
    public <T> Future<T> futureValue(FutureDataType fdt, Function<DataSupplier, T> c) {
        T v = c.apply(this);
        CompletableFuture<T> f = new CompletableFuture<T>();
        f.complete(v);
        return f;
    }

    @Override
    public <T> ITable tableValue(TabularDataType tdt, Function<DataSupplier, T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <L, R> Pair<L, R> pairValue(PairDataType edt, Function<DataSupplier, L> lc, Function<DataSupplier, R> rc) {
        L l = lc.apply(this);
        R r = rc.apply(this);
        AlfaObject v = Pair.builder().setRight(r).setLeft(l).build();
        return v;
    }

    @Override
    public <L, R> Either<L, R> eitherValue(EitherDataType edt, Function<DataSupplier, L> lc, Function<DataSupplier, R> rc) {
        if (this.r.nextInt(10) % 2 == 0) {
            L l = lc.apply(this);
            AlfaObject v = Either.builder().setLeft(l).build();
            return v;
        }
        R r = rc.apply(this);
        AlfaObject v = Either.builder().setRight(r).build();
        return v;
    }

    @Override
    public <K, V> Map<K, V> mapValue(MapDataType t, Function<DataSupplier, K> kc, Function<DataSupplier, V> vc) {
        int max = t.getSizeMax().orElse(5);
        LinkedHashMap<K, V> l = new LinkedHashMap<K, V>();
        for (int i = 0; i < max; ++i) {
            this.currentTypeStack.push(t.getKeyType());
            K k = kc.apply(this);
            Utils.assertNotNull(k);
            this.currentTypeStack.pop();
            this.currentTypeStack.push(t.getValueType());
            V v = vc.apply(this);
            Utils.assertNotNull(v);
            this.currentTypeStack.pop();
            l.put(k, v);
        }
        return l;
    }

    @Override
    public <T> Set<T> setValue(SetDataType f, Function<DataSupplier, T> consumer) {
        int max = f.getSizeMax().orElse(5);
        LinkedHashSet<T> l = new LinkedHashSet<T>();
        for (int i = 0; i < max; ++i) {
            this.currentTypeStack.push(f.getComponentType());
            T en = consumer.apply(this);
            Utils.assertNotNull(en);
            l.add(en);
            this.currentTypeStack.pop();
        }
        return l;
    }

    @Override
    public <T> List<T> listValue(ListDataType f, Function<DataSupplier, T> consumer) {
        int max = f.getSizeMax().orElse(5);
        ArrayList<T> l = new ArrayList<T>();
        for (int i = 0; i < max; ++i) {
            this.currentTypeStack.push(f.getComponentType());
            T en = consumer.apply(this);
            Utils.assertNotNull(en);
            l.add(en);
            this.currentTypeStack.pop();
        }
        return l;
    }

    @Override
    public IBuilderConfig codecConfig() {
        return this.cfg;
    }
}

