/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int;

import com.fasterxml.jackson.core.JsonGenerator;
import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Compressed;
import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.Encrypted;
import com.schemarise.alfa.runtime.Entity;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.ITable;
import com.schemarise.alfa.runtime.Key;
import com.schemarise.alfa.runtime.NativeAlfaObject;
import com.schemarise.alfa.runtime.NoOpDataConsumer;
import com.schemarise.alfa.runtime.NormalizedPeriod;
import com.schemarise.alfa.runtime.Union;
import com.schemarise.alfa.runtime.UnionUntypedCase;
import com.schemarise.alfa.runtime.codec.OptSetChecker;
import com.schemarise.alfa.runtime.codec.json.JsonCodecConfig;
import com.schemarise.alfa.runtime.codec.json.JsonTypeWriteMode;
import com.schemarise.alfa.runtime.utils.ClassUtils;
import com.schemarise.alfa.runtime_int.JsonGeneratorWrapper;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import schemarise.alfa.runtime.model.CompressedDataType;
import schemarise.alfa.runtime.model.EncryptedDataType;
import schemarise.alfa.runtime.model.FutureDataType;
import schemarise.alfa.runtime.model.IDataType;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.MapDataType;
import schemarise.alfa.runtime.model.MetaDataType;
import schemarise.alfa.runtime.model.OptionalDataType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.SetDataType;
import schemarise.alfa.runtime.model.StreamDataType;
import schemarise.alfa.runtime.model.TabularDataType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;
import schemarise.alfa.runtime.model.asserts.ConstraintType;

final class JsonDataConsumer
extends DataConsumer {
    private Map<String, DateTimeFormatter> dateFormatMap = new HashMap<String, DateTimeFormatter>();
    private Set<String> checksumsWritten = new HashSet<String>();
    static String CompoundMapKeyField = "key";
    static String CompoundMapValField = "val";
    static String MetaFieldTypeName = "type";
    static String MetaFieldChecksum = "csum";
    static String MetaModelId = "modelid";
    static String MetaFieldVersion = "ver";
    static String MetaFieldId = "id";
    static String MetaFieldIdRef = "idref";
    static Set<String> MetaFieldNames = new HashSet<String>(Arrays.asList(MetaFieldTypeName, MetaFieldChecksum, MetaModelId, MetaFieldVersion, MetaFieldId, MetaFieldIdRef, CompoundMapKeyField));
    private final OutputStream stream;
    private JsonGeneratorWrapper jGenerator;
    private final JsonCodecConfig jsonCfg;
    private Set<AlfaObject> visited = new HashSet<AlfaObject>();
    private Stack<IDataType> declaredAsStack = new Stack();
    private int nestedLevel = 0;
    ScalarConsumer scalarConsumer = new ScalarConsumer();

    JsonDataConsumer(JsonCodecConfig jwc, JsonGenerator jGenerator, OutputStream stream) {
        this.jGenerator = new JsonGeneratorWrapper(jGenerator);
        this.jsonCfg = jwc;
        this.stream = stream;
    }

    @Override
    public OutputStream closeAndGetBuffer() {
        try {
            this.jGenerator.close();
            this.stream.close();
            return this.stream;
        }
        catch (Exception e) {
            if (e instanceof AlfaRuntimeException) {
                throw (AlfaRuntimeException)e;
            }
            throw new AlfaRuntimeException(ConstraintType.Unknown, (Throwable)e);
        }
    }

    @Override
    public void consume(IDataType dst, AlfaObject v, Map<String, BiConsumer> templatedFieldConsumer) {
        ++this.nestedLevel;
        if (v == null && !this.jsonCfg.assertMandatoryFieldsSet()) {
            this.jGenerator.writeNull();
            return;
        }
        if (v instanceof Enum) {
            Enum ae = (Enum)v;
            if (ae.getLexicalValue().isPresent()) {
                this.jGenerator.writeString(ae.getLexicalValue().get());
            } else {
                this.jGenerator.writeString(v.toString());
            }
            return;
        }
        if (v instanceof NativeAlfaObject) {
            NativeAlfaObject nao = (NativeAlfaObject)v;
            this.jGenerator.writeString(nao.encodeToString());
        } else {
            if (v instanceof Union && !((Union)v).isTagged()) {
                Union u = (Union)v;
                Optional fs = v.descriptor().getFieldSupplier(u.caseName());
                if (!fs.isPresent()) {
                    throw new AlfaRuntimeException("Supplier not available for field '" + u.caseName() + "'");
                }
                BiConsumer<AlfaObject, DataConsumer> sup = fs.get();
                sup.accept(v, this);
                return;
            }
            if (this.jsonCfg.isWriteDetectCycles()) {
                if (this.visited.contains(v)) {
                    throw new AlfaRuntimeException("Cycle detected");
                }
                this.visited.add(v);
            }
            this.jGenerator.writeStartObject();
            boolean writeType = false;
            if (this.jsonCfg.getWriteTypeMode() != JsonTypeWriteMode.NeverWriteType) {
                if (this.nestedLevel == 1 && this.jsonCfg.getWriteTypeMode() != JsonTypeWriteMode.NoRootAndMinimal) {
                    writeType = true;
                } else if (this.nestedLevel > 1) {
                    UdtDataType udtDt;
                    if (this.jsonCfg.getWriteTypeMode() == JsonTypeWriteMode.AlwaysWriteType) {
                        writeType = true;
                    } else if (dst instanceof UdtDataType && (udtDt = (UdtDataType)dst).getUdtType() == UdtMetaType.traitType) {
                        writeType = true;
                    }
                }
            }
            if (writeType) {
                Object ver = "";
                if (v.descriptor().getUdtDataType().getVersion().isPresent()) {
                    ver = "@" + v.descriptor().getUdtDataType().getVersion().get();
                }
                String tname = v.descriptor().getUdtDataType().getFullyQualifiedName() + (String)ver;
                this.jGenerator.writeStringField(this.jsonCfg.getMetaFieldPrefix() + MetaFieldTypeName, tname);
                if (this.jsonCfg.isWriteModelId() && v.descriptor().getModelId().isPresent()) {
                    this.jGenerator.writeStringField(this.jsonCfg.getMetaFieldPrefix() + MetaModelId, v.descriptor().getModelId().get());
                }
                if (this.jsonCfg.isWriteCheckSum() && !this.checksumsWritten.contains(tname)) {
                    this.jGenerator.writeStringField(this.jsonCfg.getMetaFieldPrefix() + MetaFieldChecksum, v.descriptor().getChecksum());
                    this.checksumsWritten.add(tname);
                }
            }
            if (v instanceof Union) {
                Union u = (Union)v;
                String c = u.caseName();
                this.jGenerator.writeFieldName(c);
                BiConsumer<Object, DataConsumer> sup = templatedFieldConsumer.get(c);
                if (sup != null) {
                    Object cv = u.caseValue();
                    sup.accept(cv, this);
                } else {
                    Optional fs = v.descriptor().getFieldSupplier(c);
                    if (!fs.isPresent()) {
                        throw new AlfaRuntimeException("Supplier not available for field '" + c + "'");
                    }
                    sup = fs.get();
                    sup.accept(v, this);
                }
            } else {
                Entity ent;
                Optional<? extends Key> k;
                if (v instanceof Entity && (k = (ent = (Entity)v).get$key()).isPresent()) {
                    if (this.jsonCfg.isWriteEntityKeyAsObject()) {
                        Key ek = k.get();
                        this.jGenerator.writeFieldName(this.jsonCfg.getMetaFieldPrefix() + "key");
                        this.declaredAsStack.push(ek.descriptor().getUdtDataType());
                        this.consume(ek);
                        this.declaredAsStack.pop();
                    } else {
                        Key ek = k.get();
                        this.writeObjectFields(ek);
                    }
                }
                this.writeObjectFields(v);
            }
            this.jGenerator.writeEndObject();
            if (this.jsonCfg.isWriteDetectCycles()) {
                this.visited.remove(v);
            }
        }
        --this.nestedLevel;
    }

    private void writeObjectFields(AlfaObject v) {
        OptSetChecker checker = new OptSetChecker();
        for (String fn : v.descriptor().getAllFieldsMeta().keySet()) {
            BiConsumer<AlfaObject, DataConsumer> sup = v.descriptor().getFieldSupplier(fn).get();
            FieldMeta fmeta = v.descriptor().getAllFieldsMeta().get(fn);
            IDataType fdt = fmeta.getDataType();
            if (fdt instanceof OptionalDataType) {
                sup.accept(v, checker);
                if (!checker.isSet()) {
                    if (!this.jsonCfg.isWriteEmptyOptionalAsNull()) continue;
                    this.jGenerator.writeFieldName(fn);
                    this.jGenerator.writeNull();
                }
            }
            this.jGenerator.writeFieldName(fn);
            this.declaredAsStack.push(fdt);
            sup.accept(v, this);
            this.declaredAsStack.pop();
        }
    }

    @Override
    public void consume(ScalarDataType dt, int v) {
        if (this.jsonCfg.isWriteStringifiedNumbers()) {
            this.jGenerator.writeString(String.valueOf(v));
        } else {
            this.jGenerator.writeNumber(v);
        }
    }

    @Override
    public void consume(ScalarDataType dt, String v) {
        this.jGenerator.writeString(v);
    }

    @Override
    public void consume(ScalarDataType dt, float v) {
        if (this.jsonCfg.isWriteStringifiedNumbers()) {
            this.jGenerator.writeString(String.valueOf(v));
        } else {
            this.jGenerator.writeNumber(v);
        }
    }

    @Override
    public void consume(ScalarDataType dt, double v) {
        if (this.jsonCfg.isWriteStringifiedNumbers()) {
            this.jGenerator.writeString(String.valueOf(v));
        } else {
            this.jGenerator.writeNumber(v);
        }
    }

    @Override
    public void consume(ScalarDataType dt, short v) {
        this.jGenerator.writeNumber(v);
    }

    @Override
    public void consume(ScalarDataType dt, long v) {
        if (this.jsonCfg.isWriteStringifiedNumbers()) {
            this.jGenerator.writeString(String.valueOf(v));
        } else {
            this.jGenerator.writeNumber(v);
        }
    }

    @Override
    public void consume(ScalarDataType dt, byte[] v) {
        this.jGenerator.writeBinary(v);
    }

    @Override
    public void consume(ScalarDataType dt, byte v) {
        this.jGenerator.writeBinary(new byte[]{v});
    }

    @Override
    public void consume(ScalarDataType dt, char v) {
        this.jGenerator.writeString("" + v);
    }

    @Override
    public void consume(ScalarDataType dt, boolean v) {
        this.jGenerator.writeBoolean(v);
    }

    @Override
    public void consume(ScalarDataType dt, BigDecimal v) {
        this.jGenerator.writeNumber(v);
    }

    private DateTimeFormatter getFormat(String fmt) {
        DateTimeFormatter df = this.dateFormatMap.get(fmt);
        if (df == null) {
            df = DateTimeFormatter.ofPattern(fmt);
            this.dateFormatMap.put(fmt, df);
        }
        return df;
    }

    @Override
    public void consume(ScalarDataType dt, LocalDate v) {
        if (v == null) {
            this.jGenerator.writeNull();
        } else if (dt.getStrPattern().isPresent() && !this.jsonCfg.isIgnoreDateFormat()) {
            DateTimeFormatter df = this.getFormat(dt.getStrPattern().get());
            this.jGenerator.writeString(df.format(v));
        } else {
            this.jGenerator.writeString(v.format(DateTimeFormatter.ISO_DATE));
        }
    }

    @Override
    public void consume(ScalarDataType dt, LocalDateTime v) {
        if (v == null) {
            this.jGenerator.writeNull();
        } else if (dt.getStrPattern().isPresent() && !this.jsonCfg.isIgnoreDateFormat()) {
            DateTimeFormatter df = this.getFormat(dt.getStrPattern().get());
            this.jGenerator.writeString(df.format(v));
        } else {
            this.jGenerator.writeString(v.format(DateTimeFormatter.ISO_DATE_TIME));
        }
    }

    @Override
    public void consume(ScalarDataType dt, ZonedDateTime v) {
        if (v == null) {
            this.jGenerator.writeNull();
        } else if (dt.getStrPattern().isPresent() && !this.jsonCfg.isIgnoreDateFormat()) {
            DateTimeFormatter df = this.getFormat(dt.getStrPattern().get());
            this.jGenerator.writeString(df.format(v));
        } else {
            this.jGenerator.writeString(v.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
    }

    @Override
    public void consume(ScalarDataType dt, LocalTime v) {
        if (v == null) {
            this.jGenerator.writeNull();
        } else if (dt.getStrPattern().isPresent() && !this.jsonCfg.isIgnoreDateFormat()) {
            DateTimeFormatter df = this.getFormat(dt.getStrPattern().get());
            this.jGenerator.writeString(df.format(v));
        } else {
            this.jGenerator.writeString(v.format(DateTimeFormatter.ISO_TIME));
        }
    }

    @Override
    public void consume(ScalarDataType dt, Duration v) {
        if (v == null) {
            this.jGenerator.writeNull();
        } else {
            this.jGenerator.writeString("" + v);
        }
    }

    @Override
    public void consume(ScalarDataType dt, NormalizedPeriod v) {
        if (v == null) {
            this.jGenerator.writeNull();
        } else {
            this.jGenerator.writeString("" + v);
        }
    }

    @Override
    public void consume(ScalarDataType dt, UUID v) {
        if (v == null) {
            this.jGenerator.writeNull();
        } else {
            this.jGenerator.writeString("" + v);
        }
    }

    @Override
    public void consume(ScalarDataType dt, URI v) {
        if (v == null) {
            this.jGenerator.writeNull();
        } else {
            this.jGenerator.writeString("" + v);
        }
    }

    @Override
    public void consume(ScalarDataType dt, UnionUntypedCase v) {
        this.jGenerator.writeNull();
    }

    @Override
    public <T> void consume(OptionalDataType dt, Optional<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        if (v.isPresent()) {
            this.declaredAsStack.push(dt.getComponentType());
            elementConsumer.accept(v.get(), this);
            this.declaredAsStack.pop();
        } else {
            this.jGenerator.writeNull();
        }
    }

    @Override
    public <T> void consume(CompressedDataType dt, Compressed v, BiConsumer<T, DataConsumer> elementConsumer) {
        this.jGenerator.writeBinary(v.getEncodedBytes());
    }

    @Override
    public <T> void consume(EncryptedDataType dt, Encrypted<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        this.jGenerator.writeBinary(v.getEncodedBytes());
    }

    @Override
    public <K, V> void consume(MapDataType dt, Map<K, V> v, BiConsumer<K, DataConsumer> keyConsumer, BiConsumer<V, DataConsumer> valueConsumer) {
        if (dt.getKeyType() instanceof ScalarDataType && this.jsonCfg.isWriteMapAsObject()) {
            this.consumeScalarMapKeyed(dt, v, keyConsumer, valueConsumer);
        } else {
            UdtDataType udt;
            ClassUtils.ClassMeta cm;
            if (dt.getKeyType() instanceof UdtDataType && (cm = ClassUtils.getMeta((udt = (UdtDataType)dt.getKeyType()).getFullyQualifiedName())).getModel().getUdtDataType().getUdtType() == UdtMetaType.enumType) {
                this.consumeScalarMapKeyed(dt, v, keyConsumer, valueConsumer);
                return;
            }
            this.jGenerator.writeStartArray();
            String kn = dt.getKeyName().orElse(CompoundMapKeyField);
            String vn = dt.getValueName().orElse(CompoundMapValField);
            v.entrySet().forEach(e -> {
                this.jGenerator.writeStartObject();
                this.jGenerator.writeFieldName(kn);
                this.declaredAsStack.push(dt.getKeyType());
                keyConsumer.accept(e.getKey(), this);
                this.declaredAsStack.pop();
                this.jGenerator.writeFieldName(vn);
                this.declaredAsStack.push(dt.getValueType());
                valueConsumer.accept(e.getValue(), this);
                this.declaredAsStack.pop();
                this.jGenerator.writeEndObject();
            });
            this.jGenerator.writeEndArray();
        }
    }

    private <K, V> void consumeScalarMapKeyed(MapDataType dt, Map<K, V> v, BiConsumer<K, DataConsumer> keyConsumer, BiConsumer<V, DataConsumer> valueConsumer) {
        if (v == null && !this.jsonCfg.assertMandatoryFieldsSet()) {
            this.jGenerator.writeNull();
            return;
        }
        this.jGenerator.writeStartObject();
        v.entrySet().forEach(e -> {
            this.declaredAsStack.push(dt.getKeyType());
            keyConsumer.accept(e.getKey(), this.scalarConsumer);
            this.declaredAsStack.pop();
            this.declaredAsStack.push(dt.getValueType());
            valueConsumer.accept(e.getValue(), this);
            this.declaredAsStack.pop();
        });
        this.jGenerator.writeEndObject();
    }

    @Override
    public <T> void consume(SetDataType dt, Set<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        if (v == null && !this.jsonCfg.assertMandatoryFieldsSet()) {
            this.jGenerator.writeNull();
            return;
        }
        this.jGenerator.writeStartArray();
        v.forEach(e -> {
            this.declaredAsStack.push(dt.getComponentType());
            elementConsumer.accept(e, this);
            this.declaredAsStack.pop();
        });
        this.jGenerator.writeEndArray();
    }

    @Override
    public <T> void consume(ListDataType dt, List<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        this.jGenerator.writeStartArray();
        v.forEach(e -> {
            this.declaredAsStack.push(dt.getComponentType());
            elementConsumer.accept(e, this);
            this.declaredAsStack.pop();
        });
        this.jGenerator.writeEndArray();
    }

    @Override
    public <T> void consume(StreamDataType dt, List<T> f1, BiConsumer<T, DataConsumer> elementConsumer) {
        this.jGenerator.writeStartArray();
        f1.forEach(e -> {
            this.declaredAsStack.push(dt.getComponentType());
            elementConsumer.accept(e, this);
            this.declaredAsStack.pop();
        });
        this.jGenerator.writeEndArray();
    }

    @Override
    public <T> void consume(FutureDataType dt, Future<T> f1, BiConsumer<T, DataConsumer> consumer) {
        try {
            this.declaredAsStack.push(dt.getComponentType());
            consumer.accept(f1.get(), this);
            this.declaredAsStack.pop();
        }
        catch (Exception e) {
            if (e instanceof AlfaRuntimeException) {
                throw (AlfaRuntimeException)e;
            }
            throw new AlfaRuntimeException(ConstraintType.Unknown, (Throwable)e);
        }
    }

    @Override
    public <T> void consume(MetaDataType dt, T f1) {
        switch (dt.getMetaType()) {
            case Udt: 
            case Key: 
            case Trait: 
            case Entity: 
            case Record: 
            case Union: {
                this.consume((AlfaObject)f1);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public <T> void consume(TabularDataType dt, ITable f1, BiConsumer<T, DataConsumer> consumer) {
        throw new UnsupportedOperationException();
    }

    class ScalarConsumer
    extends NoOpDataConsumer {
        ScalarConsumer() {
        }

        @Override
        public void consume(UdtDataType dt, AlfaObject v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, int v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, String v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, double v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, float v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, short v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, long v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, byte v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, byte[] v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, char v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, boolean v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, BigDecimal v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, LocalDate v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, LocalDateTime v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, LocalTime v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, Duration v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, UUID v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, URI v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }

        @Override
        public void consume(ScalarDataType dt, UnionUntypedCase v) {
            JsonDataConsumer.this.jGenerator.writeFieldName(String.valueOf(v));
        }
    }
}

