/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int.table;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.NativeAlfaObject;
import com.schemarise.alfa.runtime.NoOpDataConsumer;
import com.schemarise.alfa.runtime.NormalizedPeriod;
import com.schemarise.alfa.runtime.Trait;
import com.schemarise.alfa.runtime.Union;
import com.schemarise.alfa.runtime.UnionUntypedCase;
import com.schemarise.alfa.runtime.codec.Converters;
import com.schemarise.alfa.runtime_int.table.Row;
import com.schemarise.alfa.runtime_int.table.Table;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.EitherDataType;
import schemarise.alfa.runtime.model.IDataType;
import schemarise.alfa.runtime.model.IVectorDataType;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.MapDataType;
import schemarise.alfa.runtime.model.OptionalDataType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.SetDataType;
import schemarise.alfa.runtime.model.Try;
import schemarise.alfa.runtime.model.TryDataType;

class AlfaFlattener
extends NoOpDataConsumer {
    private final List<? super AlfaObject> alfaObjects;
    private final Table table;
    private Stack<CurrentObjectInfo> vectorInfo = new Stack();
    private int nestedVectorLevel = 0;

    public AlfaFlattener(List<AlfaObject> obs) {
        this.alfaObjects = obs;
        this.table = new Table(obs.get(0).descriptor().getUdtDataType());
    }

    public AlfaFlattener(AlfaObject ao) {
        this.alfaObjects = new ArrayList<AlfaObject>();
        this.alfaObjects.add(ao);
        this.table = new Table(ao.descriptor().getUdtDataType());
    }

    @Override
    public void consume(IDataType dt, AlfaObject v, Map<String, BiConsumer> templatedFieldConsumer) {
        CurrentObjectInfo co = new CurrentObjectInfo();
        this.vectorInfo.push(co);
        boolean bl = co.requiresDimensionCol = v.descriptor().getAllFieldsMeta().values().stream().map(e -> e.getDataType()).filter(e -> e instanceof IVectorDataType).count() > 1L;
        if (v instanceof Union) {
            Union u = (Union)v;
            this.table.update(Converters.DataTypeString, this.currentFieldName() + "__Case", u.caseName());
        } else if (v instanceof Enum) {
            Enum en = (Enum)v;
            this.table.update(Converters.DataTypeString, this.currentFieldName(), en.toString());
        } else if (v instanceof Trait) {
            this.table.update(Converters.DataTypeString, this.currentFieldName() + "__Type", v.descriptor().getUdtDataType().getFullyQualifiedName());
        } else if (v instanceof NativeAlfaObject) {
            NativeAlfaObject no = (NativeAlfaObject)v;
            this.table.update(Converters.DataTypeString, this.genColName(), no.encodeToString());
        }
        super.consume(dt, v, templatedFieldConsumer);
        this.vectorInfo.pop();
    }

    @Override
    protected <T extends AlfaObject> Map<String, FieldMeta<T>> getFieldsMeta(AlfaObject ao) {
        List nonVecs = ao.descriptor().getAllFieldsMeta().values().stream().filter(e -> !(e.getDataType() instanceof IVectorDataType)).collect(Collectors.toList());
        List vecs = ao.descriptor().getAllFieldsMeta().values().stream().filter(e -> e.getDataType() instanceof IVectorDataType).collect(Collectors.toList());
        ArrayList l = new ArrayList();
        l.addAll(nonVecs);
        l.addAll(vecs);
        LinkedHashMap m = new LinkedHashMap();
        l.forEach(e -> m.put(e.getField().getName(), (FieldMeta)e));
        return m;
    }

    public Table flatten() {
        this.table.insertRow();
        for (int i = 0; i < this.alfaObjects.size(); ++i) {
            this.consume(this.alfaObjects.get(i));
            if (i + 1 >= this.alfaObjects.size()) continue;
            this.table.insertRow();
        }
        return this.table;
    }

    private String genColName() {
        StringJoiner sj = new StringJoiner("_");
        this.getFieldNamesHierarchy().forEach(f -> sj.add((CharSequence)f));
        return sj.toString();
    }

    @Override
    public void consume(ScalarDataType dt, String v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, double v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, float v) {
        String cn = this.genColName();
        this.table.update(dt, cn, Float.valueOf(v));
    }

    @Override
    public void consume(ScalarDataType dt, short v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, long v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, byte v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, byte[] v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, char v) {
        String cn = this.genColName();
        this.table.update(dt, cn, Character.valueOf(v));
    }

    @Override
    public void consume(ScalarDataType dt, boolean v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, BigDecimal v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, LocalDate v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, LocalDateTime v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, ZonedDateTime v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, LocalTime v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, Duration v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, NormalizedPeriod v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, UUID v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, URI v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, UnionUntypedCase v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public void consume(ScalarDataType dt, int v) {
        String cn = this.genColName();
        this.table.update(dt, cn, v);
    }

    @Override
    public <T> void consume(TryDataType dt, Try<T> v, BiConsumer<T, DataConsumer> c) {
        this.table.update(Converters.DataTypeBoolean, "__" + this.genColName() + "_IsFailure", v.isFailure());
        if (v.isResult()) {
            c.accept(v.getResult(), this);
        } else {
            this.consume(v.getFailure());
        }
    }

    @Override
    public <L, R> void consume(EitherDataType dt, Either<L, R> v, BiConsumer<L, DataConsumer> leftConsumer, BiConsumer<R, DataConsumer> rightConsumer) {
        this.table.update(Converters.DataTypeBoolean, "__" + this.genColName() + "_IsLeft", v.isLeft());
        if (v.isLeft()) {
            this.preConsumeField("Left", dt.getLeftComponentType());
            leftConsumer.accept(v.getLeft(), this);
            this.postConsumeField("Left", dt.getLeftComponentType(), false);
        } else {
            this.preConsumeField("Right", dt.getRightComponentType());
            rightConsumer.accept(v.getRight(), this);
            this.postConsumeField("Right", dt.getLeftComponentType(), false);
        }
    }

    @Override
    public <T> void consume(OptionalDataType dt, Optional<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        this.table.update(Converters.DataTypeBoolean, "__" + this.genColName() + "_IsSet", v.isPresent());
        if (v.isPresent()) {
            elementConsumer.accept(v.get(), this);
        }
    }

    private String nestedLevel() {
        if (this.nestedVectorLevel == 1) {
            return "";
        }
        return "_L" + (this.nestedVectorLevel - 1);
    }

    @Override
    public <K, V> void consume(MapDataType dt, Map<K, V> data, BiConsumer<K, DataConsumer> keyConsumer, BiConsumer<V, DataConsumer> valueConsumer) {
        ++this.nestedVectorLevel;
        CurrentObjectInfo co = this.preVectorProcessInit(data.size(), dt.getSizeMin());
        AtomicInteger row = new AtomicInteger(0);
        data.forEach((k, v) -> {
            this.vectorPreIterateInit(co, dt.getSizeMin(), row);
            this.vectorInfo.push(new CurrentObjectInfo());
            String kName = dt.getKeyName().orElse("Key") + this.nestedLevel();
            this.preConsumeField(kName, dt.getKeyType());
            keyConsumer.accept(k, this);
            this.postConsumeField(kName, dt.getKeyType(), false);
            String vName = dt.getValueName().orElse("Value") + this.nestedLevel();
            this.preConsumeField(vName, dt.getValueType());
            valueConsumer.accept(v, this);
            this.postConsumeField(vName, dt.getValueType(), false);
            this.vectorInfo.pop();
        });
        --this.nestedVectorLevel;
    }

    @Override
    public <T> void consume(ListDataType dt, List<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        ++this.nestedVectorLevel;
        int sz = v.size();
        CurrentObjectInfo co = this.preVectorProcessInit(sz, dt.getSizeMin());
        AtomicInteger row = new AtomicInteger(0);
        IntStream.range(0, sz).forEach(_i -> {
            this.vectorPreIterateInit(co, dt.getSizeMin(), row);
            int i = sz - _i;
            this.table.update(Converters.DataTypeInt, "__" + this.genColName() + "__Id" + this.nestedLevel(), i);
            Object e = v.get(i - 1);
            this.vectorInfo.push(new CurrentObjectInfo());
            elementConsumer.accept(e, this);
            this.vectorInfo.pop();
        });
        --this.nestedVectorLevel;
    }

    @Override
    public <T> void consume(SetDataType dt, Set<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        ++this.nestedVectorLevel;
        CurrentObjectInfo co = this.preVectorProcessInit(v.size(), dt.getSizeMin());
        AtomicInteger row = new AtomicInteger(0);
        int sz = v.size();
        v.forEach(e -> {
            this.vectorPreIterateInit(co, dt.getSizeMin(), row);
            int i = sz - row.get() + 1;
            this.table.update(Converters.DataTypeInt, "__" + this.genColName() + "__Id" + this.nestedLevel(), i);
            this.vectorInfo.push(new CurrentObjectInfo());
            elementConsumer.accept(e, this);
            this.vectorInfo.pop();
        });
        --this.nestedVectorLevel;
    }

    private CurrentObjectInfo preVectorProcessInit(int dataSize, Optional<Integer> sizeMin) {
        boolean emptyReqd;
        CurrentObjectInfo co = this.vectorInfo.peek();
        if (co.hasPreVectorVisitRow()) {
            this.table.cloneAndAdvanceRow(co.preVectorExpansionRow);
        }
        if (!co.hasPreVectorVisitRow()) {
            co.setPreVectorVisitRow(this.table.getCurrentRowObjectCopy());
        }
        if (co.requiresDimensionCol) {
            this.table.update(Converters.DataTypeString, "__Dimension", this.currentFieldName());
        }
        boolean bl = emptyReqd = !sizeMin.isPresent() || sizeMin.isPresent() && sizeMin.get() == 0;
        if (emptyReqd && dataSize == 0) {
            this.table.update(Converters.DataTypeBoolean, "__" + this.genColName() + "_IsEmpty" + this.nestedLevel(), true);
        }
        return co;
    }

    private void vectorPreIterateInit(CurrentObjectInfo co, Optional<Integer> sizeMin, AtomicInteger row) {
        boolean emptyReqd;
        if (row.getAndIncrement() > 0) {
            this.table.cloneAndAdvanceRow(co.preVectorExpansionRow);
        }
        boolean bl = emptyReqd = !sizeMin.isPresent() || sizeMin.isPresent() && sizeMin.get() == 0;
        if (emptyReqd) {
            this.table.update(Converters.DataTypeBoolean, "__" + this.genColName() + "_IsEmpty" + this.nestedLevel(), false);
        }
        if (co.requiresDimensionCol) {
            this.table.update(Converters.DataTypeString, "__Dimension" + this.nestedLevel(), this.currentFieldName());
        }
    }

    class CurrentObjectInfo {
        private Row preVectorExpansionRow;
        private boolean requiresDimensionCol = false;

        CurrentObjectInfo() {
        }

        public void setPreVectorVisitRow(Row r) {
            if (this.preVectorExpansionRow != null) {
                throw new IllegalStateException();
            }
            this.preVectorExpansionRow = r;
        }

        public boolean hasPreVectorVisitRow() {
            return this.preVectorExpansionRow != null;
        }
    }
}

