/*
 * Decompiled with CFR 0.152.
 */
package schemarise.alfa.runtime.model;

import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.utils.DefaultTypeDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.ModifierType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;

public enum MathOperatorType implements Enum
{
    Divide("Divide", Optional.empty()),
    Multiply("Multiply", Optional.empty()),
    Modulus("Modulus", Optional.empty()),
    Add("Add", Optional.empty()),
    Subtract("Subtract", Optional.empty());

    private final String value;
    private final Optional<String> lexical;
    private static Map<String, MathOperatorType> mappings;

    private MathOperatorType(String v, Optional<String> lex) {
        this.value = v;
        this.lexical = lex;
    }

    public static MathOperatorType fromValue(String v) {
        if (mappings == null) {
            HashMap<String, MathOperatorType> m = new HashMap<String, MathOperatorType>();
            for (MathOperatorType c : MathOperatorType.values()) {
                m.put(c.value, c);
            }
            mappings = m;
        }
        return mappings.get(v);
    }

    @Override
    public Optional<String> getLexicalValue() {
        return this.lexical;
    }

    public String value() {
        return this.value;
    }

    @Override
    public TypeDescriptor descriptor() {
        return MathOperatorTypeDescriptor.INSTANCE;
    }

    public static final class MathOperatorTypeDescriptor
    extends DefaultTypeDescriptor {
        public static String TYPE_NAME = "schemarise.alfa.runtime.model.MathOperatorType";
        public static MathOperatorTypeDescriptor INSTANCE = new MathOperatorTypeDescriptor();
        private UdtDataType _asUdtType_ = UdtDataType.builder().setUdtType(UdtMetaType.enumType).setFullyQualifiedName(TYPE_NAME).build();
        public static final short FIELD_ID_DIVIDE = 0;
        public static final String FIELD_DIVIDE = "Divide";
        public static final short FIELD_ID_MULTIPLY = 1;
        public static final String FIELD_MULTIPLY = "Multiply";
        public static final short FIELD_ID_MODULUS = 2;
        public static final String FIELD_MODULUS = "Modulus";
        public static final short FIELD_ID_ADD = 3;
        public static final String FIELD_ADD = "Add";
        public static final short FIELD_ID_SUBTRACT = 4;
        public static final String FIELD_SUBTRACT = "Subtract";
        private ScalarDataType _divideType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _multiplyType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _modulusType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _addType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _subtractType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        public FieldMeta divideMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._divideType, "Divide", Optional.empty());
        public FieldMeta multiplyMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._multiplyType, "Multiply", Optional.empty());
        public FieldMeta modulusMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._modulusType, "Modulus", Optional.empty());
        public FieldMeta addMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._addType, "Add", Optional.empty());
        public FieldMeta subtractMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._subtractType, "Subtract", Optional.empty());
        protected Map<String, Assert> _asserts_ = Collections.unmodifiableMap(new LinkedHashMap(){});
        protected Map<String, FieldMeta<MathOperatorType>> _fieldsMeta_ = Collections.unmodifiableMap(new LinkedHashMap(){
            {
                this.put(MathOperatorTypeDescriptor.FIELD_DIVIDE, divideMeta);
                this.put(MathOperatorTypeDescriptor.FIELD_MULTIPLY, multiplyMeta);
                this.put(MathOperatorTypeDescriptor.FIELD_MODULUS, modulusMeta);
                this.put(MathOperatorTypeDescriptor.FIELD_ADD, addMeta);
                this.put(MathOperatorTypeDescriptor.FIELD_SUBTRACT, subtractMeta);
            }
        });

        public Optional<Function<MathOperatorType, Supplier>> getFieldSupplier(String fieldName) {
            return Optional.empty();
        }

        @Override
        public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
            return Optional.empty();
        }

        @Override
        public boolean hasBuilder() {
            return false;
        }

        @Override
        public boolean convertableToBuilder() {
            return false;
        }

        @Override
        public Builder builder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder builder(IBuilderConfig cc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public UdtDataType getUdtDataType() {
            return this._asUdtType_;
        }

        @Override
        public Map<String, Assert> getAsserts() {
            return this._asserts_;
        }

        public Map<String, FieldMeta<MathOperatorType>> getAllFieldsMeta() {
            return this._fieldsMeta_;
        }

        @Override
        public Optional<TypeDescriptor> getEntityKeyModel() {
            return Optional.empty();
        }

        @Override
        public String fieldIdName(int id) {
            switch (id) {
                case 0: {
                    return FIELD_DIVIDE;
                }
                case 1: {
                    return FIELD_MULTIPLY;
                }
                case 2: {
                    return FIELD_MODULUS;
                }
                case 3: {
                    return FIELD_ADD;
                }
                case 4: {
                    return FIELD_SUBTRACT;
                }
            }
            throw new AlfaRuntimeException("Unknown field id " + id);
        }

        @Override
        public boolean hasAbstractTypeFieldsInClosure() {
            return false;
        }

        @Override
        public Set<String> getImmediateDescendants() {
            return Collections.emptySet();
        }

        @Override
        public Optional<Map<String, Expression>> getAnnotations() {
            return Optional.empty();
        }

        @Override
        public Set<ModifierType> getModifiers() {
            return new HashSet<ModifierType>(){};
        }

        @Override
        public String getChecksum() {
            return "c320399f:";
        }
    }
}

