/*
 * Decompiled with CFR 0.152.
 */
package schemarise.alfa.runtime.model.asserts;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.BuilderConfig;
import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.Key;
import com.schemarise.alfa.runtime.Record;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.Visitor;
import com.schemarise.alfa.runtime.utils.AlfaUtils;
import com.schemarise.alfa.runtime.utils.DefaultTypeDescriptor;
import com.schemarise.alfa.runtime.utils.Utils;
import java.time.LocalDateTime;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.ModifierType;
import schemarise.alfa.runtime.model.OptionalDataType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;
import schemarise.alfa.runtime.model.asserts.ConstraintType;
import schemarise.alfa.runtime.model.asserts.DataQualityType;
import schemarise.alfa.runtime.model.asserts.SeverityType;

public interface ValidationAlert
extends Record {
    public SeverityType getSeverity();

    public LocalDateTime getTimestamp();

    public String getMessage();

    public Optional<String> getTypeName();

    public Optional<String> getIdentification();

    public Optional<String> getAssertName();

    public Optional<String> getFieldName();

    public Optional<ConstraintType> getViolatedConstraint();

    public Optional<DataQualityType> getDataQualityCategory();

    public Optional<String> getSourceInfo();

    public Optional<String> getExceptionDetails();

    public static ValidationAlertBuilder builder() {
        return new _ValidationAlertBuilderImpl();
    }

    public static ValidationAlertBuilder builder(IBuilderConfig bc) {
        if (bc.getCustomBuilderFactory().isPresent()) {
            return (ValidationAlertBuilder)bc.getCustomBuilderFactory().get().builder(bc, ValidationAlertDescriptor.INSTANCE, new Object[0]);
        }
        return new _ValidationAlertBuilderImpl(bc);
    }

    default public <B extends Builder> B toBuilder(IBuilderConfig bc) {
        return (B)AlfaUtils.toBuilder(bc, this);
    }

    default public <B extends Builder> B toBuilder() {
        return this.toBuilder(BuilderConfig.getInstance());
    }

    public static final class ValidationAlertDescriptor
    extends DefaultTypeDescriptor {
        public static String TYPE_NAME = "schemarise.alfa.runtime.model.asserts.ValidationAlert";
        public static ValidationAlertDescriptor INSTANCE = new ValidationAlertDescriptor();
        private UdtDataType _asUdtType_ = UdtDataType.builder().setUdtType(UdtMetaType.recordType).setFullyQualifiedName(TYPE_NAME).build();
        public static final short FIELD_ID_SEVERITY = 0;
        public static final String FIELD_SEVERITY = "Severity";
        public static final short FIELD_ID_TIMESTAMP = 1;
        public static final String FIELD_TIMESTAMP = "Timestamp";
        public static final short FIELD_ID_MESSAGE = 2;
        public static final String FIELD_MESSAGE = "Message";
        public static final short FIELD_ID_TYPENAME = 3;
        public static final String FIELD_TYPENAME = "TypeName";
        public static final short FIELD_ID_IDENTIFICATION = 4;
        public static final String FIELD_IDENTIFICATION = "Identification";
        public static final short FIELD_ID_ASSERTNAME = 5;
        public static final String FIELD_ASSERTNAME = "AssertName";
        public static final short FIELD_ID_FIELDNAME = 6;
        public static final String FIELD_FIELDNAME = "FieldName";
        public static final short FIELD_ID_VIOLATEDCONSTRAINT = 7;
        public static final String FIELD_VIOLATEDCONSTRAINT = "ViolatedConstraint";
        public static final short FIELD_ID_DATAQUALITYCATEGORY = 8;
        public static final String FIELD_DATAQUALITYCATEGORY = "DataQualityCategory";
        public static final short FIELD_ID_SOURCEINFO = 9;
        public static final String FIELD_SOURCEINFO = "SourceInfo";
        public static final short FIELD_ID_EXCEPTIONDETAILS = 10;
        public static final String FIELD_EXCEPTIONDETAILS = "ExceptionDetails";
        private UdtDataType _severityType = UdtDataType.builder().setFullyQualifiedName("schemarise.alfa.runtime.model.asserts.SeverityType").setUdtType(UdtMetaType.enumType).build();
        private ScalarDataType _timestampType = ScalarDataType.builder().setScalarType(ScalarType.datetimeType).build();
        private ScalarDataType _messageType = ScalarDataType.builder().setScalarType(ScalarType.stringType).build();
        private OptionalDataType _typeNameType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        private OptionalDataType _identificationType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        private OptionalDataType _assertNameType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        private OptionalDataType _fieldNameType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        private OptionalDataType _violatedConstraintType = OptionalDataType.builder().setComponentType(UdtDataType.builder().setFullyQualifiedName("schemarise.alfa.runtime.model.asserts.ConstraintType").setUdtType(UdtMetaType.enumType).build()).build();
        private OptionalDataType _dataQualityCategoryType = OptionalDataType.builder().setComponentType(UdtDataType.builder().setFullyQualifiedName("schemarise.alfa.runtime.model.asserts.DataQualityType").setUdtType(UdtMetaType.enumType).build()).build();
        private OptionalDataType _sourceInfoType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        private OptionalDataType _exceptionDetailsType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        Function<DataSupplier, SeverityType> _severityConsumerInner1 = supplierInner1 -> (SeverityType)supplierInner1.objectValue(this._severityType);
        BiConsumer<_ValidationAlertBuilderImpl, DataSupplier> _severityConsumer = (builder, supplier) -> builder.setSeverity(this._severityConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, LocalDateTime> _timestampConsumerInner1 = supplierInner1 -> supplierInner1.datetimeValue(this._timestampType);
        BiConsumer<_ValidationAlertBuilderImpl, DataSupplier> _timestampConsumer = (builder, supplier) -> builder.setTimestamp(this._timestampConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, String> _messageConsumerInner1 = supplierInner1 -> supplierInner1.stringValue(this._messageType);
        BiConsumer<_ValidationAlertBuilderImpl, DataSupplier> _messageConsumer = (builder, supplier) -> builder.setMessage(this._messageConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _typeNameConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _typeNameConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._typeNameType.getComponentType());
            return supplierInner1.optionalValue(this._typeNameType, _typeNameConsumerInner2);
        };
        BiConsumer<_ValidationAlertBuilderImpl, DataSupplier> _typeNameConsumer = (builder, supplier) -> builder.setTypeName(this._typeNameConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _identificationConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _identificationConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._identificationType.getComponentType());
            return supplierInner1.optionalValue(this._identificationType, _identificationConsumerInner2);
        };
        BiConsumer<_ValidationAlertBuilderImpl, DataSupplier> _identificationConsumer = (builder, supplier) -> builder.setIdentification(this._identificationConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _assertNameConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _assertNameConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._assertNameType.getComponentType());
            return supplierInner1.optionalValue(this._assertNameType, _assertNameConsumerInner2);
        };
        BiConsumer<_ValidationAlertBuilderImpl, DataSupplier> _assertNameConsumer = (builder, supplier) -> builder.setAssertName(this._assertNameConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _fieldNameConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _fieldNameConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._fieldNameType.getComponentType());
            return supplierInner1.optionalValue(this._fieldNameType, _fieldNameConsumerInner2);
        };
        BiConsumer<_ValidationAlertBuilderImpl, DataSupplier> _fieldNameConsumer = (builder, supplier) -> builder.setFieldName(this._fieldNameConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<ConstraintType>> _violatedConstraintConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, ConstraintType> _violatedConstraintConsumerInner2 = supplierInner2 -> (ConstraintType)supplierInner2.objectValue((UdtDataType)this._violatedConstraintType.getComponentType());
            return supplierInner1.optionalValue(this._violatedConstraintType, _violatedConstraintConsumerInner2);
        };
        BiConsumer<_ValidationAlertBuilderImpl, DataSupplier> _violatedConstraintConsumer = (builder, supplier) -> builder.setViolatedConstraint(this._violatedConstraintConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<DataQualityType>> _dataQualityCategoryConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, DataQualityType> _dataQualityCategoryConsumerInner2 = supplierInner2 -> (DataQualityType)supplierInner2.objectValue((UdtDataType)this._dataQualityCategoryType.getComponentType());
            return supplierInner1.optionalValue(this._dataQualityCategoryType, _dataQualityCategoryConsumerInner2);
        };
        BiConsumer<_ValidationAlertBuilderImpl, DataSupplier> _dataQualityCategoryConsumer = (builder, supplier) -> builder.setDataQualityCategory(this._dataQualityCategoryConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _sourceInfoConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _sourceInfoConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._sourceInfoType.getComponentType());
            return supplierInner1.optionalValue(this._sourceInfoType, _sourceInfoConsumerInner2);
        };
        BiConsumer<_ValidationAlertBuilderImpl, DataSupplier> _sourceInfoConsumer = (builder, supplier) -> builder.setSourceInfo(this._sourceInfoConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _exceptionDetailsConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _exceptionDetailsConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._exceptionDetailsType.getComponentType());
            return supplierInner1.optionalValue(this._exceptionDetailsType, _exceptionDetailsConsumerInner2);
        };
        BiConsumer<_ValidationAlertBuilderImpl, DataSupplier> _exceptionDetailsConsumer = (builder, supplier) -> builder.setExceptionDetails(this._exceptionDetailsConsumerInner1.apply((DataSupplier)supplier));
        BiConsumer<SeverityType, DataConsumer> _severitySupplierInner1 = (pInner1, consumerInner1) -> consumerInner1.consume(this._severityType, (AlfaObject)pInner1);
        private BiConsumer<ValidationAlert, DataConsumer> _severitySupplier = (p, consumer) -> this._severitySupplierInner1.accept(p.getSeverity(), (DataConsumer)consumer);
        BiConsumer<LocalDateTime, DataConsumer> _timestampSupplierInner1 = (pInner1, consumerInner1) -> consumerInner1.consume(this._timestampType, (LocalDateTime)pInner1);
        private BiConsumer<ValidationAlert, DataConsumer> _timestampSupplier = (p, consumer) -> this._timestampSupplierInner1.accept(p.getTimestamp(), (DataConsumer)consumer);
        BiConsumer<String, DataConsumer> _messageSupplierInner1 = (pInner1, consumerInner1) -> consumerInner1.consume(this._messageType, (String)pInner1);
        private BiConsumer<ValidationAlert, DataConsumer> _messageSupplier = (p, consumer) -> this._messageSupplierInner1.accept(p.getMessage(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _typeNameSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _typeNameSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._typeNameType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._typeNameType, pInner1, _typeNameSupplierInner2);
        };
        private BiConsumer<ValidationAlert, DataConsumer> _typeNameSupplier = (p, consumer) -> this._typeNameSupplierInner1.accept(p.getTypeName(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _identificationSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _identificationSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._identificationType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._identificationType, pInner1, _identificationSupplierInner2);
        };
        private BiConsumer<ValidationAlert, DataConsumer> _identificationSupplier = (p, consumer) -> this._identificationSupplierInner1.accept(p.getIdentification(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _assertNameSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _assertNameSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._assertNameType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._assertNameType, pInner1, _assertNameSupplierInner2);
        };
        private BiConsumer<ValidationAlert, DataConsumer> _assertNameSupplier = (p, consumer) -> this._assertNameSupplierInner1.accept(p.getAssertName(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _fieldNameSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _fieldNameSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._fieldNameType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._fieldNameType, pInner1, _fieldNameSupplierInner2);
        };
        private BiConsumer<ValidationAlert, DataConsumer> _fieldNameSupplier = (p, consumer) -> this._fieldNameSupplierInner1.accept(p.getFieldName(), (DataConsumer)consumer);
        BiConsumer<Optional<ConstraintType>, DataConsumer> _violatedConstraintSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<ConstraintType, DataConsumer> _violatedConstraintSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((UdtDataType)this._violatedConstraintType.getComponentType(), (AlfaObject)pInner2);
            consumerInner1.consume(this._violatedConstraintType, pInner1, _violatedConstraintSupplierInner2);
        };
        private BiConsumer<ValidationAlert, DataConsumer> _violatedConstraintSupplier = (p, consumer) -> this._violatedConstraintSupplierInner1.accept(p.getViolatedConstraint(), (DataConsumer)consumer);
        BiConsumer<Optional<DataQualityType>, DataConsumer> _dataQualityCategorySupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<DataQualityType, DataConsumer> _dataQualityCategorySupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((UdtDataType)this._dataQualityCategoryType.getComponentType(), (AlfaObject)pInner2);
            consumerInner1.consume(this._dataQualityCategoryType, pInner1, _dataQualityCategorySupplierInner2);
        };
        private BiConsumer<ValidationAlert, DataConsumer> _dataQualityCategorySupplier = (p, consumer) -> this._dataQualityCategorySupplierInner1.accept(p.getDataQualityCategory(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _sourceInfoSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _sourceInfoSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._sourceInfoType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._sourceInfoType, pInner1, _sourceInfoSupplierInner2);
        };
        private BiConsumer<ValidationAlert, DataConsumer> _sourceInfoSupplier = (p, consumer) -> this._sourceInfoSupplierInner1.accept(p.getSourceInfo(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _exceptionDetailsSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _exceptionDetailsSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._exceptionDetailsType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._exceptionDetailsType, pInner1, _exceptionDetailsSupplierInner2);
        };
        private BiConsumer<ValidationAlert, DataConsumer> _exceptionDetailsSupplier = (p, consumer) -> this._exceptionDetailsSupplierInner1.accept(p.getExceptionDetails(), (DataConsumer)consumer);
        public FieldMeta severityMeta = new FieldMeta(Optional.of(this._severitySupplier), Optional.of(this._severityConsumer), Optional.of(this._severitySupplierInner1), Optional.of(this._severityConsumerInner1), this._severityType, "Severity", Optional.empty());
        public FieldMeta timestampMeta = new FieldMeta(Optional.of(this._timestampSupplier), Optional.of(this._timestampConsumer), Optional.of(this._timestampSupplierInner1), Optional.of(this._timestampConsumerInner1), this._timestampType, "Timestamp", Optional.empty());
        public FieldMeta messageMeta = new FieldMeta(Optional.of(this._messageSupplier), Optional.of(this._messageConsumer), Optional.of(this._messageSupplierInner1), Optional.of(this._messageConsumerInner1), this._messageType, "Message", Optional.empty());
        public FieldMeta typeNameMeta = new FieldMeta(Optional.of(this._typeNameSupplier), Optional.of(this._typeNameConsumer), Optional.of(this._typeNameSupplierInner1), Optional.of(this._typeNameConsumerInner1), this._typeNameType, "TypeName", Optional.empty());
        public FieldMeta identificationMeta = new FieldMeta(Optional.of(this._identificationSupplier), Optional.of(this._identificationConsumer), Optional.of(this._identificationSupplierInner1), Optional.of(this._identificationConsumerInner1), this._identificationType, "Identification", Optional.empty());
        public FieldMeta assertNameMeta = new FieldMeta(Optional.of(this._assertNameSupplier), Optional.of(this._assertNameConsumer), Optional.of(this._assertNameSupplierInner1), Optional.of(this._assertNameConsumerInner1), this._assertNameType, "AssertName", Optional.empty());
        public FieldMeta fieldNameMeta = new FieldMeta(Optional.of(this._fieldNameSupplier), Optional.of(this._fieldNameConsumer), Optional.of(this._fieldNameSupplierInner1), Optional.of(this._fieldNameConsumerInner1), this._fieldNameType, "FieldName", Optional.empty());
        public FieldMeta violatedConstraintMeta = new FieldMeta(Optional.of(this._violatedConstraintSupplier), Optional.of(this._violatedConstraintConsumer), Optional.of(this._violatedConstraintSupplierInner1), Optional.of(this._violatedConstraintConsumerInner1), this._violatedConstraintType, "ViolatedConstraint", Optional.empty());
        public FieldMeta dataQualityCategoryMeta = new FieldMeta(Optional.of(this._dataQualityCategorySupplier), Optional.of(this._dataQualityCategoryConsumer), Optional.of(this._dataQualityCategorySupplierInner1), Optional.of(this._dataQualityCategoryConsumerInner1), this._dataQualityCategoryType, "DataQualityCategory", Optional.empty());
        public FieldMeta sourceInfoMeta = new FieldMeta(Optional.of(this._sourceInfoSupplier), Optional.of(this._sourceInfoConsumer), Optional.of(this._sourceInfoSupplierInner1), Optional.of(this._sourceInfoConsumerInner1), this._sourceInfoType, "SourceInfo", Optional.empty());
        public FieldMeta exceptionDetailsMeta = new FieldMeta(Optional.of(this._exceptionDetailsSupplier), Optional.of(this._exceptionDetailsConsumer), Optional.of(this._exceptionDetailsSupplierInner1), Optional.of(this._exceptionDetailsConsumerInner1), this._exceptionDetailsType, "ExceptionDetails", Optional.empty());
        protected Map<String, Assert> _asserts_ = Collections.unmodifiableMap(new LinkedHashMap(){});
        protected Map<String, FieldMeta<ValidationAlert>> _fieldsMeta_ = Collections.unmodifiableMap(new LinkedHashMap(){
            {
                this.put(ValidationAlertDescriptor.FIELD_SEVERITY, severityMeta);
                this.put(ValidationAlertDescriptor.FIELD_TIMESTAMP, timestampMeta);
                this.put(ValidationAlertDescriptor.FIELD_MESSAGE, messageMeta);
                this.put(ValidationAlertDescriptor.FIELD_TYPENAME, typeNameMeta);
                this.put(ValidationAlertDescriptor.FIELD_IDENTIFICATION, identificationMeta);
                this.put(ValidationAlertDescriptor.FIELD_ASSERTNAME, assertNameMeta);
                this.put(ValidationAlertDescriptor.FIELD_FIELDNAME, fieldNameMeta);
                this.put(ValidationAlertDescriptor.FIELD_VIOLATEDCONSTRAINT, violatedConstraintMeta);
                this.put(ValidationAlertDescriptor.FIELD_DATAQUALITYCATEGORY, dataQualityCategoryMeta);
                this.put(ValidationAlertDescriptor.FIELD_SOURCEINFO, sourceInfoMeta);
                this.put(ValidationAlertDescriptor.FIELD_EXCEPTIONDETAILS, exceptionDetailsMeta);
            }
        });

        public Optional<BiConsumer<ValidationAlert, DataConsumer>> getFieldSupplier(String fieldName) {
            return this._fieldsMeta_.get(fieldName).getSupplier();
        }

        @Override
        public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
            return this._fieldsMeta_.get(fieldName).getConsumer();
        }

        @Override
        public boolean hasBuilder() {
            return true;
        }

        @Override
        public boolean convertableToBuilder() {
            return true;
        }

        @Override
        public ValidationAlertBuilder builder() {
            return new _ValidationAlertBuilderImpl();
        }

        @Override
        public ValidationAlertBuilder builder(IBuilderConfig cc) {
            return new _ValidationAlertBuilderImpl(cc);
        }

        @Override
        public UdtDataType getUdtDataType() {
            return this._asUdtType_;
        }

        @Override
        public Map<String, Assert> getAsserts() {
            return this._asserts_;
        }

        public Map<String, FieldMeta<ValidationAlert>> getAllFieldsMeta() {
            return this._fieldsMeta_;
        }

        @Override
        public Optional<TypeDescriptor> getEntityKeyModel() {
            return Optional.empty();
        }

        @Override
        public String fieldIdName(int id) {
            switch (id) {
                case 0: {
                    return FIELD_SEVERITY;
                }
                case 1: {
                    return FIELD_TIMESTAMP;
                }
                case 2: {
                    return FIELD_MESSAGE;
                }
                case 3: {
                    return FIELD_TYPENAME;
                }
                case 4: {
                    return FIELD_IDENTIFICATION;
                }
                case 5: {
                    return FIELD_ASSERTNAME;
                }
                case 6: {
                    return FIELD_FIELDNAME;
                }
                case 7: {
                    return FIELD_VIOLATEDCONSTRAINT;
                }
                case 8: {
                    return FIELD_DATAQUALITYCATEGORY;
                }
                case 9: {
                    return FIELD_SOURCEINFO;
                }
                case 10: {
                    return FIELD_EXCEPTIONDETAILS;
                }
            }
            throw new AlfaRuntimeException("Unknown field id " + id);
        }

        @Override
        public boolean hasAbstractTypeFieldsInClosure() {
            return false;
        }

        @Override
        public Set<String> getImmediateDescendants() {
            return Collections.emptySet();
        }

        @Override
        public Optional<Map<String, Expression>> getAnnotations() {
            return Optional.empty();
        }

        @Override
        public Set<ModifierType> getModifiers() {
            return new HashSet<ModifierType>(){};
        }

        @Override
        public String getChecksum() {
            return "38eb9579:8f7002fe";
        }
    }

    public static abstract class _ValidationAlert__Base__ {
        public SeverityType _severity;
        public LocalDateTime _timestamp;
        public String _message;
        public Optional<String> _typeName;
        public Optional<String> _identification;
        public Optional<String> _assertName;
        public Optional<String> _fieldName;
        public Optional<ConstraintType> _violatedConstraint;
        public Optional<DataQualityType> _dataQualityCategory;
        public Optional<String> _sourceInfo;
        public Optional<String> _exceptionDetails;

        public _ValidationAlert__Base__() {
        }

        public _ValidationAlert__Base__(SeverityType _severity, LocalDateTime _timestamp, String _message, Optional<String> _typeName, Optional<String> _identification, Optional<String> _assertName, Optional<String> _fieldName, Optional<ConstraintType> _violatedConstraint, Optional<DataQualityType> _dataQualityCategory, Optional<String> _sourceInfo, Optional<String> _exceptionDetails) {
            this._severity = _severity;
            this._timestamp = _timestamp;
            this._message = _message;
            this._typeName = _typeName;
            this._identification = _identification;
            this._assertName = _assertName;
            this._fieldName = _fieldName;
            this._violatedConstraint = _violatedConstraint;
            this._dataQualityCategory = _dataQualityCategory;
            this._sourceInfo = _sourceInfo;
            this._exceptionDetails = _exceptionDetails;
        }

        public SeverityType getSeverity() {
            return this._severity;
        }

        public LocalDateTime getTimestamp() {
            return this._timestamp;
        }

        public String getMessage() {
            return this._message;
        }

        public Optional<String> getTypeName() {
            return this._typeName;
        }

        public Optional<String> getIdentification() {
            return this._identification;
        }

        public Optional<String> getAssertName() {
            return this._assertName;
        }

        public Optional<String> getFieldName() {
            return this._fieldName;
        }

        public Optional<ConstraintType> getViolatedConstraint() {
            return this._violatedConstraint;
        }

        public Optional<DataQualityType> getDataQualityCategory() {
            return this._dataQualityCategory;
        }

        public Optional<String> getSourceInfo() {
            return this._sourceInfo;
        }

        public Optional<String> getExceptionDetails() {
            return this._exceptionDetails;
        }

        public int hashCode() {
            return Objects.hash(this._severity, this._timestamp, this._message, this._typeName, this._identification, this._assertName, this._fieldName, this._violatedConstraint, this._dataQualityCategory, this._sourceInfo, this._exceptionDetails);
        }

        public String toString() {
            return Utils.udtToString("schemarise.alfa.runtime.model.asserts.ValidationAlert", new String[]{"Severity", "Timestamp", "Message", "TypeName", "Identification", "AssertName", "FieldName", "ViolatedConstraint", "DataQualityCategory", "SourceInfo", "ExceptionDetails"}, new Object[]{this._severity, this._timestamp, this._message, this._typeName, this._identification, this._assertName, this._fieldName, this._violatedConstraint, this._dataQualityCategory, this._sourceInfo, this._exceptionDetails});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof _ValidationAlertConcrete)) {
                return false;
            }
            _ValidationAlertConcrete rhs = (_ValidationAlertConcrete)o;
            return Objects.equals(this._severity, rhs._severity) && Objects.equals(this._timestamp, rhs._timestamp) && Objects.equals(this._message, rhs._message) && Objects.equals(this._typeName, rhs._typeName) && Objects.equals(this._identification, rhs._identification) && Objects.equals(this._assertName, rhs._assertName) && Objects.equals(this._fieldName, rhs._fieldName) && Objects.equals(this._violatedConstraint, rhs._violatedConstraint) && Objects.equals(this._dataQualityCategory, rhs._dataQualityCategory) && Objects.equals(this._sourceInfo, rhs._sourceInfo) && Objects.equals(this._exceptionDetails, rhs._exceptionDetails);
        }

        public void traverse(Visitor v) {
        }

        public Optional<? extends Key> get$key() {
            return Optional.empty();
        }

        public TypeDescriptor descriptor() {
            return ValidationAlertDescriptor.INSTANCE;
        }

        public Object get(String fieldName) {
            switch (fieldName) {
                case "Severity": {
                    return this._severity;
                }
                case "Timestamp": {
                    return this._timestamp;
                }
                case "Message": {
                    return this._message;
                }
                case "TypeName": {
                    return this._typeName;
                }
                case "Identification": {
                    return this._identification;
                }
                case "AssertName": {
                    return this._assertName;
                }
                case "FieldName": {
                    return this._fieldName;
                }
                case "ViolatedConstraint": {
                    return this._violatedConstraint;
                }
                case "DataQualityCategory": {
                    return this._dataQualityCategory;
                }
                case "SourceInfo": {
                    return this._sourceInfo;
                }
                case "ExceptionDetails": {
                    return this._exceptionDetails;
                }
            }
            throw new AlfaRuntimeException("Cannot get unknown field " + fieldName);
        }

        public void validate(IBuilderConfig __builderConfig) {
            this.getSeverity().validate(__builderConfig);
            if (this.getViolatedConstraint().isPresent()) {
                this.getViolatedConstraint().get().validate(__builderConfig);
            }
            if (this.getDataQualityCategory().isPresent()) {
                this.getDataQualityCategory().get().validate(__builderConfig);
            }
        }
    }

    public static final class _ValidationAlertConcrete
    extends _ValidationAlert__Base__
    implements ValidationAlert {
        private _ValidationAlertConcrete() {
        }

        private _ValidationAlertConcrete(SeverityType _severity, LocalDateTime _timestamp, String _message, Optional<String> _typeName, Optional<String> _identification, Optional<String> _assertName, Optional<String> _fieldName, Optional<ConstraintType> _violatedConstraint, Optional<DataQualityType> _dataQualityCategory, Optional<String> _sourceInfo, Optional<String> _exceptionDetails) {
            super(_severity, _timestamp, _message, _typeName, _identification, _assertName, _fieldName, _violatedConstraint, _dataQualityCategory, _sourceInfo, _exceptionDetails);
        }
    }

    public static final class _ValidationAlertBuilderImpl
    extends _ValidationAlert__Base__
    implements ValidationAlertBuilder {
        private final IBuilderConfig __builderConfig;
        private BitSet __missingFields;

        private _ValidationAlertBuilderImpl() {
            this(BuilderConfig.getInstance());
        }

        private _ValidationAlertBuilderImpl(IBuilderConfig cc) {
            this.__builderConfig = cc;
            this.__missingFields = new BitSet(11);
            this.__missingFields.set(0, 11);
            this.setTypeName(Optional.empty());
            this.setIdentification(Optional.empty());
            this.setAssertName(Optional.empty());
            this.setFieldName(Optional.empty());
            this.setViolatedConstraint(Optional.empty());
            this.setDataQualityCategory(Optional.empty());
            this.setSourceInfo(Optional.empty());
            this.setExceptionDetails(Optional.empty());
        }

        protected IBuilderConfig builderConfig() {
            return this.__builderConfig;
        }

        @Override
        public TypeDescriptor descriptor() {
            return ValidationAlertDescriptor.INSTANCE;
        }

        @Override
        public ValidationAlertBuilder setSeverity(SeverityType v) {
            AlfaUtils.notNull("Severity", v);
            this._severity = v;
            this.clearMissingFlag((short)0);
            return this;
        }

        @Override
        public ValidationAlertBuilder setTimestamp(LocalDateTime v) {
            AlfaUtils.notNull("Timestamp", v);
            this._timestamp = v;
            this.clearMissingFlag((short)1);
            return this;
        }

        @Override
        public ValidationAlertBuilder setMessage(String v) {
            AlfaUtils.notNull("Message", v);
            this._message = v;
            this.clearMissingFlag((short)2);
            return this;
        }

        @Override
        public ValidationAlertBuilder setTypeName(Optional<String> v) {
            AlfaUtils.notNull("TypeName", v);
            this._typeName = v;
            this.clearMissingFlag((short)3);
            return this;
        }

        @Override
        public ValidationAlertBuilder setTypeName(String v) {
            this._typeName = Optional.ofNullable(v);
            this.clearMissingFlag((short)3);
            return this;
        }

        @Override
        public ValidationAlertBuilder setIdentification(Optional<String> v) {
            AlfaUtils.notNull("Identification", v);
            this._identification = v;
            this.clearMissingFlag((short)4);
            return this;
        }

        @Override
        public ValidationAlertBuilder setIdentification(String v) {
            this._identification = Optional.ofNullable(v);
            this.clearMissingFlag((short)4);
            return this;
        }

        @Override
        public ValidationAlertBuilder setAssertName(Optional<String> v) {
            AlfaUtils.notNull("AssertName", v);
            this._assertName = v;
            this.clearMissingFlag((short)5);
            return this;
        }

        @Override
        public ValidationAlertBuilder setAssertName(String v) {
            this._assertName = Optional.ofNullable(v);
            this.clearMissingFlag((short)5);
            return this;
        }

        @Override
        public ValidationAlertBuilder setFieldName(Optional<String> v) {
            AlfaUtils.notNull("FieldName", v);
            this._fieldName = v;
            this.clearMissingFlag((short)6);
            return this;
        }

        @Override
        public ValidationAlertBuilder setFieldName(String v) {
            this._fieldName = Optional.ofNullable(v);
            this.clearMissingFlag((short)6);
            return this;
        }

        @Override
        public ValidationAlertBuilder setViolatedConstraint(Optional<ConstraintType> v) {
            AlfaUtils.notNull("ViolatedConstraint", v);
            this._violatedConstraint = v;
            this.clearMissingFlag((short)7);
            return this;
        }

        @Override
        public ValidationAlertBuilder setViolatedConstraint(ConstraintType v) {
            this._violatedConstraint = Optional.ofNullable(v);
            this.clearMissingFlag((short)7);
            return this;
        }

        @Override
        public ValidationAlertBuilder setDataQualityCategory(Optional<DataQualityType> v) {
            AlfaUtils.notNull("DataQualityCategory", v);
            this._dataQualityCategory = v;
            this.clearMissingFlag((short)8);
            return this;
        }

        @Override
        public ValidationAlertBuilder setDataQualityCategory(DataQualityType v) {
            this._dataQualityCategory = Optional.ofNullable(v);
            this.clearMissingFlag((short)8);
            return this;
        }

        @Override
        public ValidationAlertBuilder setSourceInfo(Optional<String> v) {
            AlfaUtils.notNull("SourceInfo", v);
            this._sourceInfo = v;
            this.clearMissingFlag((short)9);
            return this;
        }

        @Override
        public ValidationAlertBuilder setSourceInfo(String v) {
            this._sourceInfo = Optional.ofNullable(v);
            this.clearMissingFlag((short)9);
            return this;
        }

        @Override
        public ValidationAlertBuilder setExceptionDetails(Optional<String> v) {
            AlfaUtils.notNull("ExceptionDetails", v);
            this._exceptionDetails = v;
            this.clearMissingFlag((short)10);
            return this;
        }

        @Override
        public ValidationAlertBuilder setExceptionDetails(String v) {
            this._exceptionDetails = Optional.ofNullable(v);
            this.clearMissingFlag((short)10);
            return this;
        }

        @Override
        public void modify(String fieldName, Object val) {
            switch (fieldName) {
                case "Severity": {
                    this.setSeverity((SeverityType)val);
                    break;
                }
                case "Timestamp": {
                    this.setTimestamp((LocalDateTime)val);
                    break;
                }
                case "Message": {
                    this.setMessage((String)val);
                    break;
                }
                case "TypeName": {
                    this.setTypeName((Optional)val);
                    break;
                }
                case "Identification": {
                    this.setIdentification((Optional)val);
                    break;
                }
                case "AssertName": {
                    this.setAssertName((Optional)val);
                    break;
                }
                case "FieldName": {
                    this.setFieldName((Optional)val);
                    break;
                }
                case "ViolatedConstraint": {
                    this.setViolatedConstraint((Optional)val);
                    break;
                }
                case "DataQualityCategory": {
                    this.setDataQualityCategory((Optional)val);
                    break;
                }
                case "SourceInfo": {
                    this.setSourceInfo((Optional)val);
                    break;
                }
                case "ExceptionDetails": {
                    this.setExceptionDetails((Optional)val);
                    break;
                }
                default: {
                    throw new AlfaRuntimeException(ConstraintType.UnknownField, "Attempt to set unknown field " + fieldName);
                }
            }
        }

        @Override
        public ValidationAlert build() {
            Utils.assertMandatoryFieldsSet(this.builderConfig(), this.__missingFields, 11, ValidationAlertDescriptor.INSTANCE);
            ValidationAlert obj = this.builderConfig().getCustomBuilderFactory().isPresent() ? (ValidationAlert)this.builderConfig().getCustomBuilderFactory().get().create(this.builderConfig(), this.descriptor(), this._severity, this._timestamp, this._message, this._typeName, this._identification, this._assertName, this._fieldName, this._violatedConstraint, this._dataQualityCategory, this._sourceInfo, this._exceptionDetails) : new _ValidationAlertConcrete(this._severity, this._timestamp, this._message, this._typeName, this._identification, this._assertName, this._fieldName, this._violatedConstraint, this._dataQualityCategory, this._sourceInfo, this._exceptionDetails);
            if (this.builderConfig().shouldValidateOnBuild()) {
                obj.validate(this.builderConfig());
            }
            return obj;
        }

        private void clearMissingFlag(short flag) {
            this.__missingFields.clear(flag);
        }

        @Override
        public String toString() {
            return Utils.udtToString("schemarise.alfa.runtime.model.asserts.ValidationAlert", new String[]{"Severity", "Timestamp", "Message", "TypeName", "Identification", "AssertName", "FieldName", "ViolatedConstraint", "DataQualityCategory", "SourceInfo", "ExceptionDetails"}, new Object[]{this._severity, this._timestamp, this._message, this._typeName, this._identification, this._assertName, this._fieldName, this._violatedConstraint, this._dataQualityCategory, this._sourceInfo, this._exceptionDetails});
        }
    }

    public static interface ValidationAlertBuilder
    extends Builder,
    AlfaObject {
        public ValidationAlertBuilder setSeverity(SeverityType var1);

        public SeverityType getSeverity();

        public ValidationAlertBuilder setTimestamp(LocalDateTime var1);

        public LocalDateTime getTimestamp();

        public ValidationAlertBuilder setMessage(String var1);

        public String getMessage();

        public ValidationAlertBuilder setTypeName(Optional<String> var1);

        public ValidationAlertBuilder setTypeName(String var1);

        public Optional<String> getTypeName();

        public ValidationAlertBuilder setIdentification(Optional<String> var1);

        public ValidationAlertBuilder setIdentification(String var1);

        public Optional<String> getIdentification();

        public ValidationAlertBuilder setAssertName(Optional<String> var1);

        public ValidationAlertBuilder setAssertName(String var1);

        public Optional<String> getAssertName();

        public ValidationAlertBuilder setFieldName(Optional<String> var1);

        public ValidationAlertBuilder setFieldName(String var1);

        public Optional<String> getFieldName();

        public ValidationAlertBuilder setViolatedConstraint(Optional<ConstraintType> var1);

        public ValidationAlertBuilder setViolatedConstraint(ConstraintType var1);

        public Optional<ConstraintType> getViolatedConstraint();

        public ValidationAlertBuilder setDataQualityCategory(Optional<DataQualityType> var1);

        public ValidationAlertBuilder setDataQualityCategory(DataQualityType var1);

        public Optional<DataQualityType> getDataQualityCategory();

        public ValidationAlertBuilder setSourceInfo(Optional<String> var1);

        public ValidationAlertBuilder setSourceInfo(String var1);

        public Optional<String> getSourceInfo();

        public ValidationAlertBuilder setExceptionDetails(Optional<String> var1);

        public ValidationAlertBuilder setExceptionDetails(String var1);

        public Optional<String> getExceptionDetails();

        public ValidationAlert build();
    }
}

