/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.utils;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Entity;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.IBuiltinFunctions;
import com.schemarise.alfa.runtime.Key;
import com.schemarise.alfa.runtime.NormalizedPeriod;
import com.schemarise.alfa.runtime.RuntimeContext;
import com.schemarise.alfa.runtime.utils.AlfaUtils;
import com.schemarise.alfa.runtime.utils.ClassUtils;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.Pair;
import schemarise.alfa.runtime.model.Try;
import schemarise.alfa.runtime.model.TryFailure;

public class BuiltinFunctionsImpl
implements IBuiltinFunctions {
    private final RuntimeContext runtimeContext;

    public BuiltinFunctionsImpl(RuntimeContext rc) {
        this.runtimeContext = rc;
    }

    @Override
    public Void debug(Object s) {
        System.out.println(LocalDateTime.now() + " [ALFA-DEBUG] : " + s);
        System.out.flush();
        return null;
    }

    @Override
    public <T> Void add(Set<T> s, T e) {
        s.add(e);
        return null;
    }

    @Override
    public <T> Void add(List<T> s, T e) {
        s.add(e);
        return null;
    }

    @Override
    public <T> LocalDate add(LocalDate d, Duration i) {
        return d.plus(i);
    }

    @Override
    public <T> LocalDateTime add(LocalDateTime d, Duration i) {
        return d.plus(i);
    }

    @Override
    public <T> LocalTime add(LocalTime d, Duration i) {
        return d.plus(i);
    }

    @Override
    public <T> LocalDate add(LocalDate d, NormalizedPeriod i) {
        return d.plus(i);
    }

    @Override
    public <T> LocalDateTime add(LocalDateTime d, NormalizedPeriod i) {
        return d.plus(i);
    }

    @Override
    public <T> LocalTime add(LocalTime d, NormalizedPeriod i) {
        return d.plus(i);
    }

    @Override
    public <T> Boolean contains(List<T> s, T e) {
        return s.contains(e);
    }

    @Override
    public <T> Boolean contains(Set<T> s, T e) {
        return s.contains(e);
    }

    @Override
    public <K, V> Boolean contains(Map<K, V> s, K k) {
        return s.containsKey(k);
    }

    @Override
    public <T> Integer indexOf(List<T> s, T e) {
        return s.indexOf(e);
    }

    @Override
    public Integer indexOf(String fullString, String pattern) {
        return fullString.indexOf(pattern);
    }

    @Override
    @IBuiltinFunctions.CommonFunc
    public Boolean isSet(Supplier<Boolean> t) {
        return t.get();
    }

    @Override
    public <T> Boolean isNone(Optional<T> t) {
        return !t.isPresent();
    }

    @Override
    public <T> Boolean isSome(Optional<T> t) {
        return t.isPresent();
    }

    @Override
    public String left(String s, Integer items) {
        return s.substring(0, items);
    }

    @Override
    public <T> List<T> left(List<T> s, Integer items) {
        return s.subList(0, items);
    }

    @Override
    public <T> Integer len(List<T> s) {
        return s.size();
    }

    @Override
    public <T> Long len(Stream<T> s) {
        return s.count();
    }

    @Override
    public <T> Integer len(Set<T> s) {
        return s.size();
    }

    @Override
    public <K, V> Integer len(Map<K, V> s) {
        return s.size();
    }

    @Override
    public Integer len(String s) {
        return s.length();
    }

    @Override
    public String right(String s, Integer items) {
        return s.substring(s.length() - items);
    }

    @Override
    public <T> List<T> right(List<T> s, Integer items) {
        return s.subList(s.size() - items, s.size());
    }

    @Override
    public <T> Void delete(List<T> s, Integer index) {
        s.remove(index);
        return null;
    }

    @Override
    public <T> Void delete(Set<T> s, T e) {
        s.remove(e);
        return null;
    }

    @Override
    public <K, V> Void delete(Map<K, V> s, K k) {
        s.remove(k);
        return null;
    }

    @Override
    public <T> List<T> filter(List<T> s, Predicate<T> e) {
        return s.stream().filter(e).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> filter(Stream<T> s, Predicate<T> e) {
        return s.filter(e).collect(Collectors.toList());
    }

    @Override
    public <T> Set<T> filter(Set<T> s, Predicate<T> e) {
        return s.stream().filter(e).collect(Collectors.toSet());
    }

    @Override
    public <K, V> Map<K, V> filter(Map<K, V> s, BiPredicate<K, V> e) {
        Predicate<Map.Entry> p = kvEntry -> e.test(kvEntry.getKey(), kvEntry.getValue());
        return s.entrySet().stream().filter(p).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public <T> Boolean isEmpty(List<T> s) {
        return s.isEmpty();
    }

    @Override
    public <T> Boolean isEmpty(Set<T> s) {
        return s.isEmpty();
    }

    @Override
    public <K, T> Boolean isEmpty(Map<K, T> s) {
        return s.isEmpty();
    }

    @Override
    public <T, R> List<R> map(List<T> s, Function<T, R> e) {
        return s.stream().map(e).collect(Collectors.toList());
    }

    @Override
    public <T, R> List<R> map(Stream<T> s, Function<T, R> e) {
        return s.map(e).collect(Collectors.toList());
    }

    @Override
    public <T, R> Set<R> map(Set<T> s, Function<T, R> e) {
        return s.stream().map(e).collect(Collectors.toSet());
    }

    @Override
    public <K, V, KR, VR> Map<KR, VR> map(Map<K, V> s, BiFunction<K, V, KR> keyLambda, BiFunction<K, V, VR> valueLambda) {
        HashMap res = new HashMap();
        s.entrySet().stream().forEach(e -> {
            Object k = keyLambda.apply(e.getKey(), e.getValue());
            Object v = valueLambda.apply(e.getKey(), e.getValue());
            res.put(k, v);
        });
        return res;
    }

    @Override
    public <K, V> Map<K, V> put(Map<K, V> m, K k, V v) {
        HashMap<K, V> res = new HashMap<K, V>();
        res.putAll(m);
        res.put(k, v);
        return res;
    }

    @Override
    public <T> T get(Try<T> e) {
        return e.getResult();
    }

    @Override
    public <T> T getOrElse(Optional<T> e, T elseVal) {
        return e.orElse(elseVal);
    }

    @Override
    public <T> T get(Optional<T> e) {
        return e.get();
    }

    @Override
    public <K, V> Optional<V> get(Map<K, V> m, K k) {
        return Optional.ofNullable(m.get(k));
    }

    @Override
    public <K, V> V getOrElse(Map<K, V> m, K k, V elze) {
        V v = m.get(k);
        if (v == null) {
            return elze;
        }
        return v;
    }

    @Override
    public <T> Optional<T> get(List<T> l, Integer index) {
        return Optional.empty();
    }

    @Override
    public <T, R> R reduce(List<T> m, R acc, BiFunction<R, T, R> f) {
        return this.reduce(m.stream(), acc, f);
    }

    @Override
    public <T, R> R reduce(Stream<T> m, R acc, BiFunction<R, T, R> f) {
        return m.reduce(acc, f, this.combiner(acc));
    }

    private <R> BinaryOperator combiner(R acc) {
        if (acc instanceof Double) {
            return (r, r2) -> r + r2;
        }
        if (acc instanceof Integer) {
            return (r, r2) -> r + r2;
        }
        if (acc instanceof Long) {
            return (r, r2) -> r + r2;
        }
        if (acc instanceof BigDecimal) {
            return (r, r2) -> r + r2;
        }
        if (acc instanceof Float) {
            return (r, r2) -> Float.valueOf(r.floatValue() + r2.floatValue());
        }
        if (acc instanceof String) {
            return (r, r2) -> Float.valueOf(r.floatValue() + r2.floatValue());
        }
        throw new UnsupportedOperationException("Combiner not supported for type " + acc.getClass().getName());
    }

    @Override
    public <T, R> R reduce(Set<T> m, R acc, BiFunction<R, T, R> f) {
        return this.reduce(m.stream(), acc, f);
    }

    @Override
    public <K, V> List<V> values(Map<K, V> m) {
        return new ArrayList<V>(m.values());
    }

    @Override
    public <K, V> Set<K> keys(Map<K, V> s) {
        return s.keySet();
    }

    @Override
    public <T> Optional<T> some(T t) {
        return Optional.of(t);
    }

    @Override
    public LocalDate toDate(String s) {
        return LocalDate.parse(s);
    }

    @Override
    public LocalDate toDate(LocalDateTime s) {
        return s.toLocalDate();
    }

    @Override
    public LocalDate toDate(ZonedDateTime s) {
        return s.toLocalDate();
    }

    @Override
    public LocalDateTime toDatetime(String s) {
        return LocalDateTime.parse(s);
    }

    @Override
    public ZonedDateTime toDatetimetz(String s) {
        return ZonedDateTime.parse(s);
    }

    @Override
    public LocalDateTime toDatetime(LocalDate s) {
        return LocalDateTime.of(s, LocalTime.MIDNIGHT);
    }

    @Override
    public LocalTime toTime(String s) {
        return LocalTime.parse(s);
    }

    @Override
    public LocalTime toTime(LocalDateTime s) {
        return s.toLocalTime();
    }

    @Override
    public BigDecimal toDecimal(String s) {
        return new BigDecimal(s);
    }

    @Override
    public BigDecimal toDecimal(Integer s) {
        return BigDecimal.valueOf(s.intValue());
    }

    @Override
    public BigDecimal toDecimal(Long s) {
        return BigDecimal.valueOf(s);
    }

    @Override
    public BigDecimal toDecimal(Double s) {
        return BigDecimal.valueOf(s);
    }

    @Override
    public Double toDouble(String s) {
        return Double.parseDouble(s);
    }

    @Override
    public Double toDouble(Integer s) {
        return (double)s;
    }

    @Override
    public Double toDouble(Long s) {
        return (double)s;
    }

    @Override
    public Duration toDuration(String s) {
        return Duration.parse(s);
    }

    @Override
    public NormalizedPeriod toPeriod(String s) {
        return NormalizedPeriod.of(s);
    }

    @Override
    public Integer toInt(String s) {
        return Integer.parseInt(s);
    }

    @Override
    public <T> List<T> toList(Set<T> s) {
        return new ArrayList<T>(s);
    }

    @Override
    public <T> Set<T> toSet(Stream<T> s) {
        return s.collect(Collectors.toSet());
    }

    @Override
    public <T> List<T> toList(Stream<T> s) {
        return s.collect(Collectors.toList());
    }

    @Override
    public <T> Set<T> toSet(List<T> s) {
        return new HashSet<T>(s);
    }

    @Override
    public <R, K, V> R reduce(Map<K, V> m, R acc, IBuiltinFunctions.TriFunction<R, K, V, R> f) {
        return null;
    }

    @Override
    public <T, K, V> Map<K, V> toMap(List<T> e, Function<T, K> kfn, Function<T, V> vfn) {
        HashMap m = new HashMap();
        e.stream().forEach(x -> m.put(kfn.apply(x), vfn.apply(x)));
        return m;
    }

    @Override
    public <T, K, V> Map<K, V> toMap(Set<T> e, Function<T, K> kfn, Function<T, V> vfn) {
        HashMap m = new HashMap();
        e.stream().forEach(x -> m.put(kfn.apply(x), vfn.apply(x)));
        return m;
    }

    @Override
    public String toString(String e) {
        return "\"" + e + "\"";
    }

    @Override
    public String toString(UUID e) {
        return e.toString();
    }

    @Override
    public String toString(Integer e) {
        return e.toString();
    }

    @Override
    public String toString(Double e) {
        return e.toString();
    }

    @Override
    public String toString(Long e) {
        return e.toString();
    }

    @Override
    public String toString(BigDecimal e) {
        return e.toString();
    }

    @Override
    public String toString(Boolean e) {
        return e.toString();
    }

    @Override
    public String toString(LocalDate e) {
        return e.toString();
    }

    @Override
    public String toString(LocalDateTime e) {
        return e.toString();
    }

    @Override
    public String toString(LocalTime e) {
        return e.toString();
    }

    @Override
    public String toString(Duration e) {
        return e.toString();
    }

    @Override
    public <T> String toString(T e) {
        StringBuffer sb = new StringBuffer();
        if (e instanceof List) {
            List a = (List)e;
            sb.append("[");
            List f = a.stream().map(x -> this.toString(x)).collect(Collectors.toList());
            if (a.size() > 0 && (a.get(0) instanceof Collection || a.get(0) instanceof Map)) {
                sb.append(String.join((CharSequence)",\n ", f));
            } else {
                sb.append(String.join((CharSequence)",", f));
            }
            sb.append("]");
        } else if (e instanceof Map) {
            Map a = (Map)e;
            sb.append("{");
            List f = a.keySet().stream().map(k -> this.toString(k) + ":" + this.toString(a.get(k))).collect(Collectors.toList());
            sb.append(String.join((CharSequence)",\n ", f));
            sb.append("}");
        } else if (e instanceof Set) {
            Set a = (Set)e;
            sb.append("{");
            List f = a.stream().map(x -> this.toString(x)).collect(Collectors.toList());
            if (a.size() > 0 && (a.iterator().next() instanceof Collection || a.iterator().next() instanceof Map)) {
                sb.append(String.join((CharSequence)",\n ", f));
            } else {
                sb.append(String.join((CharSequence)",", f));
            }
            sb.append("}");
        } else if (e instanceof String) {
            sb.append(this.toString((String)e));
        } else {
            sb.append(e.toString());
        }
        return sb.toString();
    }

    @Override
    public <L, R> Either<L, R> newEitherLeft(L e) {
        return Either.builder().setLeft(e).build();
    }

    @Override
    public <L, R> Either<L, R> newEitherRight(R e) {
        return Either.builder().setRight(e).build();
    }

    @Override
    public <L, R> L left(Either<L, R> e) {
        return e.getLeft();
    }

    @Override
    public <L, R> R right(Either<L, R> e) {
        return e.getRight();
    }

    @Override
    public <L, R> L left(Pair<L, R> e) {
        return e.getLeft();
    }

    @Override
    public <L, R> R right(Pair<L, R> e) {
        return e.getRight();
    }

    @Override
    public <L, R> Boolean isLeft(Either<L, R> e) {
        return e.isLeft();
    }

    @Override
    public <L, R> Boolean isRight(Either<L, R> e) {
        return e.isRight();
    }

    @Override
    public <T> Try<T> newTryValue(T e) {
        return AlfaUtils.createTryValue(e);
    }

    @Override
    public <T> Try<T> newTryFailure(String e) {
        return Try.builder().setFailure(TryFailure.builder().setMessage(e).build()).build();
    }

    @Override
    public <T> Boolean isTryFailure(Try<T> e) {
        return e.isFailure();
    }

    @Override
    public UUID newUUID() {
        return UUID.randomUUID();
    }

    @Override
    public LocalTime now() {
        return LocalTime.now();
    }

    @Override
    public LocalDate today() {
        return LocalDate.now();
    }

    @Override
    public LocalDateTime timestamp() {
        return LocalDateTime.now();
    }

    @Override
    public Integer year(LocalDate e) {
        return e.getYear();
    }

    @Override
    public Integer year(LocalDateTime e) {
        return e.getYear();
    }

    @Override
    public Integer month(LocalDate e) {
        return e.getMonthValue();
    }

    @Override
    public Integer month(LocalDateTime e) {
        return e.getMonthValue();
    }

    @Override
    public Integer day(LocalDate e) {
        return e.getDayOfMonth();
    }

    @Override
    public Integer day(Duration e) {
        return Math.toIntExact(e.get(ChronoUnit.DAYS));
    }

    @Override
    public Integer day(LocalDateTime e) {
        return e.getDayOfMonth();
    }

    @Override
    public Integer weekday(LocalDateTime e) {
        return e.getDayOfWeek().getValue();
    }

    @Override
    public Integer weekday(LocalDate e) {
        return e.getDayOfWeek().ordinal();
    }

    @Override
    public Integer hour(LocalDateTime e) {
        return e.getHour();
    }

    @Override
    public Integer hour(Duration e) {
        return Math.toIntExact(e.get(ChronoUnit.HOURS));
    }

    @Override
    public Integer hour(LocalTime e) {
        return e.getHour();
    }

    @Override
    public Integer minute(LocalDateTime e) {
        return e.getMinute();
    }

    @Override
    public Integer minute(LocalTime e) {
        return e.getMinute();
    }

    @Override
    public Integer minute(Duration e) {
        return Math.toIntExact(e.get(ChronoUnit.MINUTES));
    }

    @Override
    public Integer millisecond(LocalDateTime e) {
        return 0;
    }

    @Override
    public Integer millisecond(LocalTime e) {
        return 0;
    }

    @Override
    public Integer second(LocalDateTime e) {
        return e.getSecond();
    }

    @Override
    public Integer second(Duration e) {
        return Math.toIntExact(e.get(ChronoUnit.SECONDS));
    }

    @Override
    public Integer second(LocalTime e) {
        return e.getSecond();
    }

    @Override
    public Long dateDiff(LocalDate a, LocalDate b) {
        return ChronoUnit.DAYS.between(a, b);
    }

    @Override
    public Integer abs(Integer a) {
        return Math.abs(a);
    }

    @Override
    public Long abs(Long a) {
        return Math.abs(a);
    }

    @Override
    public Double abs(Double a) {
        return Math.abs(a);
    }

    @Override
    public Double ceil(Double a) {
        return Math.ceil(a);
    }

    @Override
    public Double floor(Double a) {
        return Math.floor(a);
    }

    @Override
    public Double log(Double a) {
        return Math.log(a);
    }

    @Override
    public long round(Double a) {
        return Math.round(a);
    }

    @Override
    public Double sqrt(Double a) {
        return Math.sqrt(a);
    }

    @Override
    public Double sqrt(Long a) {
        return Math.sqrt(a.longValue());
    }

    @Override
    public Double sqrt(Integer a) {
        return Math.sqrt(a.intValue());
    }

    @Override
    public Double random() {
        return Math.random();
    }

    @Override
    public Boolean endsWith(String main, String sub) {
        return main.endsWith(sub);
    }

    @Override
    public Boolean matches(String regex, String value) {
        return value.matches(regex);
    }

    @Override
    public Boolean startsWith(String main, String sub) {
        return main.startsWith(sub);
    }

    @Override
    public List<String> split(String main, String delimiter) {
        return Arrays.asList(main.split(delimiter));
    }

    @Override
    public String toLower(String main) {
        return main.toLowerCase();
    }

    @Override
    public String toUpper(String main) {
        return main.toUpperCase();
    }

    @Override
    public String replaceAll(String main, String oldStr, String newStr) {
        return main.replaceAll(oldStr, newStr);
    }

    @Override
    public String substring(String main, Integer start) {
        return main.substring(start);
    }

    @Override
    public String substring(String main, Integer start, Integer end) {
        return main.substring(start, end);
    }

    @Override
    public Integer min(Integer l, Integer r) {
        return Math.min(l, r);
    }

    @Override
    public Integer max(Integer l, Integer r) {
        return l > r ? l : r;
    }

    @Override
    public Long min(Long l, Long r) {
        return l < r ? l : r;
    }

    @Override
    public Long max(Long l, Long r) {
        return l > r ? l : r;
    }

    @Override
    public Double min(Double l, Double r) {
        return l < r ? l : r;
    }

    @Override
    public Double max(Double l, Double r) {
        return l > r ? l : r;
    }

    @Override
    public BigDecimal min(BigDecimal l, BigDecimal r) {
        return l.compareTo(r) < 0 ? l : r;
    }

    @Override
    public BigDecimal max(BigDecimal l, BigDecimal r) {
        return l.compareTo(r) > 0 ? l : r;
    }

    @Override
    public LocalDate min(LocalDate l, LocalDate r) {
        return l.compareTo(r) < 0 ? l : r;
    }

    @Override
    public LocalDate max(LocalDate l, LocalDate r) {
        return l.compareTo(r) > 0 ? l : r;
    }

    @Override
    public LocalDateTime min(LocalDateTime l, LocalDateTime r) {
        return l.compareTo(r) < 0 ? l : r;
    }

    @Override
    public LocalDateTime max(LocalDateTime l, LocalDateTime r) {
        return l.compareTo(r) > 0 ? l : r;
    }

    @Override
    public LocalTime min(LocalTime l, LocalTime r) {
        return l.compareTo(r) < 0 ? l : r;
    }

    @Override
    public LocalTime max(LocalTime l, LocalTime r) {
        return l.compareTo(r) > 0 ? l : r;
    }

    @Override
    public <T extends Comparable<T>> T min(Set<T> al, BiFunction<T, T, Integer> r) {
        return (T)((Comparable)Collections.min(al, (o1, o2) -> (Integer)r.apply(o1, o2)));
    }

    @Override
    public <T extends Comparable<T>> T min(Set<T> l) {
        return (T)((Comparable)Collections.min(l));
    }

    @Override
    public <T extends Comparable<T>> Integer compare(T l, T r) {
        return l.compareTo(r);
    }

    @Override
    public <T extends Comparable<T>> T max(Set<T> al, BiFunction<T, T, Integer> r) {
        return (T)((Comparable)Collections.max(al, (o1, o2) -> (Integer)r.apply(o1, o2)));
    }

    @Override
    public <T extends Comparable<T>> T max(Set<T> l) {
        return (T)((Comparable)Collections.max(l));
    }

    @Override
    public <T extends Comparable<T>> T min(List<T> l, BiFunction<T, T, Integer> r) {
        return (T)((Comparable)Collections.min(l, (o1, o2) -> (Integer)r.apply(o1, o2)));
    }

    @Override
    public <T extends Comparable<T>> T min(List<T> l) {
        return (T)((Comparable)Collections.min(l));
    }

    @Override
    public <T extends Comparable<T>> T max(List<T> l, BiFunction<T, T, Integer> r) {
        ArrayList<T> al = new ArrayList<T>();
        al.addAll(l);
        return (T)((Comparable)Collections.max(al, (o1, o2) -> (Integer)r.apply(o1, o2)));
    }

    @Override
    public <T extends Comparable<T>> T max(List<T> l) {
        return (T)((Comparable)Collections.max(l));
    }

    @Override
    public <T extends Comparable<T>> T min(Stream<T> l, BiFunction<T, T, Integer> r) {
        return this.min(l.collect(Collectors.toList()), r);
    }

    @Override
    public <T extends Comparable<T>> T min(Stream<T> l) {
        return this.min(l.collect(Collectors.toList()));
    }

    @Override
    public <T extends Comparable<T>> T max(Stream<T> l, BiFunction<T, T, Integer> r) {
        return this.max(l.collect(Collectors.toList()), r);
    }

    @Override
    public <T extends Comparable<T>> T max(Stream<T> l) {
        return this.max(l.collect(Collectors.toList()));
    }

    @Override
    public <T> List<T> sort(Set<T> l, BiFunction<T, T, Integer> r) {
        ArrayList<T> al = new ArrayList<T>();
        al.addAll(l);
        Collections.sort(al, (o1, o2) -> (Integer)r.apply(o1, o2));
        return al;
    }

    @Override
    public <T extends Comparable<T>> List<T> sort(Set<T> l) {
        ArrayList<T> al = new ArrayList<T>();
        al.addAll(l);
        Collections.sort(al);
        return al;
    }

    @Override
    public <T> List<T> sort(List<T> l, BiFunction<T, T, Integer> r) {
        ArrayList<T> al = new ArrayList<T>();
        al.addAll(l);
        Collections.sort(al, (o1, o2) -> (Integer)r.apply(o1, o2));
        return al;
    }

    @Override
    public <T extends Comparable<T>> List<T> sort(List<T> l) {
        ArrayList<T> al = new ArrayList<T>();
        al.addAll(l);
        Collections.sort(al);
        return al;
    }

    @Override
    public <T extends Comparable<T>> List<T> sort(Stream<T> l) {
        return null;
    }

    @Override
    public <T> List<T> sort(Stream<T> l, BiFunction<T, T, Integer> r) {
        return null;
    }

    @Override
    public <E> List<E> query(Optional<AlfaObject> currentObject, E entityType, Predicate<E> e, Map<String, Integer> sort, int limit) {
        throw new AlfaRuntimeException("Should be delegated to RuntimeContext query()");
    }

    @Override
    public <E> List<E> query(Optional<AlfaObject> currentObject, E entityType, Predicate<E> e, Map<String, Integer> sort, int limit, String storeName) {
        throw new AlfaRuntimeException("Should be delegated to RuntimeContext query()");
    }

    @Override
    public <E extends Entity, K extends Key> Optional<E> lookup(String entityType, K k) {
        return this.runtimeContext.lookup(entityType, k, Optional.empty());
    }

    @Override
    public <E extends Entity, K extends Key> Optional<E> lookup(String entityType, K k, String storeName) {
        return this.runtimeContext.lookup(entityType, k, storeName);
    }

    @Override
    public <E extends Entity> void save(E entity) {
        this.runtimeContext.save(entity, Optional.empty());
    }

    @Override
    public <E extends Entity> void save(E entity, String storeName) {
        this.runtimeContext.save(entity, storeName);
    }

    @Override
    public <E extends AlfaObject> void publish(String queueName, E alfaObj) {
        this.runtimeContext.publish(queueName, alfaObj);
    }

    @Override
    public <E extends Entity> Boolean exists(String entityType, Predicate<E> e) {
        throw new AlfaRuntimeException("Should be delegated to RuntimeContext exists()");
    }

    @Override
    public <E extends Entity> Boolean exists(String entityType, Predicate<E> e, String storeName) {
        throw new AlfaRuntimeException("Should be delegated to RuntimeContext exists()");
    }

    @Override
    public <E extends Entity, K extends Key> Boolean keyExists(String entityType, K k) {
        return this.runtimeContext.keyExists(entityType, k, Optional.empty());
    }

    @Override
    public <E extends Entity, K extends Key> Boolean keyExists(String entityType, K k, String storeName) {
        return this.runtimeContext.keyExists(entityType, k, storeName);
    }

    @Override
    public <Rv, Tv> Map<Rv, List<Tv>> groupBy(List<Tv> s, Function<Tv, Rv> e) {
        return this._groupBy(s.stream(), e);
    }

    @Override
    public <Rv, Tv> List<Pair<Rv, List<Tv>>> groupBy(Stream<Tv> s, Function<Tv, Rv> e) {
        Map<Rv, List<Tv>> sx = this._groupBy(s, e);
        Stream<Pair> r = sx.entrySet().stream().map(ex -> Pair.builder().setLeft(ex.getKey()).setRight(ex.getValue()).build());
        return r.collect(Collectors.toList());
    }

    private <Rv, Tv> Map<Rv, List<Tv>> _groupBy(Stream<Tv> s, Function<Tv, Rv> e) {
        return s.collect(Collectors.groupingBy(e));
    }

    @Override
    public <Rv, Tv> Map<Rv, List<Tv>> duplicates(List<Tv> s, Function<Tv, Rv> e) {
        return this._duplicates(s.stream(), e);
    }

    private <Rv, Tv> Map<Rv, List<Tv>> _duplicates(Stream<Tv> s, Function<Tv, Rv> e) {
        Map<Rv, List<Tv>> grped = s.collect(Collectors.groupingBy(e));
        Map<Object, List> res = grped.entrySet().stream().filter(ed -> ((List)ed.getValue()).size() > 1).collect(Collectors.toMap(el -> el.getKey(), el -> (List)el.getValue()));
        return res;
    }

    @Override
    public <Rv, Tv> List<Pair<Rv, List<Tv>>> duplicates(Stream<Tv> s, Function<Tv, Rv> e) {
        Map<Rv, List<Tv>> d = this._duplicates(s, e);
        Stream<Pair> r = d.entrySet().stream().map(en -> Pair.builder().setLeft(en.getKey()).setRight(en.getValue()).build());
        return r.collect(Collectors.toList());
    }

    @Override
    public <Rv, Tv> Map<Rv, List<Tv>> duplicates(Set<Tv> s, Function<Tv, Rv> e) {
        return this._duplicates(s.stream(), e);
    }

    @Override
    public <Rv, Tv> Set<Rv> distinct(List<Tv> s, Function<Tv, Rv> e) {
        return s.stream().map(e).collect(Collectors.toSet());
    }

    @Override
    public <Rv, Tv> Set<Rv> distinct(Set<Tv> s, Function<Tv, Rv> e) {
        return s.stream().map(e).collect(Collectors.toSet());
    }

    @Override
    public <Rv, Tv> List<Rv> distinct(Stream<Tv> s, Function<Tv, Rv> e) {
        return new ArrayList(s.map(e).collect(Collectors.toSet()));
    }

    @Override
    public <Rv, Tv> Map<Rv, List<Tv>> groupBy(Set<Tv> s, Function<Tv, Rv> e) {
        return this._groupBy(s.stream(), e);
    }

    @Override
    public <T, K, V> Map<K, V> aggregate(List<T> s, Function<T, K> e, V acc, BiFunction<V, T, V> lambda) {
        return this._aggregate(s.stream(), e, acc, lambda);
    }

    @Override
    public <T, K, V> Map<K, V> aggregate(Set<T> s, Function<T, K> e, V acc, BiFunction<V, T, V> lambda) {
        return this._aggregate(s.stream(), e, acc, lambda);
    }

    @Override
    public <T, K, V> List<Pair<K, V>> aggregate(Stream<T> s, Function<T, K> e, V acc, BiFunction<V, T, V> lambda) {
        Map<K, V> sx = this._aggregate(s, e, acc, lambda);
        Stream<Pair> r = sx.entrySet().stream().map(x -> Pair.builder().setLeft(x.getKey()).setRight(x.getValue()).build());
        return r.collect(Collectors.toList());
    }

    private <T, K, V> Map<K, V> _aggregate(Stream<T> s, Function<T, K> e, V acc, BiFunction<V, T, V> lambda) {
        HashMap r = new HashMap();
        s.forEach(x -> {
            Object k = e.apply(x);
            Object curr = r.get(k);
            if (curr == null) {
                curr = acc;
            }
            Object val = lambda.apply(curr, x);
            r.put(k, val);
        });
        return r;
    }

    @Override
    public <T extends Number> Double stddev(List<T> l) {
        double variance = this.variance(l);
        double stddev = Math.sqrt(variance / (double)l.size());
        return stddev;
    }

    private int medianIndex(int l, int r) {
        int n = r - l + 1;
        n = (n + 1) / 2 - 1;
        return n + l;
    }

    @Override
    public <T extends Comparable> Double quartile(List<T> unsorted, int quart) {
        ArrayList<T> l = new ArrayList<T>(unsorted);
        Collections.sort(l);
        int n = l.size();
        if (n == 0) {
            throw new AlfaRuntimeException("Cannot calculate quartile on empty list");
        }
        if (quart < 0 && quart > 4) {
            throw new AlfaRuntimeException("2nd argument to quartile should be 0, 1, 2, 3 or 4");
        }
        int midIndex = this.medianIndex(0, n);
        Comparable result = null;
        switch (quart) {
            case 0: {
                result = (Comparable)l.get(0);
            }
            case 1: {
                result = (Comparable)l.get(this.medianIndex(0, midIndex));
            }
            case 2: {
                result = (Comparable)l.get(midIndex);
            }
            case 3: {
                result = (Comparable)l.get(midIndex + this.medianIndex(midIndex + 1, n));
            }
            case 4: {
                result = (Comparable)l.get(l.size() - 1);
            }
        }
        return ((Number)((Object)result)).doubleValue();
    }

    @Override
    public <T extends Comparable> Double percentile(List<T> unsorted, int percentile) {
        int len = unsorted.size();
        if (len == 0) {
            throw new AlfaRuntimeException("Cannot calculate percentile on empty list");
        }
        if (percentile < 0 || percentile > 100) {
            throw new AlfaRuntimeException("percentile needs to be between 0 and 100");
        }
        if (len == 1) {
            return ((Number)unsorted.get(0)).doubleValue();
        }
        ArrayList<T> l = new ArrayList<T>(unsorted);
        Collections.sort(l);
        return this.evaluatePercentile(l, percentile);
    }

    private double evaluateSortedercentile(double[] sorted, double p) {
        double n = sorted.length;
        double pos = p * (n + 1.0) / 100.0;
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        if (pos < 1.0) {
            return sorted[0];
        }
        if (pos >= n) {
            return sorted[sorted.length - 1];
        }
        double lower = sorted[intPos - 1];
        double upper = sorted[intPos];
        return lower + dif * (upper - lower);
    }

    public <T> Double evaluatePercentile(List<T> sortedList, int p) {
        double[] sorted = new double[sortedList.size()];
        for (int i = 0; i < sortedList.size(); ++i) {
            sorted[i] = ((Number)sortedList.get(i)).doubleValue();
        }
        return this.evaluateSortedercentile(sorted, p);
    }

    @Override
    public <T extends Number> Double average(List<T> l) {
        int length = l.size();
        double sum = l.stream().map(e -> e.doubleValue()).reduce(0.0, (acc, e) -> acc + e);
        double avg = sum / (double)length;
        return avg;
    }

    @Override
    public <T extends Number> Double variance(List<T> l) {
        double mean = this.average(l);
        double variance = l.stream().map(e -> (Double)e).reduce(0.0, (acc, e) -> Math.pow(e - mean, 2.0));
        return variance;
    }

    @Override
    public <T extends Number> Double stddev(Stream<T> l) {
        return this.stddev(l.collect(Collectors.toList()));
    }

    @Override
    public <T extends Number> Double average(Stream<T> l) {
        return this.average(l.collect(Collectors.toList()));
    }

    @Override
    public <T extends Comparable> Double quartile(Stream<T> l, int quart) {
        return this.quartile(l.collect(Collectors.toList()), quart);
    }

    @Override
    public <T extends Comparable> Double percentile(Stream<T> l, int percent) {
        return this.percentile(l.collect(Collectors.toList()), percent);
    }

    @Override
    public <T extends Number> Double variance(Stream<T> l) {
        return this.variance(l.collect(Collectors.toList()));
    }

    @Override
    public <T, R> List<R> flatten(List<T> data) {
        if (data.size() > 0 && data.get(0) instanceof List) {
            ArrayList ret = new ArrayList();
            data.forEach(e -> {
                List l = (List)e;
                ret.addAll(this.flatten(l));
            });
            return ret;
        }
        return data;
    }

    @Override
    public <T, R> Set<R> flatten(Set<T> data) {
        if (data.size() > 0 && data.iterator().next() instanceof Set) {
            HashSet ret = new HashSet();
            data.forEach(e -> {
                Set l = (Set)e;
                ret.addAll(this.flatten(l));
            });
            return ret;
        }
        return data;
    }

    @Override
    public <T extends Enum> Optional<T> toEnum(String enumDataType, String enumConst) {
        return Optional.ofNullable((Enum)((Object)ClassUtils.getByEnumConst(enumDataType, enumConst, true)));
    }

    @Override
    public <E> Set<String> enumValues(Enum s) {
        return ClassUtils.getMeta(s.getClass().getTypeName()).getModel().getAllFieldsMeta().keySet();
    }

    @Override
    public Set<String> enumValues(String s) {
        return ClassUtils.getMeta(s).getModel().getAllFieldsMeta().keySet();
    }

    @Override
    public Set<String> enumValues(String s, List<String> deflts) {
        if (ClassUtils.isDefined(s)) {
            return ClassUtils.getMeta(s).getModel().getAllFieldsMeta().keySet();
        }
        return new HashSet<String>(deflts);
    }

    @Override
    public String toFormattedTable(List d) {
        return d.toString();
    }
}

