/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.utils;

import com.schemarise.alfa.runtime.Alfa;
import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Entity;
import com.schemarise.alfa.runtime.Service;
import com.schemarise.alfa.runtime.utils.AlfaRandomizer;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.asserts.ConstraintType;
import schemarise.alfa.runtime.model.asserts.ValidationAlert;
import schemarise.alfa.test.Scenario;

public class TestScenarioImpl
implements Scenario {
    public boolean failsOn(String _description, Supplier _testBody, String _expectedErrorFieldPath) {
        throw new UnsupportedOperationException();
    }

    public boolean failsWith(String _description, Supplier _testBody, String _expectedErrorMessage) {
        throw new UnsupportedOperationException();
    }

    public AlfaObject loadObjectFromCsv(String _typeName, String _pathOrUrl) {
        try {
            return Alfa.jsonCodec().importObj(new FileInputStream(_pathOrUrl));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<AlfaObject> loadObjectsFromCsv(String _typeName, String _pathOrUrl, int _headerLineNo, String _colDelimiter) {
        try {
            Stream<Either<AlfaObject, ValidationAlert.ValidationAlertBuilder>> stm = Alfa.jsonCodec().importObjects(new FileInputStream(_pathOrUrl));
            return stm.map(e -> (AlfaObject)e.getLeft()).collect(Collectors.toList());
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void given(String _description, Entity _data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void withServiceResults(String _description, Service _srv, Map<String, List<String>> _results) {
        throw new UnsupportedOperationException();
    }

    public boolean fails(String _description, Supplier _testBody) {
        try {
            _testBody.get();
            System.err.println("Expected to fail:" + _description);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public AlfaObject copyWith(AlfaObject _toCopy, AlfaObject _toOverride) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> listFiles(String _pathOrUrl, String _ext) {
        try {
            return this._listFiles(_pathOrUrl, _ext);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed in listFiles " + _pathOrUrl + ", " + _ext, e);
        }
    }

    @Override
    public void assertTrue(String _description, Supplier<Boolean> _testBody) {
        try {
            Boolean res = _testBody.get();
            if (!res.booleanValue()) {
                throw new AlfaRuntimeException("Expected result to be True:" + _description);
            }
        }
        catch (Exception e) {
            throw new AlfaRuntimeException(ConstraintType.Unknown, "Expected to succeed:" + _description, e);
        }
    }

    public boolean succeeds(String _description, Supplier _testBody) {
        try {
            _testBody.get();
            return true;
        }
        catch (Exception e) {
            System.err.println("Expected to succeed:" + _description);
            return false;
        }
    }

    public AlfaObject random(String _typeName) {
        return this.randomWith(_typeName, Collections.emptyMap());
    }

    public AlfaObject loadObjectFromJSON(String _typeName, String _pathOrUrl) {
        throw new UnsupportedOperationException();
    }

    public AlfaObject randomWith(AlfaObject _builderObject) {
        String tn = _builderObject.descriptor().getUdtDataType().getFullyQualifiedName();
        HashMap<String, Object> values = new HashMap<String, Object>();
        _builderObject.descriptor().getAllFieldsMeta().keySet().stream().forEach(fn -> {
            Object v = _builderObject.get((String)fn);
            if (v != null) {
                values.put((String)fn, v);
            }
        });
        return this.randomWith(tn, values);
    }

    private List<String> _listFiles(String _pathOrUrl, String _ext) throws IOException {
        Path p = Paths.get(_pathOrUrl, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            String cp = Paths.get(".", new String[0]).toFile().getCanonicalPath();
            throw new AlfaRuntimeException("Path does not exist " + _pathOrUrl + ". Current dir " + cp);
        }
        Pattern m = Pattern.compile(_ext);
        List<String> paths = Files.list(p).filter(x -> m.matcher(x.getFileName().toString()).find()).map(x -> x.toString()).collect(Collectors.toList());
        return paths;
    }

    private <T extends AlfaObject> T randomWith(String _typeName, Map<String, Object> values) {
        AlfaRandomizer r = new AlfaRandomizer();
        return r.randomWithValues(_typeName, values);
    }
}

