/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.codec.json.IJsonParserWrapper;
import java.io.IOException;
import java.math.BigDecimal;
import schemarise.alfa.runtime.model.Pair;
import schemarise.alfa.runtime.model.asserts.ConstraintType;

final class JsonParserWrapper
implements IJsonParserWrapper {
    private final JsonParser parser;
    private boolean tokenPushedBack;

    public JsonParserWrapper(JsonParser parser) {
        this.parser = parser;
    }

    @Override
    public int getIntValue() {
        try {
            return this.parser.getIntValue();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public String getText() {
        try {
            return this.parser.getText();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public double getDoubleValue() {
        try {
            return this.parser.getDoubleValue();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public short getShortValue() {
        try {
            return this.parser.getShortValue();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public long getLongValue() {
        try {
            return this.parser.getLongValue();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public byte getByteValue() {
        try {
            return this.parser.getBinaryValue()[0];
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public byte[] getBinaryValue() {
        try {
            return this.parser.getBinaryValue();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public char[] getTextCharacters() {
        try {
            return this.parser.getTextCharacters();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public boolean getBooleanValue() {
        try {
            return this.parser.getBooleanValue();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public void pushBackLastToken() {
        this.tokenPushedBack = true;
    }

    @Override
    public Pair<Integer, Integer> getOffset() {
        JsonLocation loc = this.parser.getCurrentLocation();
        return Pair.builder().setLeft(loc.getLineNr()).setRight(loc.getColumnNr()).build();
    }

    @Override
    public JsonToken nextToken() {
        if (this.tokenPushedBack) {
            this.tokenPushedBack = false;
            return this.parser.currentToken();
        }
        try {
            JsonToken t = this.parser.nextToken();
            return t;
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public JsonToken currentToken() {
        return this.parser.currentToken();
    }

    @Override
    public void skipChildren() {
        try {
            this.parser.skipChildren();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public String getCurrentName() {
        try {
            return this.parser.getCurrentName();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, (Throwable)e);
        }
    }

    @Override
    public JsonLocation getCurrentLocation() {
        return this.parser.getCurrentLocation();
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        try {
            if (this.parser.currentToken() == JsonToken.VALUE_STRING) {
                return new BigDecimal(this.parser.getText());
            }
            return this.parser.getDecimalValue();
        }
        catch (IOException e) {
            throw new AlfaRuntimeException(ConstraintType.DataFormatError, "Failed to read " + this.getCurrentName(), e);
        }
    }

    @Override
    public String getCurrentLocationStr() {
        JsonLocation l = this.parser.getCurrentLocation();
        return "line:" + l.getLineNr() + " column:" + l.getColumnNr() + " offset:" + l.getByteOffset();
    }
}

