/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.Compressed;
import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.Encrypted;
import com.schemarise.alfa.runtime.NoOpDataConsumer;
import com.schemarise.alfa.runtime.NormalizedPeriod;
import com.schemarise.alfa.runtime_int.IntImpl;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import schemarise.alfa.runtime.model.CompressedDataType;
import schemarise.alfa.runtime.model.EncryptedDataType;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.MapDataType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.SetDataType;

final class SizeEstimateGenerator
extends NoOpDataConsumer
implements IntImpl.SizeEstimatorIfc {
    private long sizeAccumulator;
    private Set<String> strings;

    public SizeEstimateGenerator(Set<String> strings, AlfaObject so) {
        this.strings = strings;
        this.consume(so.descriptor().getUdtDataType(), so);
    }

    public SizeEstimateGenerator(AlfaObject so) {
        this.strings = new HashSet<String>();
        this.consume(so.descriptor().getUdtDataType(), so);
        this.strings.clear();
    }

    @Override
    public void consume(ScalarDataType dt, int v) {
        this.sizeAccumulator += 32L;
    }

    @Override
    public void consume(ScalarDataType dt, String v) {
        if (!this.strings.contains(v)) {
            this.strings.add(v);
            this.sizeAccumulator += (long)v.getBytes().length;
        }
    }

    @Override
    public void consume(ScalarDataType dt, double v) {
        this.sizeAccumulator += 32L;
    }

    @Override
    public void consume(ScalarDataType dt, short v) {
        this.sizeAccumulator += 16L;
    }

    @Override
    public void consume(ScalarDataType dt, long v) {
        this.sizeAccumulator += 64L;
    }

    @Override
    public void consume(ScalarDataType dt, byte v) {
        this.sizeAccumulator += 8L;
    }

    @Override
    public void consume(ScalarDataType dt, byte[] v) {
        this.sizeAccumulator += (long)(8 * v.length);
    }

    @Override
    public void consume(ScalarDataType dt, char v) {
        this.sizeAccumulator += 16L;
    }

    @Override
    public void consume(ScalarDataType dt, boolean v) {
        ++this.sizeAccumulator;
    }

    @Override
    public void consume(ScalarDataType dt, BigDecimal v) {
        this.sizeAccumulator += 56L;
    }

    @Override
    public void consume(ScalarDataType dt, LocalDate v) {
        this.sizeAccumulator += 64L;
    }

    @Override
    public void consume(ScalarDataType dt, ZonedDateTime v) {
        this.sizeAccumulator += 96L;
    }

    @Override
    public void consume(ScalarDataType dt, LocalDateTime v) {
        this.sizeAccumulator += 128L;
    }

    @Override
    public void consume(ScalarDataType dt, LocalTime v) {
        this.sizeAccumulator += 64L;
    }

    @Override
    public void consume(ScalarDataType dt, NormalizedPeriod v) {
        this.sizeAccumulator += 64L;
    }

    @Override
    public void consume(ScalarDataType dt, Duration v) {
        this.sizeAccumulator += 64L;
    }

    @Override
    public void consume(ScalarDataType dt, UUID v) {
        this.sizeAccumulator += 128L;
    }

    @Override
    public void consume(ScalarDataType dt, URI v) {
        this.consume(dt, v.getHost());
        this.consume(dt, v.getPath());
        this.consume(dt, v.getFragment());
        this.consume(dt, v.getAuthority());
        this.consume(dt, v.getPort());
        this.consume(dt, v.getQuery());
        this.consume(dt, v.getScheme());
    }

    @Override
    public <T> void consume(EncryptedDataType dt, Encrypted<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        this.sizeAccumulator += (long)v.getEncodedBytes().length;
    }

    @Override
    public <T> void consume(CompressedDataType dt, Compressed v, BiConsumer<T, DataConsumer> elementConsumer) {
        this.sizeAccumulator += (long)v.getEncodedBytes().length;
    }

    @Override
    public <K, V> void consume(MapDataType dt, Map<K, V> v, BiConsumer<K, DataConsumer> keyConsumer, BiConsumer<V, DataConsumer> valueConsumer) {
        this.sizeAccumulator += (long)(32 * v.size());
        super.consume(dt, v, keyConsumer, valueConsumer);
    }

    @Override
    public <T> void consume(SetDataType dt, Set<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        this.sizeAccumulator += (long)(32 * v.size());
        super.consume(dt, v, elementConsumer);
    }

    @Override
    public <T> void consume(ListDataType dt, List<T> v, BiConsumer<T, DataConsumer> elementConsumer) {
        super.consume(dt, v, elementConsumer);
    }

    @Override
    public long getEstimatedSize() {
        return this.sizeAccumulator;
    }
}

