/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int.table;

import com.schemarise.alfa.runtime_int.table.Table;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

class Row {
    private final Map<String, Object> cols;

    Row(Row row) {
        this.cols = new LinkedHashMap<String, Object>(row.cols);
    }

    Row() {
        this.cols = new LinkedHashMap<String, Object>();
    }

    void setValue(String col, Object v) {
        Object old = this.cols.put(col, v);
        if (old != null && !old.equals(v)) {
            throw new IllegalStateException("Col:" + col + " old:" + old + " new:" + v);
        }
    }

    public String toString() {
        return this.stringify(this.cols.keySet());
    }

    public String stringify(Set<String> colNames) {
        StringBuffer sb = new StringBuffer();
        AtomicInteger ai = new AtomicInteger(0);
        int sz = colNames.size();
        colNames.stream().forEach(cn -> {
            Object o = this.cols.get(cn);
            if (o != null) {
                sb.append(Table.fmtCol(o));
            } else {
                sb.append(Table.fmtCol(""));
            }
            if (ai.incrementAndGet() < sz) {
                sb.append("|");
            }
        });
        return sb.toString();
    }

    Object getValue(String colName) {
        return this.cols.get(colName);
    }

    public Collection<Object> getValues() {
        return this.cols.values();
    }
}

