/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.codec;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.DataSupplier;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import schemarise.alfa.runtime.model.IDataType;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.MapDataType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.SetDataType;

public class Converters {
    public static ScalarDataType DataTypeString = ScalarDataType.builder().setScalarType(ScalarType.stringType).build();
    public static SupplierConsumer<String> StringProcessor = new SupplierConsumer<String>(DataTypeString, supplier -> supplier.stringValue(DataTypeString), (value, consumer) -> consumer.consume(DataTypeString, (String)value));
    public static ScalarDataType DataTypeShort = ScalarDataType.builder().setScalarType(ScalarType.shortType).build();
    public static SupplierConsumer<Short> ShortProcessor = new SupplierConsumer<Short>(DataTypeShort, supplier -> supplier.shortValue(DataTypeShort), (value, consumer) -> consumer.consume(DataTypeShort, (short)value));
    public static ScalarDataType DataTypeInt = ScalarDataType.builder().setScalarType(ScalarType.intType).build();
    public static SupplierConsumer<Integer> IntProcessor = new SupplierConsumer<Integer>(DataTypeInt, supplier -> supplier.intValue(DataTypeInt), (value, consumer) -> consumer.consume(DataTypeInt, (int)value));
    public static ScalarDataType DataTypeLong = ScalarDataType.builder().setScalarType(ScalarType.longType).build();
    public static SupplierConsumer<Long> LongProcessor = new SupplierConsumer<Long>(DataTypeLong, supplier -> supplier.longValue(DataTypeLong), (value, consumer) -> consumer.consume(DataTypeLong, (long)value));
    public static ScalarDataType DataTypeBoolean = ScalarDataType.builder().setScalarType(ScalarType.booleanType).build();
    public static SupplierConsumer<Boolean> BooleanProcessor = new SupplierConsumer<Boolean>(DataTypeBoolean, supplier -> supplier.booleanValue(DataTypeBoolean), (value, consumer) -> consumer.consume(DataTypeBoolean, (boolean)value));
    public static ScalarDataType DataTypeDate = ScalarDataType.builder().setScalarType(ScalarType.dateType).build();
    public static SupplierConsumer<LocalDate> DateProcessor = new SupplierConsumer<LocalDate>(DataTypeDate, supplier -> supplier.dateValue(DataTypeDate), (value, consumer) -> consumer.consume(DataTypeDate, (LocalDate)value));
    public static ScalarDataType DataTypeDatetime = ScalarDataType.builder().setScalarType(ScalarType.datetimeType).build();
    public static SupplierConsumer<LocalDateTime> DatetimeProcessor = new SupplierConsumer<LocalDateTime>(DataTypeDatetime, supplier -> supplier.datetimeValue(DataTypeDatetime), (value, consumer) -> consumer.consume(DataTypeDatetime, (LocalDateTime)value));
    public static ScalarDataType DataTypeTime = ScalarDataType.builder().setScalarType(ScalarType.timeType).build();
    public static SupplierConsumer<LocalTime> TimeProcessor = new SupplierConsumer<LocalTime>(DataTypeTime, supplier -> supplier.timeValue(DataTypeTime), (value, consumer) -> consumer.consume(DataTypeTime, (LocalTime)value));
    public static ScalarDataType DataTypeDuration = ScalarDataType.builder().setScalarType(ScalarType.durationType).build();
    public static SupplierConsumer<Duration> DurationProcessor = new SupplierConsumer<Duration>(DataTypeDuration, supplier -> supplier.durationValue(DataTypeDuration), (value, consumer) -> consumer.consume(DataTypeDuration, (Duration)value));
    public static ScalarDataType DataTypeDouble = ScalarDataType.builder().setScalarType(ScalarType.doubleType).build();
    public static SupplierConsumer<Double> DoubleProcessor = new SupplierConsumer<Double>(DataTypeDouble, supplier -> supplier.doubleValue(DataTypeDouble), (value, consumer) -> consumer.consume(DataTypeDouble, (double)value));
    public static ScalarDataType DataTypeBinary = ScalarDataType.builder().setScalarType(ScalarType.binaryType).build();
    public static SupplierConsumer<byte[]> BinaryProcessor = new SupplierConsumer<byte[]>(DataTypeBinary, supplier -> supplier.binaryValue(DataTypeBinary), (value, consumer) -> consumer.consume(DataTypeBinary, (byte[])value));
    public static ScalarDataType DataTypeDecimal = ScalarDataType.builder().setScalarType(ScalarType.decimalType).build();
    public static SupplierConsumer<BigDecimal> DecimalProcessor = new SupplierConsumer<BigDecimal>(DataTypeDecimal, supplier -> supplier.decimalValue(DataTypeDecimal), (value, consumer) -> consumer.consume(DataTypeDecimal, (BigDecimal)value));
    public static ScalarDataType DataTypeUuid = ScalarDataType.builder().setScalarType(ScalarType.uuidType).build();
    public static SupplierConsumer<UUID> UuidProcessor = new SupplierConsumer<UUID>(DataTypeUuid, supplier -> supplier.uuidValue(DataTypeUuid), (value, consumer) -> consumer.consume(DataTypeUuid, (UUID)value));

    public static <T> SupplierConsumer<T> createSupplierConsumer(IDataType dt) {
        if (dt instanceof ScalarDataType) {
            ScalarDataType t = (ScalarDataType)dt;
            switch (t.getScalarType()) {
                case stringType: {
                    return StringProcessor;
                }
                case doubleType: {
                    return DoubleProcessor;
                }
                case intType: {
                    return IntProcessor;
                }
            }
        } else if (dt instanceof ListDataType) {
            ListDataType t = (ListDataType)dt;
            IDataType ct = t.getComponentType();
            SupplierConsumer<T> csc = Converters.createSupplierConsumer(ct);
            return new ListSupplierConsumer<T>(t, csc);
        }
        throw new AlfaRuntimeException("Unhandled creator for type " + dt);
    }

    public static class SupplierConsumer<T> {
        private final IDataType dataType;
        private final Function<DataSupplier, T> supplier;
        private final BiConsumer<T, DataConsumer> consumer;

        SupplierConsumer(IDataType dt, Function<DataSupplier, T> supplier, BiConsumer<T, DataConsumer> consumer) {
            this.dataType = dt;
            this.supplier = supplier;
            this.consumer = consumer;
        }

        SupplierConsumer(Function<DataSupplier, T> supplier, BiConsumer<T, DataConsumer> consumer) {
            this.dataType = null;
            this.supplier = supplier;
            this.consumer = consumer;
        }

        SupplierConsumer(BiConsumer<T, DataConsumer> consumer) {
            this.dataType = null;
            this.supplier = null;
            this.consumer = consumer;
        }

        public SupplierConsumer(Function<DataSupplier, T> supplier) {
            this.dataType = null;
            this.supplier = supplier;
            this.consumer = null;
        }

        public BiConsumer<T, DataConsumer> getConsumer() {
            return this.consumer;
        }

        public Function<DataSupplier, T> getSupplier() {
            return this.supplier;
        }
    }

    public static class MapSupplierConsumer<K, V>
    extends SupplierConsumer<Map<K, V>> {
        public MapSupplierConsumer(MapDataType ldt, SupplierConsumer<K> kSupplierConsumer, SupplierConsumer<V> vSupplierConsumer) {
            super(supplier -> supplier.mapValue(ldt, kSupplierConsumer.getSupplier(), vSupplierConsumer.getSupplier()), (value, consumer) -> consumer.consume(ldt, value, kSupplierConsumer.getConsumer(), vSupplierConsumer.getConsumer()));
        }
    }

    public static class SetSupplierConsumer<T>
    extends SupplierConsumer<Set<T>> {
        public SetSupplierConsumer(SetDataType ldt, SupplierConsumer<T> elementSupplierConsumer) {
            super((DataSupplier supplier) -> supplier.setValue(ldt, elementSupplierConsumer.getSupplier()), (T value, DataConsumer consumer) -> consumer.consume(ldt, value, elementSupplierConsumer.getConsumer()));
        }
    }

    public static class ListSupplierConsumer<T>
    extends SupplierConsumer<List<T>> {
        public ListSupplierConsumer(ListDataType ldt, SupplierConsumer<T> elementSupplierConsumer) {
            super((DataSupplier supplier) -> supplier.listValue(ldt, elementSupplierConsumer.getSupplier()), (T value, DataConsumer consumer) -> consumer.consume(ldt, value, elementSupplierConsumer.getConsumer()));
        }
    }

    public static class UdtSupplierConsumer<T extends AlfaObject>
    extends SupplierConsumer<T> {
        public UdtSupplierConsumer() {
            super(supplier -> supplier.objectValue(Optional.empty()), (value, consumer) -> consumer.consume((AlfaObject)value));
        }
    }
}

