/*
 * Decompiled with CFR 0.152.
 */
package schemarise.alfa.runtime.model.asserts;

import com.schemarise.alfa.runtime.Alfa;
import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.BuilderConfig;
import com.schemarise.alfa.runtime.DataConsumer;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Entity;
import com.schemarise.alfa.runtime.EntityBuilder;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.Visitor;
import com.schemarise.alfa.runtime.utils.AlfaUtils;
import com.schemarise.alfa.runtime.utils.DefaultTypeDescriptor;
import com.schemarise.alfa.runtime.utils.Utils;
import com.schemarise.alfa.runtime.utils.VectorCloner;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.ModifierType;
import schemarise.alfa.runtime.model.OptionalDataType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;
import schemarise.alfa.runtime.model.asserts.ConstraintType;
import schemarise.alfa.runtime.model.asserts.ValidationAlert;
import schemarise.alfa.runtime.model.asserts.ValidationReportKey;

public interface ValidationReport
extends Entity {
    public LocalDateTime getTimestamp();

    public Optional<String> getSourceSystem();

    public Optional<String> getSourceSubsystem();

    public Optional<String> getSourceFeed();

    public Optional<String> getSourceSubfeed();

    public Optional<String> getSourceInfo();

    public Optional<String> getDataFormat();

    public Optional<String> getDataFormatInfo();

    public long getTotalRecords();

    public long getTotalErrors();

    public long getTotalWarnings();

    public List<ValidationAlert> getAlerts();

    public Optional<ValidationReportKey> get$key();

    public static ValidationReportBuilder builder() {
        return new _ValidationReportBuilderImpl();
    }

    public static ValidationReportBuilder builder(IBuilderConfig bc) {
        if (bc.getCustomBuilderFactory().isPresent()) {
            return (ValidationReportBuilder)bc.getCustomBuilderFactory().get().builder(bc, ValidationReportDescriptor.INSTANCE, new Object[0]);
        }
        return new _ValidationReportBuilderImpl(bc);
    }

    default public <B extends Builder> B toBuilder(IBuilderConfig bc) {
        return (B)AlfaUtils.toBuilder(bc, this);
    }

    default public <B extends Builder> B toBuilder() {
        return this.toBuilder(BuilderConfig.getInstance());
    }

    public static final class ValidationReportDescriptor
    extends DefaultTypeDescriptor {
        public static String TYPE_NAME = "schemarise.alfa.runtime.model.asserts.ValidationReport";
        public static ValidationReportDescriptor INSTANCE = new ValidationReportDescriptor();
        private UdtDataType _asUdtType_ = UdtDataType.builder().setUdtType(UdtMetaType.entityType).setFullyQualifiedName(TYPE_NAME).build();
        public static final short FIELD_ID_TIMESTAMP = 0;
        public static final String FIELD_TIMESTAMP = "Timestamp";
        public static final short FIELD_ID_SOURCESYSTEM = 1;
        public static final String FIELD_SOURCESYSTEM = "SourceSystem";
        public static final short FIELD_ID_SOURCESUBSYSTEM = 2;
        public static final String FIELD_SOURCESUBSYSTEM = "SourceSubsystem";
        public static final short FIELD_ID_SOURCEFEED = 3;
        public static final String FIELD_SOURCEFEED = "SourceFeed";
        public static final short FIELD_ID_SOURCESUBFEED = 4;
        public static final String FIELD_SOURCESUBFEED = "SourceSubfeed";
        public static final short FIELD_ID_SOURCEINFO = 5;
        public static final String FIELD_SOURCEINFO = "SourceInfo";
        public static final short FIELD_ID_DATAFORMAT = 6;
        public static final String FIELD_DATAFORMAT = "DataFormat";
        public static final short FIELD_ID_DATAFORMATINFO = 7;
        public static final String FIELD_DATAFORMATINFO = "DataFormatInfo";
        public static final short FIELD_ID_TOTALRECORDS = 8;
        public static final String FIELD_TOTALRECORDS = "TotalRecords";
        public static final short FIELD_ID_TOTALERRORS = 9;
        public static final String FIELD_TOTALERRORS = "TotalErrors";
        public static final short FIELD_ID_TOTALWARNINGS = 10;
        public static final String FIELD_TOTALWARNINGS = "TotalWarnings";
        public static final short FIELD_ID_ALERTS = 11;
        public static final String FIELD_ALERTS = "Alerts";
        private ScalarDataType _timestampType = ScalarDataType.builder().setScalarType(ScalarType.datetimeType).build();
        private OptionalDataType _sourceSystemType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        private OptionalDataType _sourceSubsystemType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        private OptionalDataType _sourceFeedType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        private OptionalDataType _sourceSubfeedType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        private OptionalDataType _sourceInfoType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        private OptionalDataType _dataFormatType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        private OptionalDataType _dataFormatInfoType = OptionalDataType.builder().setComponentType(ScalarDataType.builder().setScalarType(ScalarType.stringType).build()).build();
        private ScalarDataType _totalRecordsType = ScalarDataType.builder().setScalarType(ScalarType.longType).build();
        private ScalarDataType _totalErrorsType = ScalarDataType.builder().setScalarType(ScalarType.longType).build();
        private ScalarDataType _totalWarningsType = ScalarDataType.builder().setScalarType(ScalarType.longType).build();
        private ListDataType _alertsType = ListDataType.builder().setComponentType(UdtDataType.builder().setFullyQualifiedName("schemarise.alfa.runtime.model.asserts.ValidationAlert").setUdtType(UdtMetaType.recordType).build()).build();
        Function<DataSupplier, LocalDateTime> _timestampConsumerInner1 = supplierInner1 -> supplierInner1.datetimeValue(this._timestampType);
        BiConsumer<_ValidationReportBuilderImpl, DataSupplier> _timestampConsumer = (builder, supplier) -> builder.setTimestamp(this._timestampConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _sourceSystemConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _sourceSystemConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._sourceSystemType.getComponentType());
            return supplierInner1.optionalValue(this._sourceSystemType, _sourceSystemConsumerInner2);
        };
        BiConsumer<_ValidationReportBuilderImpl, DataSupplier> _sourceSystemConsumer = (builder, supplier) -> builder.setSourceSystem(this._sourceSystemConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _sourceSubsystemConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _sourceSubsystemConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._sourceSubsystemType.getComponentType());
            return supplierInner1.optionalValue(this._sourceSubsystemType, _sourceSubsystemConsumerInner2);
        };
        BiConsumer<_ValidationReportBuilderImpl, DataSupplier> _sourceSubsystemConsumer = (builder, supplier) -> builder.setSourceSubsystem(this._sourceSubsystemConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _sourceFeedConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _sourceFeedConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._sourceFeedType.getComponentType());
            return supplierInner1.optionalValue(this._sourceFeedType, _sourceFeedConsumerInner2);
        };
        BiConsumer<_ValidationReportBuilderImpl, DataSupplier> _sourceFeedConsumer = (builder, supplier) -> builder.setSourceFeed(this._sourceFeedConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _sourceSubfeedConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _sourceSubfeedConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._sourceSubfeedType.getComponentType());
            return supplierInner1.optionalValue(this._sourceSubfeedType, _sourceSubfeedConsumerInner2);
        };
        BiConsumer<_ValidationReportBuilderImpl, DataSupplier> _sourceSubfeedConsumer = (builder, supplier) -> builder.setSourceSubfeed(this._sourceSubfeedConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _sourceInfoConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _sourceInfoConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._sourceInfoType.getComponentType());
            return supplierInner1.optionalValue(this._sourceInfoType, _sourceInfoConsumerInner2);
        };
        BiConsumer<_ValidationReportBuilderImpl, DataSupplier> _sourceInfoConsumer = (builder, supplier) -> builder.setSourceInfo(this._sourceInfoConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _dataFormatConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _dataFormatConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._dataFormatType.getComponentType());
            return supplierInner1.optionalValue(this._dataFormatType, _dataFormatConsumerInner2);
        };
        BiConsumer<_ValidationReportBuilderImpl, DataSupplier> _dataFormatConsumer = (builder, supplier) -> builder.setDataFormat(this._dataFormatConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Optional<String>> _dataFormatInfoConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, String> _dataFormatInfoConsumerInner2 = supplierInner2 -> supplierInner2.stringValue((ScalarDataType)this._dataFormatInfoType.getComponentType());
            return supplierInner1.optionalValue(this._dataFormatInfoType, _dataFormatInfoConsumerInner2);
        };
        BiConsumer<_ValidationReportBuilderImpl, DataSupplier> _dataFormatInfoConsumer = (builder, supplier) -> builder.setDataFormatInfo(this._dataFormatInfoConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Long> _totalRecordsConsumerInner1 = supplierInner1 -> supplierInner1.longValue(this._totalRecordsType);
        BiConsumer<_ValidationReportBuilderImpl, DataSupplier> _totalRecordsConsumer = (builder, supplier) -> builder.setTotalRecords(this._totalRecordsConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Long> _totalErrorsConsumerInner1 = supplierInner1 -> supplierInner1.longValue(this._totalErrorsType);
        BiConsumer<_ValidationReportBuilderImpl, DataSupplier> _totalErrorsConsumer = (builder, supplier) -> builder.setTotalErrors(this._totalErrorsConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, Long> _totalWarningsConsumerInner1 = supplierInner1 -> supplierInner1.longValue(this._totalWarningsType);
        BiConsumer<_ValidationReportBuilderImpl, DataSupplier> _totalWarningsConsumer = (builder, supplier) -> builder.setTotalWarnings(this._totalWarningsConsumerInner1.apply((DataSupplier)supplier));
        Function<DataSupplier, List<ValidationAlert>> _alertsConsumerInner1 = supplierInner1 -> {
            Function<DataSupplier, ValidationAlert> _alertsConsumerInner2 = supplierInner2 -> (ValidationAlert)supplierInner2.objectValue((UdtDataType)this._alertsType.getComponentType());
            return supplierInner1.listValue(this._alertsType, _alertsConsumerInner2);
        };
        BiConsumer<_ValidationReportBuilderImpl, DataSupplier> _alertsConsumer = (builder, supplier) -> builder.addAllAlerts(this._alertsConsumerInner1.apply((DataSupplier)supplier));
        BiConsumer<LocalDateTime, DataConsumer> _timestampSupplierInner1 = (pInner1, consumerInner1) -> consumerInner1.consume(this._timestampType, (LocalDateTime)pInner1);
        private BiConsumer<ValidationReport, DataConsumer> _timestampSupplier = (p, consumer) -> this._timestampSupplierInner1.accept(p.getTimestamp(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _sourceSystemSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _sourceSystemSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._sourceSystemType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._sourceSystemType, pInner1, _sourceSystemSupplierInner2);
        };
        private BiConsumer<ValidationReport, DataConsumer> _sourceSystemSupplier = (p, consumer) -> this._sourceSystemSupplierInner1.accept(p.getSourceSystem(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _sourceSubsystemSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _sourceSubsystemSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._sourceSubsystemType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._sourceSubsystemType, pInner1, _sourceSubsystemSupplierInner2);
        };
        private BiConsumer<ValidationReport, DataConsumer> _sourceSubsystemSupplier = (p, consumer) -> this._sourceSubsystemSupplierInner1.accept(p.getSourceSubsystem(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _sourceFeedSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _sourceFeedSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._sourceFeedType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._sourceFeedType, pInner1, _sourceFeedSupplierInner2);
        };
        private BiConsumer<ValidationReport, DataConsumer> _sourceFeedSupplier = (p, consumer) -> this._sourceFeedSupplierInner1.accept(p.getSourceFeed(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _sourceSubfeedSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _sourceSubfeedSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._sourceSubfeedType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._sourceSubfeedType, pInner1, _sourceSubfeedSupplierInner2);
        };
        private BiConsumer<ValidationReport, DataConsumer> _sourceSubfeedSupplier = (p, consumer) -> this._sourceSubfeedSupplierInner1.accept(p.getSourceSubfeed(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _sourceInfoSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _sourceInfoSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._sourceInfoType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._sourceInfoType, pInner1, _sourceInfoSupplierInner2);
        };
        private BiConsumer<ValidationReport, DataConsumer> _sourceInfoSupplier = (p, consumer) -> this._sourceInfoSupplierInner1.accept(p.getSourceInfo(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _dataFormatSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _dataFormatSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._dataFormatType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._dataFormatType, pInner1, _dataFormatSupplierInner2);
        };
        private BiConsumer<ValidationReport, DataConsumer> _dataFormatSupplier = (p, consumer) -> this._dataFormatSupplierInner1.accept(p.getDataFormat(), (DataConsumer)consumer);
        BiConsumer<Optional<String>, DataConsumer> _dataFormatInfoSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<String, DataConsumer> _dataFormatInfoSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((ScalarDataType)this._dataFormatInfoType.getComponentType(), (String)pInner2);
            consumerInner1.consume(this._dataFormatInfoType, pInner1, _dataFormatInfoSupplierInner2);
        };
        private BiConsumer<ValidationReport, DataConsumer> _dataFormatInfoSupplier = (p, consumer) -> this._dataFormatInfoSupplierInner1.accept(p.getDataFormatInfo(), (DataConsumer)consumer);
        BiConsumer<Long, DataConsumer> _totalRecordsSupplierInner1 = (pInner1, consumerInner1) -> consumerInner1.consume(this._totalRecordsType, (long)pInner1);
        private BiConsumer<ValidationReport, DataConsumer> _totalRecordsSupplier = (p, consumer) -> this._totalRecordsSupplierInner1.accept(p.getTotalRecords(), (DataConsumer)consumer);
        BiConsumer<Long, DataConsumer> _totalErrorsSupplierInner1 = (pInner1, consumerInner1) -> consumerInner1.consume(this._totalErrorsType, (long)pInner1);
        private BiConsumer<ValidationReport, DataConsumer> _totalErrorsSupplier = (p, consumer) -> this._totalErrorsSupplierInner1.accept(p.getTotalErrors(), (DataConsumer)consumer);
        BiConsumer<Long, DataConsumer> _totalWarningsSupplierInner1 = (pInner1, consumerInner1) -> consumerInner1.consume(this._totalWarningsType, (long)pInner1);
        private BiConsumer<ValidationReport, DataConsumer> _totalWarningsSupplier = (p, consumer) -> this._totalWarningsSupplierInner1.accept(p.getTotalWarnings(), (DataConsumer)consumer);
        BiConsumer<List<ValidationAlert>, DataConsumer> _alertsSupplierInner1 = (pInner1, consumerInner1) -> {
            BiConsumer<ValidationAlert, DataConsumer> _alertsSupplierInner2 = (pInner2, consumerInner2) -> consumerInner2.consume((UdtDataType)this._alertsType.getComponentType(), (AlfaObject)pInner2);
            consumerInner1.consume(this._alertsType, pInner1, _alertsSupplierInner2);
        };
        private BiConsumer<ValidationReport, DataConsumer> _alertsSupplier = (p, consumer) -> this._alertsSupplierInner1.accept(p.getAlerts(), (DataConsumer)consumer);
        public FieldMeta timestampMeta = new FieldMeta(Optional.of(this._timestampSupplier), Optional.of(this._timestampConsumer), Optional.of(this._timestampSupplierInner1), Optional.of(this._timestampConsumerInner1), this._timestampType, "Timestamp", Optional.empty());
        public FieldMeta sourceSystemMeta = new FieldMeta(Optional.of(this._sourceSystemSupplier), Optional.of(this._sourceSystemConsumer), Optional.of(this._sourceSystemSupplierInner1), Optional.of(this._sourceSystemConsumerInner1), this._sourceSystemType, "SourceSystem", Optional.empty());
        public FieldMeta sourceSubsystemMeta = new FieldMeta(Optional.of(this._sourceSubsystemSupplier), Optional.of(this._sourceSubsystemConsumer), Optional.of(this._sourceSubsystemSupplierInner1), Optional.of(this._sourceSubsystemConsumerInner1), this._sourceSubsystemType, "SourceSubsystem", Optional.empty());
        public FieldMeta sourceFeedMeta = new FieldMeta(Optional.of(this._sourceFeedSupplier), Optional.of(this._sourceFeedConsumer), Optional.of(this._sourceFeedSupplierInner1), Optional.of(this._sourceFeedConsumerInner1), this._sourceFeedType, "SourceFeed", Optional.empty());
        public FieldMeta sourceSubfeedMeta = new FieldMeta(Optional.of(this._sourceSubfeedSupplier), Optional.of(this._sourceSubfeedConsumer), Optional.of(this._sourceSubfeedSupplierInner1), Optional.of(this._sourceSubfeedConsumerInner1), this._sourceSubfeedType, "SourceSubfeed", Optional.empty());
        public FieldMeta sourceInfoMeta = new FieldMeta(Optional.of(this._sourceInfoSupplier), Optional.of(this._sourceInfoConsumer), Optional.of(this._sourceInfoSupplierInner1), Optional.of(this._sourceInfoConsumerInner1), this._sourceInfoType, "SourceInfo", Optional.empty());
        public FieldMeta dataFormatMeta = new FieldMeta(Optional.of(this._dataFormatSupplier), Optional.of(this._dataFormatConsumer), Optional.of(this._dataFormatSupplierInner1), Optional.of(this._dataFormatConsumerInner1), this._dataFormatType, "DataFormat", Optional.empty());
        public FieldMeta dataFormatInfoMeta = new FieldMeta(Optional.of(this._dataFormatInfoSupplier), Optional.of(this._dataFormatInfoConsumer), Optional.of(this._dataFormatInfoSupplierInner1), Optional.of(this._dataFormatInfoConsumerInner1), this._dataFormatInfoType, "DataFormatInfo", Optional.empty());
        public FieldMeta totalRecordsMeta = new FieldMeta(Optional.of(this._totalRecordsSupplier), Optional.of(this._totalRecordsConsumer), Optional.of(this._totalRecordsSupplierInner1), Optional.of(this._totalRecordsConsumerInner1), this._totalRecordsType, "TotalRecords", Optional.empty());
        public FieldMeta totalErrorsMeta = new FieldMeta(Optional.of(this._totalErrorsSupplier), Optional.of(this._totalErrorsConsumer), Optional.of(this._totalErrorsSupplierInner1), Optional.of(this._totalErrorsConsumerInner1), this._totalErrorsType, "TotalErrors", Optional.empty());
        public FieldMeta totalWarningsMeta = new FieldMeta(Optional.of(this._totalWarningsSupplier), Optional.of(this._totalWarningsConsumer), Optional.of(this._totalWarningsSupplierInner1), Optional.of(this._totalWarningsConsumerInner1), this._totalWarningsType, "TotalWarnings", Optional.empty());
        public FieldMeta alertsMeta = new FieldMeta(Optional.of(this._alertsSupplier), Optional.of(this._alertsConsumer), Optional.of(this._alertsSupplierInner1), Optional.of(this._alertsConsumerInner1), this._alertsType, "Alerts", Optional.empty());
        protected Map<String, Assert> _asserts_ = Collections.unmodifiableMap(new LinkedHashMap(){});
        protected Map<String, FieldMeta<ValidationReport>> _fieldsMeta_ = Collections.unmodifiableMap(new LinkedHashMap(){
            {
                this.put(ValidationReportDescriptor.FIELD_TIMESTAMP, timestampMeta);
                this.put(ValidationReportDescriptor.FIELD_SOURCESYSTEM, sourceSystemMeta);
                this.put(ValidationReportDescriptor.FIELD_SOURCESUBSYSTEM, sourceSubsystemMeta);
                this.put(ValidationReportDescriptor.FIELD_SOURCEFEED, sourceFeedMeta);
                this.put(ValidationReportDescriptor.FIELD_SOURCESUBFEED, sourceSubfeedMeta);
                this.put(ValidationReportDescriptor.FIELD_SOURCEINFO, sourceInfoMeta);
                this.put(ValidationReportDescriptor.FIELD_DATAFORMAT, dataFormatMeta);
                this.put(ValidationReportDescriptor.FIELD_DATAFORMATINFO, dataFormatInfoMeta);
                this.put(ValidationReportDescriptor.FIELD_TOTALRECORDS, totalRecordsMeta);
                this.put(ValidationReportDescriptor.FIELD_TOTALERRORS, totalErrorsMeta);
                this.put(ValidationReportDescriptor.FIELD_TOTALWARNINGS, totalWarningsMeta);
                this.put(ValidationReportDescriptor.FIELD_ALERTS, alertsMeta);
            }
        });

        public Optional<BiConsumer<ValidationReport, DataConsumer>> getFieldSupplier(String fieldName) {
            return this._fieldsMeta_.get(fieldName).getSupplier();
        }

        @Override
        public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
            return this._fieldsMeta_.get(fieldName).getConsumer();
        }

        @Override
        public boolean hasBuilder() {
            return true;
        }

        @Override
        public boolean convertableToBuilder() {
            return true;
        }

        @Override
        public ValidationReportBuilder builder() {
            return new _ValidationReportBuilderImpl();
        }

        @Override
        public ValidationReportBuilder builder(IBuilderConfig cc) {
            return new _ValidationReportBuilderImpl(cc);
        }

        @Override
        public UdtDataType getUdtDataType() {
            return this._asUdtType_;
        }

        @Override
        public Map<String, Assert> getAsserts() {
            return this._asserts_;
        }

        public Map<String, FieldMeta<ValidationReport>> getAllFieldsMeta() {
            return this._fieldsMeta_;
        }

        @Override
        public Optional<TypeDescriptor> getEntityKeyModel() {
            return Optional.of(ValidationReportKey.ValidationReportKeyDescriptor.INSTANCE);
        }

        @Override
        public String fieldIdName(int id) {
            switch (id) {
                case 0: {
                    return FIELD_TIMESTAMP;
                }
                case 1: {
                    return FIELD_SOURCESYSTEM;
                }
                case 2: {
                    return FIELD_SOURCESUBSYSTEM;
                }
                case 3: {
                    return FIELD_SOURCEFEED;
                }
                case 4: {
                    return FIELD_SOURCESUBFEED;
                }
                case 5: {
                    return FIELD_SOURCEINFO;
                }
                case 6: {
                    return FIELD_DATAFORMAT;
                }
                case 7: {
                    return FIELD_DATAFORMATINFO;
                }
                case 8: {
                    return FIELD_TOTALRECORDS;
                }
                case 9: {
                    return FIELD_TOTALERRORS;
                }
                case 10: {
                    return FIELD_TOTALWARNINGS;
                }
                case 11: {
                    return FIELD_ALERTS;
                }
            }
            throw new AlfaRuntimeException("Unknown field id " + id);
        }

        @Override
        public boolean hasAbstractTypeFieldsInClosure() {
            return false;
        }

        @Override
        public Set<String> getImmediateDescendants() {
            return Collections.emptySet();
        }

        @Override
        public Optional<Map<String, Expression>> getAnnotations() {
            return Optional.of(new HashMap(){
                {
                    this.put("alfa.db.Table", Alfa.jsonCodec().uncheckedFromJson("{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"ObjectExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__ObjectExpr\",\"udtName\":\"alfa.db.Table\",\"fieldValues\":{\"StorageMode\":{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"QualifiedIdentifierExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__QualifiedIdentifierExpr\",\"ExprType\":{\"$type\":\"schemarise.alfa.runtime.model.UdtDataType\",\"FullyQualifiedName\":\"alfa.db.StorageMode\",\"UdtType\":\"enumType\"},\"path\":[\"alfa\",\"db\",\"StorageMode\",\"JSONB\"],\"IdentifierType\":\"EnumReference\"}},\"Queryable\":{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"SetExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__SetExpr\",\"ExprType\":{\"$type\":\"schemarise.alfa.runtime.model.SetDataType\",\"ComponentType\":{\"$type\":\"schemarise.alfa.runtime.model.MetaDataType\",\"MetaType\":\"FieldName\"}},\"expr\":[{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"IdentifierExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__IdentifierExpr\",\"ExprType\":{\"$type\":\"schemarise.alfa.runtime.model.MetaDataType\",\"MetaType\":\"FieldName\"},\"fieldName\":\"TotalErrors\"}},{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"IdentifierExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__IdentifierExpr\",\"ExprType\":{\"$type\":\"schemarise.alfa.runtime.model.MetaDataType\",\"MetaType\":\"FieldName\"},\"fieldName\":\"SourceFeed\"}},{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"IdentifierExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__IdentifierExpr\",\"ExprType\":{\"$type\":\"schemarise.alfa.runtime.model.MetaDataType\",\"MetaType\":\"FieldName\"},\"fieldName\":\"SourceInfo\"}},{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"IdentifierExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__IdentifierExpr\",\"ExprType\":{\"$type\":\"schemarise.alfa.runtime.model.MetaDataType\",\"MetaType\":\"FieldName\"},\"fieldName\":\"SourceSubsystem\"}},{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"IdentifierExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__IdentifierExpr\",\"ExprType\":{\"$type\":\"schemarise.alfa.runtime.model.MetaDataType\",\"MetaType\":\"FieldName\"},\"fieldName\":\"DataFormat\"}},{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"IdentifierExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__IdentifierExpr\",\"ExprType\":{\"$type\":\"schemarise.alfa.runtime.model.MetaDataType\",\"MetaType\":\"FieldName\"},\"fieldName\":\"Timestamp\"}},{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"IdentifierExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__IdentifierExpr\",\"ExprType\":{\"$type\":\"schemarise.alfa.runtime.model.MetaDataType\",\"MetaType\":\"FieldName\"},\"fieldName\":\"SourceSystem\"}},{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"IdentifierExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__IdentifierExpr\",\"ExprType\":{\"$type\":\"schemarise.alfa.runtime.model.MetaDataType\",\"MetaType\":\"FieldName\"},\"fieldName\":\"SourceSubfeed\"}},{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"IdentifierExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__IdentifierExpr\",\"ExprType\":{\"$type\":\"schemarise.alfa.runtime.model.MetaDataType\",\"MetaType\":\"FieldName\"},\"fieldName\":\"TotalWarnings\"}},{\"$type\":\"schemarise.alfa.runtime.model.Expression\",\"IdentifierExpr\":{\"$type\":\"schemarise.alfa.runtime.model.Expression__IdentifierExpr\",\"ExprType\":{\"$type\":\"schemarise.alfa.runtime.model.MetaDataType\",\"MetaType\":\"FieldName\"},\"fieldName\":\"DataFormatInfo\"}}]}}}}}"));
                }
            });
        }

        @Override
        public Set<ModifierType> getModifiers() {
            return new HashSet<ModifierType>(){};
        }

        @Override
        public String getChecksum() {
            return "df7b291a:579a5d0e";
        }
    }

    public static abstract class _ValidationReport__Base__ {
        public LocalDateTime _timestamp;
        public Optional<String> _sourceSystem;
        public Optional<String> _sourceSubsystem;
        public Optional<String> _sourceFeed;
        public Optional<String> _sourceSubfeed;
        public Optional<String> _sourceInfo;
        public Optional<String> _dataFormat;
        public Optional<String> _dataFormatInfo;
        public long _totalRecords;
        public long _totalErrors;
        public long _totalWarnings;
        public List<ValidationAlert> _alerts;
        public ValidationReportKey _key;

        public _ValidationReport__Base__() {
        }

        public _ValidationReport__Base__(ValidationReportKey _key, LocalDateTime _timestamp, Optional<String> _sourceSystem, Optional<String> _sourceSubsystem, Optional<String> _sourceFeed, Optional<String> _sourceSubfeed, Optional<String> _sourceInfo, Optional<String> _dataFormat, Optional<String> _dataFormatInfo, long _totalRecords, long _totalErrors, long _totalWarnings, List<ValidationAlert> _alerts) {
            this._timestamp = _timestamp;
            this._sourceSystem = _sourceSystem;
            this._sourceSubsystem = _sourceSubsystem;
            this._sourceFeed = _sourceFeed;
            this._sourceSubfeed = _sourceSubfeed;
            this._sourceInfo = _sourceInfo;
            this._dataFormat = _dataFormat;
            this._dataFormatInfo = _dataFormatInfo;
            this._totalRecords = _totalRecords;
            this._totalErrors = _totalErrors;
            this._totalWarnings = _totalWarnings;
            this._alerts = _alerts;
            this._key = _key;
        }

        public LocalDateTime getTimestamp() {
            return this._timestamp;
        }

        public Optional<String> getSourceSystem() {
            return this._sourceSystem;
        }

        public Optional<String> getSourceSubsystem() {
            return this._sourceSubsystem;
        }

        public Optional<String> getSourceFeed() {
            return this._sourceFeed;
        }

        public Optional<String> getSourceSubfeed() {
            return this._sourceSubfeed;
        }

        public Optional<String> getSourceInfo() {
            return this._sourceInfo;
        }

        public Optional<String> getDataFormat() {
            return this._dataFormat;
        }

        public Optional<String> getDataFormatInfo() {
            return this._dataFormatInfo;
        }

        public long getTotalRecords() {
            return this._totalRecords;
        }

        public long getTotalErrors() {
            return this._totalErrors;
        }

        public long getTotalWarnings() {
            return this._totalWarnings;
        }

        public List<ValidationAlert> getAlerts() {
            return this._alerts;
        }

        public int hashCode() {
            return Objects.hash(this._key, this._timestamp, this._sourceSystem, this._sourceSubsystem, this._sourceFeed, this._sourceSubfeed, this._sourceInfo, this._dataFormat, this._dataFormatInfo, this._totalRecords, this._totalErrors, this._totalWarnings, this._alerts);
        }

        public String toString() {
            return Utils.udtToString("schemarise.alfa.runtime.model.asserts.ValidationReport", new String[]{"Id", "Timestamp", "SourceSystem", "SourceSubsystem", "SourceFeed", "SourceSubfeed", "SourceInfo", "DataFormat", "DataFormatInfo", "TotalRecords", "TotalErrors", "TotalWarnings", "Alerts"}, new Object[]{this._key.getId(), this._timestamp, this._sourceSystem, this._sourceSubsystem, this._sourceFeed, this._sourceSubfeed, this._sourceInfo, this._dataFormat, this._dataFormatInfo, this._totalRecords, this._totalErrors, this._totalWarnings, this._alerts});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof _ValidationReportConcrete)) {
                return false;
            }
            _ValidationReportConcrete rhs = (_ValidationReportConcrete)o;
            return Objects.equals(this._timestamp, rhs._timestamp) && Objects.equals(this._sourceSystem, rhs._sourceSystem) && Objects.equals(this._sourceSubsystem, rhs._sourceSubsystem) && Objects.equals(this._sourceFeed, rhs._sourceFeed) && Objects.equals(this._sourceSubfeed, rhs._sourceSubfeed) && Objects.equals(this._sourceInfo, rhs._sourceInfo) && Objects.equals(this._dataFormat, rhs._dataFormat) && Objects.equals(this._dataFormatInfo, rhs._dataFormatInfo) && this._totalRecords == rhs._totalRecords && this._totalErrors == rhs._totalErrors && this._totalWarnings == rhs._totalWarnings && Objects.equals(this._alerts, rhs._alerts) && Objects.equals(this._key, rhs._key);
        }

        public void traverse(Visitor v) {
        }

        public Optional<ValidationReportKey> get$key() {
            return Optional.ofNullable(this._key);
        }

        public TypeDescriptor descriptor() {
            return ValidationReportDescriptor.INSTANCE;
        }

        public Object get(String fieldName) {
            switch (fieldName) {
                case "Timestamp": {
                    return this._timestamp;
                }
                case "SourceSystem": {
                    return this._sourceSystem;
                }
                case "SourceSubsystem": {
                    return this._sourceSubsystem;
                }
                case "SourceFeed": {
                    return this._sourceFeed;
                }
                case "SourceSubfeed": {
                    return this._sourceSubfeed;
                }
                case "SourceInfo": {
                    return this._sourceInfo;
                }
                case "DataFormat": {
                    return this._dataFormat;
                }
                case "DataFormatInfo": {
                    return this._dataFormatInfo;
                }
                case "TotalRecords": {
                    return this._totalRecords;
                }
                case "TotalErrors": {
                    return this._totalErrors;
                }
                case "TotalWarnings": {
                    return this._totalWarnings;
                }
                case "Alerts": {
                    return this._alerts;
                }
            }
            throw new AlfaRuntimeException("Cannot get unknown field " + fieldName);
        }

        public void validate(IBuilderConfig __builderConfig) {
            IntStream.range(0, this.getAlerts().size()).forEach(e0 -> this.getAlerts().get(e0).validate(__builderConfig));
        }
    }

    public static final class _ValidationReportConcrete
    extends _ValidationReport__Base__
    implements ValidationReport {
        private _ValidationReportConcrete() {
        }

        private _ValidationReportConcrete(ValidationReportKey _key, LocalDateTime _timestamp, Optional<String> _sourceSystem, Optional<String> _sourceSubsystem, Optional<String> _sourceFeed, Optional<String> _sourceSubfeed, Optional<String> _sourceInfo, Optional<String> _dataFormat, Optional<String> _dataFormatInfo, long _totalRecords, long _totalErrors, long _totalWarnings, List<ValidationAlert> _alerts) {
            super(_key, _timestamp, _sourceSystem, _sourceSubsystem, _sourceFeed, _sourceSubfeed, _sourceInfo, _dataFormat, _dataFormatInfo, _totalRecords, _totalErrors, _totalWarnings, _alerts);
        }
    }

    public static final class _ValidationReportBuilderImpl
    extends _ValidationReport__Base__
    implements ValidationReportBuilder {
        private final IBuilderConfig __builderConfig;
        private BitSet __missingFields;

        private _ValidationReportBuilderImpl() {
            this(BuilderConfig.getInstance());
        }

        private _ValidationReportBuilderImpl(IBuilderConfig cc) {
            this.__builderConfig = cc;
            this.__missingFields = new BitSet(12);
            this.__missingFields.set(0, 12);
            this.setSourceSystem(Optional.empty());
            this.setSourceSubsystem(Optional.empty());
            this.setSourceFeed(Optional.empty());
            this.setSourceSubfeed(Optional.empty());
            this.setSourceInfo(Optional.empty());
            this.setDataFormat(Optional.empty());
            this.setDataFormatInfo(Optional.empty());
        }

        protected IBuilderConfig builderConfig() {
            return this.__builderConfig;
        }

        @Override
        public TypeDescriptor descriptor() {
            return ValidationReportDescriptor.INSTANCE;
        }

        @Override
        public ValidationReportBuilder setTimestamp(LocalDateTime v) {
            AlfaUtils.notNull("Timestamp", v);
            this._timestamp = v;
            this.clearMissingFlag((short)0);
            return this;
        }

        @Override
        public ValidationReportBuilder setSourceSystem(Optional<String> v) {
            AlfaUtils.notNull("SourceSystem", v);
            this._sourceSystem = v;
            this.clearMissingFlag((short)1);
            return this;
        }

        @Override
        public ValidationReportBuilder setSourceSystem(String v) {
            this._sourceSystem = Optional.ofNullable(v);
            this.clearMissingFlag((short)1);
            return this;
        }

        @Override
        public ValidationReportBuilder setSourceSubsystem(Optional<String> v) {
            AlfaUtils.notNull("SourceSubsystem", v);
            this._sourceSubsystem = v;
            this.clearMissingFlag((short)2);
            return this;
        }

        @Override
        public ValidationReportBuilder setSourceSubsystem(String v) {
            this._sourceSubsystem = Optional.ofNullable(v);
            this.clearMissingFlag((short)2);
            return this;
        }

        @Override
        public ValidationReportBuilder setSourceFeed(Optional<String> v) {
            AlfaUtils.notNull("SourceFeed", v);
            this._sourceFeed = v;
            this.clearMissingFlag((short)3);
            return this;
        }

        @Override
        public ValidationReportBuilder setSourceFeed(String v) {
            this._sourceFeed = Optional.ofNullable(v);
            this.clearMissingFlag((short)3);
            return this;
        }

        @Override
        public ValidationReportBuilder setSourceSubfeed(Optional<String> v) {
            AlfaUtils.notNull("SourceSubfeed", v);
            this._sourceSubfeed = v;
            this.clearMissingFlag((short)4);
            return this;
        }

        @Override
        public ValidationReportBuilder setSourceSubfeed(String v) {
            this._sourceSubfeed = Optional.ofNullable(v);
            this.clearMissingFlag((short)4);
            return this;
        }

        @Override
        public ValidationReportBuilder setSourceInfo(Optional<String> v) {
            AlfaUtils.notNull("SourceInfo", v);
            this._sourceInfo = v;
            this.clearMissingFlag((short)5);
            return this;
        }

        @Override
        public ValidationReportBuilder setSourceInfo(String v) {
            this._sourceInfo = Optional.ofNullable(v);
            this.clearMissingFlag((short)5);
            return this;
        }

        @Override
        public ValidationReportBuilder setDataFormat(Optional<String> v) {
            AlfaUtils.notNull("DataFormat", v);
            this._dataFormat = v;
            this.clearMissingFlag((short)6);
            return this;
        }

        @Override
        public ValidationReportBuilder setDataFormat(String v) {
            this._dataFormat = Optional.ofNullable(v);
            this.clearMissingFlag((short)6);
            return this;
        }

        @Override
        public ValidationReportBuilder setDataFormatInfo(Optional<String> v) {
            AlfaUtils.notNull("DataFormatInfo", v);
            this._dataFormatInfo = v;
            this.clearMissingFlag((short)7);
            return this;
        }

        @Override
        public ValidationReportBuilder setDataFormatInfo(String v) {
            this._dataFormatInfo = Optional.ofNullable(v);
            this.clearMissingFlag((short)7);
            return this;
        }

        @Override
        public ValidationReportBuilder setTotalRecords(long v) {
            AlfaUtils.notNull("TotalRecords", v);
            this._totalRecords = v;
            this.clearMissingFlag((short)8);
            return this;
        }

        @Override
        public ValidationReportBuilder setTotalErrors(long v) {
            AlfaUtils.notNull("TotalErrors", v);
            this._totalErrors = v;
            this.clearMissingFlag((short)9);
            return this;
        }

        @Override
        public ValidationReportBuilder setTotalWarnings(long v) {
            AlfaUtils.notNull("TotalWarnings", v);
            this._totalWarnings = v;
            this.clearMissingFlag((short)10);
            return this;
        }

        private void createAlerts() {
            this._alerts = new ArrayList();
        }

        @Override
        public ValidationReportBuilder addAlerts(ValidationAlert e) {
            AlfaUtils.notNull("Alerts", e);
            if (this._alerts == null) {
                this.createAlerts();
            }
            this._alerts.add(e);
            this.clearMissingFlag((short)11);
            return this;
        }

        public ValidationReportBuilder setAlerts(int index, ValidationAlert e) {
            AlfaUtils.notNull("Alerts", e);
            if (this._alerts == null) {
                this.createAlerts();
            }
            this._alerts.set(index, e);
            this.clearMissingFlag((short)11);
            return this;
        }

        @Override
        public ValidationReportBuilder addAllAlerts(List<ValidationAlert> all) {
            AlfaUtils.notNull("Alerts", all);
            if (this._alerts == null) {
                this.createAlerts();
            }
            this._alerts.addAll(all);
            this.clearMissingFlag((short)11);
            return this;
        }

        private ValidationReportBuilder setAlerts(List<ValidationAlert> all) {
            AlfaUtils.notNull("Alerts", all);
            this._alerts = all;
            this.clearMissingFlag((short)11);
            return this;
        }

        @Override
        public void modify(String fieldName, Object val) {
            switch (fieldName) {
                case "Timestamp": {
                    this.setTimestamp((LocalDateTime)val);
                    break;
                }
                case "SourceSystem": {
                    this.setSourceSystem((Optional)val);
                    break;
                }
                case "SourceSubsystem": {
                    this.setSourceSubsystem((Optional)val);
                    break;
                }
                case "SourceFeed": {
                    this.setSourceFeed((Optional)val);
                    break;
                }
                case "SourceSubfeed": {
                    this.setSourceSubfeed((Optional)val);
                    break;
                }
                case "SourceInfo": {
                    this.setSourceInfo((Optional)val);
                    break;
                }
                case "DataFormat": {
                    this.setDataFormat((Optional)val);
                    break;
                }
                case "DataFormatInfo": {
                    this.setDataFormatInfo((Optional)val);
                    break;
                }
                case "TotalRecords": {
                    this.setTotalRecords((Long)val);
                    break;
                }
                case "TotalErrors": {
                    this.setTotalErrors((Long)val);
                    break;
                }
                case "TotalWarnings": {
                    this.setTotalWarnings((Long)val);
                    break;
                }
                case "Alerts": {
                    this.setAlerts((List)val);
                    break;
                }
                default: {
                    throw new AlfaRuntimeException(ConstraintType.UnknownField, "Attempt to set unknown field " + fieldName);
                }
            }
        }

        @Override
        public ValidationReportBuilder set$key(ValidationReportKey k) {
            this._key = k;
            return this;
        }

        @Override
        public ValidationReportKey assignedKey() {
            return this._key;
        }

        @Override
        public ValidationReport build() {
            Utils.assertMandatoryFieldsSet(this.builderConfig(), this.__missingFields, 12, ValidationReportDescriptor.INSTANCE);
            if (this._key == null) {
                this.builderConfig().getAssertListener().addFailure(ValidationAlert.builder().setMessage("Entity key not set").setTypeName(Optional.of("schemarise.alfa.runtime.model.asserts.ValidationReport")).setViolatedConstraint(Optional.of(ConstraintType.MandatoryFieldNotSet)));
            }
            ValidationReport obj = this.builderConfig().getCustomBuilderFactory().isPresent() ? (ValidationReport)this.builderConfig().getCustomBuilderFactory().get().create(this.builderConfig(), this.descriptor(), this._key, this._timestamp, this._sourceSystem, this._sourceSubsystem, this._sourceFeed, this._sourceSubfeed, this._sourceInfo, this._dataFormat, this._dataFormatInfo, this._totalRecords, this._totalErrors, this._totalWarnings, VectorCloner.immutableList(this.builderConfig(), ValidationReportDescriptor.INSTANCE._alertsSupplierInner1, this._alerts)) : new _ValidationReportConcrete(this._key, this._timestamp, this._sourceSystem, this._sourceSubsystem, this._sourceFeed, this._sourceSubfeed, this._sourceInfo, this._dataFormat, this._dataFormatInfo, this._totalRecords, this._totalErrors, this._totalWarnings, VectorCloner.immutableList(this.builderConfig(), ValidationReportDescriptor.INSTANCE._alertsSupplierInner1, this._alerts));
            if (this.builderConfig().shouldValidateOnBuild()) {
                obj.validate(this.builderConfig());
            }
            return obj;
        }

        private void clearMissingFlag(short flag) {
            this.__missingFields.clear(flag);
        }

        @Override
        public String toString() {
            return Utils.udtToString("schemarise.alfa.runtime.model.asserts.ValidationReport", new String[]{"Id", "Timestamp", "SourceSystem", "SourceSubsystem", "SourceFeed", "SourceSubfeed", "SourceInfo", "DataFormat", "DataFormatInfo", "TotalRecords", "TotalErrors", "TotalWarnings", "Alerts"}, new Object[]{this._key.getId(), this._timestamp, this._sourceSystem, this._sourceSubsystem, this._sourceFeed, this._sourceSubfeed, this._sourceInfo, this._dataFormat, this._dataFormatInfo, this._totalRecords, this._totalErrors, this._totalWarnings, this._alerts});
        }
    }

    public static interface ValidationReportBuilder
    extends Builder,
    AlfaObject,
    EntityBuilder<ValidationReportKey> {
        public ValidationReportBuilder setTimestamp(LocalDateTime var1);

        public LocalDateTime getTimestamp();

        public ValidationReportBuilder setSourceSystem(Optional<String> var1);

        public ValidationReportBuilder setSourceSystem(String var1);

        public Optional<String> getSourceSystem();

        public ValidationReportBuilder setSourceSubsystem(Optional<String> var1);

        public ValidationReportBuilder setSourceSubsystem(String var1);

        public Optional<String> getSourceSubsystem();

        public ValidationReportBuilder setSourceFeed(Optional<String> var1);

        public ValidationReportBuilder setSourceFeed(String var1);

        public Optional<String> getSourceFeed();

        public ValidationReportBuilder setSourceSubfeed(Optional<String> var1);

        public ValidationReportBuilder setSourceSubfeed(String var1);

        public Optional<String> getSourceSubfeed();

        public ValidationReportBuilder setSourceInfo(Optional<String> var1);

        public ValidationReportBuilder setSourceInfo(String var1);

        public Optional<String> getSourceInfo();

        public ValidationReportBuilder setDataFormat(Optional<String> var1);

        public ValidationReportBuilder setDataFormat(String var1);

        public Optional<String> getDataFormat();

        public ValidationReportBuilder setDataFormatInfo(Optional<String> var1);

        public ValidationReportBuilder setDataFormatInfo(String var1);

        public Optional<String> getDataFormatInfo();

        public ValidationReportBuilder setTotalRecords(long var1);

        public long getTotalRecords();

        public ValidationReportBuilder setTotalErrors(long var1);

        public long getTotalErrors();

        public ValidationReportBuilder setTotalWarnings(long var1);

        public long getTotalWarnings();

        public ValidationReportBuilder addAlerts(ValidationAlert var1);

        public ValidationReportBuilder addAllAlerts(List<ValidationAlert> var1);

        public List<ValidationAlert> getAlerts();

        public ValidationReportBuilder set$key(ValidationReportKey var1);

        public ValidationReport build();
    }
}

