/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Compressed;
import com.schemarise.alfa.runtime.Encrypted;
import com.schemarise.alfa.runtime.Entity;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.ITable;
import com.schemarise.alfa.runtime.Key;
import com.schemarise.alfa.runtime.NormalizedPeriod;
import com.schemarise.alfa.runtime.Union;
import com.schemarise.alfa.runtime.UnionUntypedCase;
import com.schemarise.alfa.runtime.codec.CodecConfig;
import com.schemarise.alfa.runtime.codec.OptSetChecker;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import schemarise.alfa.runtime.model.CompressedDataType;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.EitherDataType;
import schemarise.alfa.runtime.model.EncryptedDataType;
import schemarise.alfa.runtime.model.EnumDataType;
import schemarise.alfa.runtime.model.FutureDataType;
import schemarise.alfa.runtime.model.IDataType;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.MapDataType;
import schemarise.alfa.runtime.model.MetaDataType;
import schemarise.alfa.runtime.model.OptionalDataType;
import schemarise.alfa.runtime.model.Pair;
import schemarise.alfa.runtime.model.PairDataType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.SetDataType;
import schemarise.alfa.runtime.model.StreamDataType;
import schemarise.alfa.runtime.model.TabularDataType;
import schemarise.alfa.runtime.model.Try;
import schemarise.alfa.runtime.model.TryDataType;
import schemarise.alfa.runtime.model.TupleDataType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UnionDataType;

public abstract class DataConsumer {
    private Stack<String> currField = new Stack();
    private CodecConfig codecConfig;

    protected DataConsumer() {
        this(CodecConfig.defaultCodecConfig());
    }

    protected DataConsumer(CodecConfig jwc) {
        this.codecConfig = jwc;
    }

    public void init() {
        this.currField.clear();
    }

    protected CodecConfig getCodecConfig() {
        return this.codecConfig;
    }

    public abstract void consume(ScalarDataType var1, int var2);

    public abstract void consume(ScalarDataType var1, String var2);

    public abstract void consume(ScalarDataType var1, double var2);

    public abstract void consume(ScalarDataType var1, float var2);

    public abstract void consume(ScalarDataType var1, short var2);

    public abstract void consume(ScalarDataType var1, long var2);

    public abstract void consume(ScalarDataType var1, byte var2);

    public abstract void consume(ScalarDataType var1, byte[] var2);

    public abstract void consume(ScalarDataType var1, char var2);

    public abstract void consume(ScalarDataType var1, boolean var2);

    public abstract void consume(ScalarDataType var1, BigDecimal var2);

    public abstract void consume(ScalarDataType var1, LocalDate var2);

    public abstract void consume(ScalarDataType var1, LocalDateTime var2);

    public abstract void consume(ScalarDataType var1, ZonedDateTime var2);

    public abstract void consume(ScalarDataType var1, LocalTime var2);

    public abstract void consume(ScalarDataType var1, Duration var2);

    public abstract void consume(ScalarDataType var1, NormalizedPeriod var2);

    public abstract void consume(ScalarDataType var1, UUID var2);

    public abstract void consume(ScalarDataType var1, URI var2);

    public abstract void consume(ScalarDataType var1, UnionUntypedCase var2);

    public abstract <T> void consume(OptionalDataType var1, Optional<T> var2, BiConsumer<T, DataConsumer> var3);

    public abstract <T> void consume(CompressedDataType var1, Compressed var2, BiConsumer<T, DataConsumer> var3);

    public abstract <T> void consume(EncryptedDataType var1, Encrypted<T> var2, BiConsumer<T, DataConsumer> var3);

    public abstract <K, V> void consume(MapDataType var1, Map<K, V> var2, BiConsumer<K, DataConsumer> var3, BiConsumer<V, DataConsumer> var4);

    public abstract <T> void consume(SetDataType var1, Set<T> var2, BiConsumer<T, DataConsumer> var3);

    public abstract <T> void consume(ListDataType var1, List<T> var2, BiConsumer<T, DataConsumer> var3);

    public abstract <T> void consume(StreamDataType var1, List<T> var2, BiConsumer<T, DataConsumer> var3);

    public abstract <T> void consume(FutureDataType var1, Future<T> var2, BiConsumer<T, DataConsumer> var3);

    public abstract <T> void consume(MetaDataType var1, T var2);

    public abstract <T> void consume(TabularDataType var1, ITable var2, BiConsumer<T, DataConsumer> var3);

    public void consume(AlfaObject v) {
        this.consume(v.descriptor().getUdtDataType(), v);
    }

    public void consume(TupleDataType dt, AlfaObject v) {
        this.consume(dt, v, Collections.emptyMap());
    }

    public void consume(UnionDataType dt, AlfaObject v) {
        this.consume(dt, v, Collections.emptyMap());
    }

    public void consume(EnumDataType dt, AlfaObject v) {
        this.consume(dt, v, Collections.emptyMap());
    }

    public void consume(UdtDataType dt, AlfaObject v) {
        this.consume(dt, v, Collections.emptyMap());
    }

    public <T> void consume(TryDataType dt, Try<T> v, BiConsumer<T, DataConsumer> c) {
        HashMap<String, IDataType> templateTypes = new HashMap<String, IDataType>();
        templateTypes.put("Result", dt.getComponentType());
        HashMap<String, BiConsumer> m = new HashMap<String, BiConsumer>();
        m.put("Result", c);
        this.consumeTemplated(dt.getComponentType(), v, m, templateTypes);
    }

    public <L, R> void consume(PairDataType dt, Pair<L, R> v, BiConsumer<L, DataConsumer> leftConsumer, BiConsumer<R, DataConsumer> rightConsumer) {
        HashMap<String, BiConsumer> c = new HashMap<String, BiConsumer>();
        HashMap<String, IDataType> templateTypes = new HashMap<String, IDataType>();
        templateTypes.put("Left", dt.getLeftComponentType());
        templateTypes.put("Right", dt.getRightComponentType());
        c.put("Left", leftConsumer);
        this.consumeTemplated(dt.getLeftComponentType(), v, c, templateTypes);
        c.put("Right", rightConsumer);
        this.consumeTemplated(dt.getRightComponentType(), v, c, templateTypes);
    }

    public <L, R> void consume(EitherDataType dt, Either<L, R> v, BiConsumer<L, DataConsumer> leftConsumer, BiConsumer<R, DataConsumer> rightConsumer) {
        HashMap<String, BiConsumer> c = new HashMap<String, BiConsumer>();
        HashMap<String, IDataType> templateTypes = new HashMap<String, IDataType>();
        templateTypes.put("Left", dt.getLeftComponentType());
        templateTypes.put("Right", dt.getRightComponentType());
        if (v.isLeft()) {
            c.put("Left", leftConsumer);
            this.consumeTemplated(dt.getLeftComponentType(), v, c, templateTypes);
        } else {
            c.put("Right", rightConsumer);
            this.consumeTemplated(dt.getRightComponentType(), v, c, templateTypes);
        }
    }

    public String currentFieldName() {
        if (this.currField.isEmpty()) {
            return "";
        }
        return this.currField.peek();
    }

    public void consumeTemplated(IDataType dt, AlfaObject v, Map<String, BiConsumer> templatedFieldConsumer, Map<String, IDataType> templatedTypes) {
        this.consume(dt, v, templatedFieldConsumer);
    }

    public void consume(IDataType dt, AlfaObject v, Map<String, BiConsumer> templatedFieldConsumer) {
        if (v instanceof Union) {
            Union u = (Union)v;
            String c = u.caseName();
            BiConsumer sup = templatedFieldConsumer.get(c);
            IDataType fdt = v.descriptor().getAllFieldsMeta().get(c).getDataType();
            this.preConsumeField(c, fdt);
            if (sup != null) {
                Object cv = u.caseValue();
                sup.accept(cv, this);
            } else {
                Optional o = v.descriptor().getFieldSupplier(c);
                if (o.isPresent()) {
                    o.get().accept(v, this);
                } else {
                    throw new AlfaRuntimeException("Not consuming field");
                }
            }
            this.postConsumeField(c, fdt, false);
        } else {
            Entity ent;
            Optional<? extends Key> k;
            if (v instanceof Entity && (k = (ent = (Entity)v).get$key()).isPresent()) {
                String kf = this.codecConfig.getMetaFieldPrefix() + "key";
                if (this.codecConfig.isWriteEntityKeyAsObject()) {
                    this.preConsumeField(kf, k.get().descriptor().getUdtDataType());
                    this.consume(k.get());
                    this.postConsumeField(kf, k.get().descriptor().getUdtDataType(), false);
                } else {
                    this.consumeFields(k.get());
                }
            }
            this.consumeFields(v);
        }
    }

    private void consumeFields(AlfaObject v) {
        OptSetChecker checker = new OptSetChecker();
        this.getFieldsMeta(v).forEach((fk, fv) -> {
            if (fv.getSupplier().isPresent()) {
                boolean skip = false;
                BiConsumer<AlfaObject, DataConsumer> sup = fv.getSupplier().get();
                this.preConsumeField((String)fk, fv.getDataType());
                if (fv.getDataType() instanceof OptionalDataType) {
                    sup.accept(v, checker);
                    if (!checker.isSet()) {
                        skip = true;
                    }
                }
                if (!skip) {
                    sup.accept(v, this);
                }
                this.postConsumeField((String)fk, fv.getDataType(), skip);
            }
        });
    }

    protected <T extends AlfaObject> Map<String, FieldMeta<T>> getFieldsMeta(AlfaObject ao) {
        return ao.descriptor().getAllFieldsMeta();
    }

    public Map<String, FieldMeta> scalarsFirstFieldMeta(AlfaObject ao) {
        Map map = ao.descriptor().getAllFieldsMeta();
        ArrayList list = new ArrayList(map.entrySet());
        Comparator<Map.Entry<String, FieldMeta>> typeComp = new Comparator<Map.Entry<String, FieldMeta>>(){

            @Override
            public int compare(Map.Entry<String, FieldMeta> o1, Map.Entry<String, FieldMeta> o2) {
                boolean t2;
                boolean t1 = o1.getValue().getDataType() instanceof ScalarDataType;
                if (t1 == (t2 = o1.getValue().getDataType() instanceof ScalarDataType) && t1) {
                    return 0;
                }
                if (t1) {
                    return -1;
                }
                return 1;
            }
        };
        list.sort(typeComp);
        LinkedHashMap<String, FieldMeta> result = new LinkedHashMap<String, FieldMeta>();
        for (Map.Entry entry : list) {
            result.put((String)entry.getKey(), (FieldMeta)entry.getValue());
        }
        return result;
    }

    public void preConsumeField(String fk, IDataType dataType) {
        this.currField.push(fk);
    }

    public List<String> getFieldNamesHierarchy() {
        return this.currField.subList(0, this.currField.size());
    }

    public void postConsumeField(String fk, IDataType dataType, boolean skipped) {
        this.currField.pop();
    }

    public OutputStream closeAndGetBuffer() {
        throw new UnsupportedOperationException();
    }
}

