/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.Compressed;
import com.schemarise.alfa.runtime.Encrypted;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.ITable;
import com.schemarise.alfa.runtime.NormalizedPeriod;
import com.schemarise.alfa.runtime.Record;
import com.schemarise.alfa.runtime.Union;
import com.schemarise.alfa.runtime.UnionUntypedCase;
import com.schemarise.alfa.runtime.codec.CodecConfig;
import com.schemarise.alfa.runtime.utils.ClassUtils;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Function;
import schemarise.alfa.runtime.model.CompressedDataType;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.EitherDataType;
import schemarise.alfa.runtime.model.EncryptedDataType;
import schemarise.alfa.runtime.model.EnumDataType;
import schemarise.alfa.runtime.model.Field;
import schemarise.alfa.runtime.model.FutureDataType;
import schemarise.alfa.runtime.model.ListDataType;
import schemarise.alfa.runtime.model.MapDataType;
import schemarise.alfa.runtime.model.MetaDataType;
import schemarise.alfa.runtime.model.OptionalDataType;
import schemarise.alfa.runtime.model.Pair;
import schemarise.alfa.runtime.model.PairDataType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.SetDataType;
import schemarise.alfa.runtime.model.StreamDataType;
import schemarise.alfa.runtime.model.TabularDataType;
import schemarise.alfa.runtime.model.Try;
import schemarise.alfa.runtime.model.TryDataType;
import schemarise.alfa.runtime.model.TupleDataType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UnionDataType;

public abstract class DataSupplier {
    private Stack<String> currFieldNameStack = new Stack();
    private CodecConfig codecConfig;

    protected DataSupplier(CodecConfig jwc) {
        this.codecConfig = jwc;
    }

    protected CodecConfig getCodecConfig() {
        return this.codecConfig;
    }

    public abstract int intValue(ScalarDataType var1);

    public abstract String stringValue(ScalarDataType var1);

    public abstract double doubleValue(ScalarDataType var1);

    public abstract short shortValue(ScalarDataType var1);

    public abstract long longValue(ScalarDataType var1);

    public abstract byte byteValue(ScalarDataType var1);

    public abstract char charValue(ScalarDataType var1);

    public abstract boolean booleanValue(ScalarDataType var1);

    public abstract BigDecimal decimalValue(ScalarDataType var1);

    public abstract LocalDate dateValue(ScalarDataType var1);

    public abstract LocalDateTime datetimeValue(ScalarDataType var1);

    public abstract ZonedDateTime datetimetzValue(ScalarDataType var1);

    public abstract LocalTime timeValue(ScalarDataType var1);

    public abstract float floatValue(ScalarDataType var1);

    public abstract byte[] binaryValue(ScalarDataType var1);

    public abstract Duration durationValue(ScalarDataType var1);

    public abstract NormalizedPeriod periodValue(ScalarDataType var1);

    public abstract UUID uuidValue(ScalarDataType var1);

    public abstract URI uriValue(ScalarDataType var1);

    public abstract String patternValue(ScalarDataType var1);

    public abstract UnionUntypedCase voidValue(ScalarDataType var1);

    public abstract <T extends Record> T tupleValue(TupleDataType var1);

    public abstract <T extends Enum> T enumValue(EnumDataType var1);

    public abstract <T extends Union> T unionValue(UnionDataType var1);

    public abstract <T> T metaValue(MetaDataType var1);

    public abstract <T extends AlfaObject> T objectValue(UdtDataType var1);

    public <T extends AlfaObject> T objectValue(String fieldName, UdtDataType t) {
        this.currFieldNameStack.push(fieldName);
        T result = this.objectValue(t);
        this.currFieldNameStack.pop();
        return result;
    }

    public <T extends AlfaObject> T objectValue(Optional<Class> clz) {
        Optional<ClassUtils.ClassMeta> cm = Optional.empty();
        if (clz.isPresent()) {
            ClassUtils.ClassMeta m = ClassUtils.getMeta(clz.get().getName());
            cm = Optional.of(m);
        }
        try {
            return this.objectValue(cm, Collections.emptyMap());
        }
        catch (AlfaRuntimeException are) {
            if (cm.isPresent()) {
                are.setValidationErrorTypeName(cm.get().getModel().getUdtDataType().getFullyQualifiedName());
            }
            throw are;
        }
    }

    public abstract <T extends AlfaObject> T objectValue(UdtDataType var1, Map<String, Function> var2);

    public abstract <T extends AlfaObject> T objectValue(Optional<ClassUtils.ClassMeta> var1, Map<String, Function> var2);

    public abstract <K, V> Map<K, V> mapValue(MapDataType var1, Function<DataSupplier, K> var2, Function<DataSupplier, V> var3);

    public <K, V> Map<K, V> mapValue(Field f, Function<DataSupplier, K> kc, Function<DataSupplier, V> vc) {
        this.currFieldNameStack.push(f.getName());
        Map<K, V> r = this.mapValue((MapDataType)f.getDataType(), kc, vc);
        this.currFieldNameStack.pop();
        return r;
    }

    public abstract <T> Set<T> setValue(SetDataType var1, Function<DataSupplier, T> var2);

    public <T> Set<T> setValue(Field f, Function<DataSupplier, T> c) {
        this.currFieldNameStack.push(f.getName());
        Set<T> result = this.setValue((SetDataType)f.getDataType(), c);
        this.currFieldNameStack.pop();
        return result;
    }

    public abstract <T> List<T> listValue(ListDataType var1, Function<DataSupplier, T> var2);

    public <T> List<T> listValue(Field f, Function<DataSupplier, T> c) {
        this.currFieldNameStack.push(f.getName());
        List<T> result = this.listValue((ListDataType)f.getDataType(), c);
        this.currFieldNameStack.pop();
        return result;
    }

    public abstract <T> Optional<T> optionalValue(OptionalDataType var1, Function<DataSupplier, T> var2);

    public <T> Optional<T> optionalValue(Field f, Function<DataSupplier, T> c) {
        this.currFieldNameStack.push(f.getName());
        Optional<T> v = this.optionalValue((OptionalDataType)f.getDataType(), c);
        this.currFieldNameStack.pop();
        return v;
    }

    public <T> Try<T> tryValue(TryDataType dt, Function<DataSupplier, T> c) {
        Object res = null;
        HashMap<String, Function> m = new HashMap<String, Function>();
        m.put("Result", c);
        ClassUtils.ClassMeta cm = ClassUtils.getMeta(Try.class.getName());
        T v = this.objectValue(Optional.of(cm), m);
        return (Try)v;
    }

    public void fieldValue(Field field, Builder builder, BiConsumer supplier) {
        this.currFieldNameStack.push(field.getName());
        try {
            this._fieldValue(field, builder, supplier);
        }
        catch (AlfaRuntimeException are) {
            are.setValidationErrorField(field.getName());
            throw are;
        }
        finally {
            this.currFieldNameStack.pop();
        }
    }

    private void _fieldValue(Field field, Builder builder, BiConsumer supplier) {
        supplier.accept(builder, this);
    }

    public <T> Try<T> tryValue(Field f, Function<DataSupplier, T> c) {
        this.currFieldNameStack.push(f.getName());
        Try<T> v = this.tryValue((TryDataType)f.getDataType(), c);
        this.currFieldNameStack.pop();
        return v;
    }

    public abstract <T> Compressed compressedValue(Function<DataSupplier, T> var1);

    public <T> Compressed compressedValue(CompressedDataType f, Function<DataSupplier, T> compressedConsumer) {
        return this.compressedValue(compressedConsumer);
    }

    public <T> Compressed compressedValue(Field f, Function<DataSupplier, T> c) {
        this.currFieldNameStack.push(f.getName());
        Compressed v = this.compressedValue((CompressedDataType)f.getDataType(), c);
        this.currFieldNameStack.pop();
        return v;
    }

    public abstract <T> Encrypted<T> encryptedValue(Function<DataSupplier, T> var1);

    public <T> Encrypted<T> encryptedValue(EncryptedDataType f, Function<DataSupplier, T> encryptedConsumer) {
        return this.encryptedValue(encryptedConsumer);
    }

    public <T> Encrypted<T> encryptedValue(Field f, Function<DataSupplier, T> c) {
        this.currFieldNameStack.push(f.getName());
        Encrypted<T> v = this.encryptedValue((EncryptedDataType)f.getDataType(), c);
        this.currFieldNameStack.pop();
        return v;
    }

    public abstract <T> List<T> streamValue(StreamDataType var1, Function<DataSupplier, T> var2);

    public <T> List<T> streamValue(Field f, Function<DataSupplier, T> c) {
        this.currFieldNameStack.push(f.getName());
        List<T> v = this.streamValue((StreamDataType)f.getDataType(), c);
        this.currFieldNameStack.pop();
        return v;
    }

    public abstract <T> Future<T> futureValue(FutureDataType var1, Function<DataSupplier, T> var2);

    public <T> Future<T> futureValue(Field f, Function<DataSupplier, T> c) {
        this.currFieldNameStack.push(f.getName());
        Future<T> v = this.futureValue((FutureDataType)f.getDataType(), c);
        this.currFieldNameStack.pop();
        return v;
    }

    public abstract <T> ITable tableValue(TabularDataType var1, Function<DataSupplier, T> var2);

    protected String currentFieldName() {
        return this.currFieldNameStack.peek();
    }

    protected boolean hasCurrentFieldName() {
        return !this.currFieldNameStack.isEmpty();
    }

    public <T> ITable tableValue(Field f, Function<DataSupplier, T> c) {
        this.currFieldNameStack.push(f.getName());
        ITable v = this.tableValue((TabularDataType)f.getDataType(), c);
        this.currFieldNameStack.pop();
        return v;
    }

    public abstract <L, R> Pair<L, R> pairValue(PairDataType var1, Function<DataSupplier, L> var2, Function<DataSupplier, R> var3);

    public <L, R> Pair<L, R> pairValue(Field f, Function<DataSupplier, L> lc, Function<DataSupplier, R> rc) {
        this.currFieldNameStack.push(f.getName());
        Pair<L, R> v = this.pairValue((PairDataType)f.getDataType(), lc, rc);
        this.currFieldNameStack.pop();
        return v;
    }

    public abstract <L, R> Either<L, R> eitherValue(EitherDataType var1, Function<DataSupplier, L> var2, Function<DataSupplier, R> var3);

    public <L, R> Either<L, R> eitherValue(Field f, Function<DataSupplier, L> lc, Function<DataSupplier, R> rc) {
        this.currFieldNameStack.push(f.getName());
        Either<L, R> v = this.eitherValue((EitherDataType)f.getDataType(), lc, rc);
        this.currFieldNameStack.pop();
        return v;
    }

    public <T> T paramTypeValue() {
        throw new UnsupportedOperationException();
    }
}

