/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int.table;

import com.schemarise.alfa.runtime_int.table.BaseResultSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Optional;
import schemarise.alfa.runtime.model.ColBasedTable;

class ColBasedTableResultSet
extends BaseResultSet {
    private final ColBasedTable _data;
    private int currentRow = -1;

    public ColBasedTableResultSet(ColBasedTable cd) {
        super(cd.getDef());
        this._data = cd;
    }

    @Override
    public int getRow() throws SQLException {
        return this.currentRow;
    }

    @Override
    public boolean next() throws SQLException {
        ++this.currentRow;
        return this.currentRow < this._data.getRowCount();
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public String getString(int sqlColumnIndex) throws SQLException {
        Optional<String> v = this._data.getColData().get(sqlColumnIndex - 1).getStrings().get(this.currentRow);
        if (v.isPresent()) {
            return v.get();
        }
        return null;
    }

    @Override
    public boolean getBoolean(int sqlColumnIndex) throws SQLException {
        Optional<Boolean> v = this._data.getColData().get(sqlColumnIndex - 1).getBooleans().get(this.currentRow);
        if (v.isPresent()) {
            return v.get();
        }
        return false;
    }

    @Override
    public short getShort(int sqlColumnIndex) throws SQLException {
        Optional<Short> v = this._data.getColData().get(sqlColumnIndex - 1).getShorts().get(this.currentRow);
        if (v.isPresent()) {
            return v.get();
        }
        return 0;
    }

    @Override
    public int getInt(int sqlColumnIndex) throws SQLException {
        Optional<Integer> v = this._data.getColData().get(sqlColumnIndex - 1).getInts().get(this.currentRow);
        if (v.isPresent()) {
            return v.get();
        }
        return 0;
    }

    @Override
    public long getLong(int sqlColumnIndex) throws SQLException {
        Optional<Long> v = this._data.getColData().get(sqlColumnIndex - 1).getLongs().get(this.currentRow);
        if (v.isPresent()) {
            return v.get();
        }
        return 0L;
    }

    @Override
    public double getDouble(int sqlColumnIndex) throws SQLException {
        Optional<Double> v = this._data.getColData().get(sqlColumnIndex - 1).getDoubles().get(this.currentRow);
        if (v.isPresent()) {
            return v.get();
        }
        return Double.NaN;
    }

    @Override
    public BigDecimal getBigDecimal(int sqlColumnIndex, int scale) throws SQLException {
        Optional<BigDecimal> v = this._data.getColData().get(sqlColumnIndex - 1).getDecimals().get(this.currentRow);
        if (v.isPresent()) {
            return v.get();
        }
        return null;
    }

    @Override
    public byte[] getBytes(int sqlColumnIndex) throws SQLException {
        Optional<byte[]> v = this._data.getColData().get(sqlColumnIndex - 1).getBinaries().get(this.currentRow);
        if (v.isPresent()) {
            return v.get();
        }
        return null;
    }

    @Override
    public Date getDate(int sqlColumnIndex) throws SQLException {
        Optional<LocalDate> v = this._data.getColData().get(sqlColumnIndex - 1).getDates().get(this.currentRow);
        if (v.isPresent()) {
            return Date.valueOf(v.get());
        }
        return null;
    }

    @Override
    public Time getTime(int sqlColumnIndex) throws SQLException {
        Optional<LocalTime> v = this._data.getColData().get(sqlColumnIndex - 1).getTimes().get(this.currentRow);
        if (v.isPresent()) {
            return Time.valueOf(v.get());
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(int sqlColumnIndex) throws SQLException {
        Optional<LocalDateTime> v = this._data.getColData().get(sqlColumnIndex - 1).getDatetimes().get(this.currentRow);
        if (v.isPresent()) {
            return Timestamp.valueOf(v.get());
        }
        return null;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int sqlColumnIndex) throws SQLException {
        Optional<BigDecimal> v = this._data.getColData().get(sqlColumnIndex - 1).getDecimals().get(this.currentRow);
        if (v.isPresent()) {
            return v.get();
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    public String toString() {
        return this._data.toString();
    }
}

