/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int.table;

import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.ITable;
import com.schemarise.alfa.runtime.UnionUntypedCase;
import com.schemarise.alfa.runtime_int.table.ColBasedTableResultSet;
import com.schemarise.alfa.runtime_int.table.Row;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import schemarise.alfa.runtime.model.ColBasedTable;
import schemarise.alfa.runtime.model.ColumnData;
import schemarise.alfa.runtime.model.ColumnDef;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.TableDef;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtVersionedName;

public class Table
implements ITable {
    private final UdtDataType srcUdtType;
    private int currentRow = -1;
    private List<Row> rows = new ArrayList<Row>();
    private LinkedHashMap<String, ScalarDataType> columns = new LinkedHashMap();
    private static int ColFormatWidth = 30;

    public Table(UdtDataType udtDataType) {
        this.srcUdtType = udtDataType;
    }

    public static Table merge(ITable ... tables) {
        return Table.merge(Arrays.asList(tables));
    }

    public static Table merge(List<ITable> tables) {
        Table res = new Table(((Table)tables.get((int)0)).srcUdtType);
        tables.forEach(t -> {
            res.columns.putAll(((Table)t).columns);
            res.rows.addAll(((Table)t).rows);
        });
        return res;
    }

    void insertRow() {
        Row r = new Row();
        this.rows.add(r);
        ++this.currentRow;
    }

    void update(ScalarDataType dt, String colName, Object v) {
        Row row = this.rows.get(this.currentRow);
        row.setValue(colName, v);
        ScalarDataType oldDt = this.columns.put(colName, dt);
        if (oldDt != null && !oldDt.equals(dt)) {
            throw new IllegalStateException();
        }
    }

    void cloneAndAdvanceRow(Row preVectorExpansionRow) {
        if (this.currentRow == -1) {
            throw new IllegalStateException();
        }
        Row newRow = new Row(preVectorExpansionRow);
        this.rows.add(newRow);
        ++this.currentRow;
    }

    private void print(Object o) {
        System.out.print(o);
    }

    private void println(Object o) {
        System.out.println(o);
    }

    @Override
    public String toCsvString() {
        StringBuffer sb = new StringBuffer();
        String cols = String.join((CharSequence)",", this.columns.keySet().stream().collect(Collectors.toList()));
        sb.append(cols + "\n");
        this.rows.stream().forEach(r -> {
            String row = String.join((CharSequence)",", r.getValues().stream().map(e -> e.toString()).collect(Collectors.toList()));
            sb.append(row + "\n");
        });
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String cols = String.join((CharSequence)"|", this.columns.keySet().stream().map(e -> Table.fmtCol(e)).collect(Collectors.toList()));
        this.println(cols);
        String uline = new String(new char[ColFormatWidth]).replace('\u0000', '=');
        for (int i = 0; i < this.columns.size(); ++i) {
            this.print(uline);
            if (i + 1 >= this.columns.size()) continue;
            this.print("|");
        }
        this.println("");
        this.rows.forEach(r -> this.println(r.stringify(this.columns.keySet())));
        return sb.toString();
    }

    static String fmtCol(Object o) {
        Object s = o.toString();
        if (((String)s).length() > ColFormatWidth) {
            s = "..." + ((String)s).substring(((String)s).length() - ColFormatWidth + 3);
        }
        return String.format("%1$-" + ColFormatWidth + "s", s);
    }

    @Override
    public Set<String> getColumnNames() {
        return this.columns.keySet();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValue(int row, String colName) {
        Row r = this.rows.get(row);
        return r.getValue(colName);
    }

    @Override
    public Collection<Object> getValues(int row) {
        Row r = this.rows.get(row);
        return r.getValues();
    }

    Row getCurrentRowObjectCopy() {
        Row r = this.rows.get(this.currentRow);
        return new Row(r);
    }

    @Override
    public ScalarDataType getColumnType(String cname) {
        return this.columns.get(cname);
    }

    @Override
    public ResultSet getResultSet() {
        ColBasedTable c = this.getColBasedTable();
        ColBasedTableResultSet crs = new ColBasedTableResultSet(c);
        return crs;
    }

    public ColBasedTable getColBasedTable() {
        ColBasedTable.ColBasedTableBuilder b = ColBasedTable.builder();
        b.setRowCount(this.getRowCount());
        TableDef.TableDefBuilder td = TableDef.builder();
        td.setUdtName(UdtVersionedName.builder().setUdtType(this.srcUdtType.getUdtType()).setFullyQualifiedName(this.srcUdtType.getFullyQualifiedName()).build());
        ArrayList<ColumnData> cd = new ArrayList<ColumnData>();
        td.addAllColumns(new ArrayList<ColumnDef>());
        this.columns.forEach((cn, ct) -> {
            td.addColumns(ColumnDef.builder().setDataType((ScalarDataType)ct).setName((String)cn).build());
            ArrayList col = new ArrayList();
            this.rows.forEach(r -> {
                Object cellval = r.getValue((String)cn);
                cellval = cellval == UnionUntypedCase.getInstance() ? Boolean.valueOf(true) : cellval;
                col.add(Optional.ofNullable(cellval));
            });
            ColumnData.ColumnDataBuilder colData = ColumnData.builder();
            colData.modify(this.colNameForType((ScalarDataType)ct), col);
            cd.add(colData.build());
        });
        b.setDef(td.build());
        b.addAllColData(cd);
        return b.build();
    }

    private String colNameForType(ScalarDataType ct) {
        switch (ct.getScalarType()) {
            case stringType: {
                return "strings";
            }
            case intType: {
                return "ints";
            }
            case longType: {
                return "longs";
            }
            case doubleType: {
                return "doubles";
            }
            case booleanType: {
                return "booleans";
            }
            case datetimeType: {
                return "datetimes";
            }
            case timeType: {
                return "times";
            }
            case dateType: {
                return "dates";
            }
            case uriType: {
                return "uris";
            }
            case charType: {
                return "chars";
            }
            case floatType: {
                return "floats";
            }
            case voidType: {
                return "voids";
            }
            case decimalType: {
                return "decimals";
            }
            case shortType: {
                return "shorts";
            }
            case byteType: {
                return "bytes";
            }
            case binaryType: {
                return "binaries";
            }
            case uuidType: {
                return "uuids";
            }
            case durationType: {
                return "durations";
            }
        }
        throw new AlfaRuntimeException("Unhandled " + String.valueOf(ct));
    }
}

