/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime_int.table;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.codec.CodecConfig;
import com.schemarise.alfa.runtime.codec.IMapBasedRecord;
import com.schemarise.alfa.runtime.codec.MapBasedDataSupplier;
import com.schemarise.alfa.runtime.utils.ClassUtils;
import com.schemarise.alfa.runtime_int.IntImpl;
import com.schemarise.alfa.runtime_int.table.AlfaFlattener;
import com.schemarise.alfa.runtime_int.table.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class TableCodecImpl
implements IntImpl.TableCodecIfc {
    private static final TableCodecImpl self = new TableCodecImpl();

    public static TableCodecImpl getInstance() {
        return self;
    }

    @Override
    public Table toTable(AlfaObject alfaObject) {
        AlfaFlattener f = new AlfaFlattener(alfaObject);
        return f.flatten();
    }

    @Override
    public Table toTable(Collection<? extends AlfaObject> alfaObjects) {
        ArrayList<AlfaObject> l = new ArrayList<AlfaObject>();
        alfaObjects.forEach(e -> l.add((AlfaObject)e));
        AlfaFlattener f = new AlfaFlattener(l);
        return f.flatten();
    }

    @Override
    public <T extends AlfaObject> T importRowBasedObject(CodecConfig bc, String expectedType, Optional<List<String>> optDataColumnNames, List<Object> rowBasedData, String sourceLineInfo, Map<String, Function<Object, Object>> preProcessors) {
        List<String> dataColumnNames;
        ClassUtils.ClassMeta cm = ClassUtils.getMeta(expectedType);
        if (optDataColumnNames.isPresent()) {
            dataColumnNames = optDataColumnNames.get();
        } else {
            TypeDescriptor desc = cm.getModel();
            dataColumnNames = desc.getAllFieldNames();
        }
        HashMap<String, Object> row = new HashMap<String, Object>();
        int total = Math.min(dataColumnNames.size(), rowBasedData.size());
        for (int i = 0; i < total; ++i) {
            row.put(dataColumnNames.get(i), rowBasedData.get(i));
        }
        bc.getAssertListener().setCurrentSourceInfo(sourceLineInfo);
        bc.getAssertListener().setCurrentTypeName(expectedType);
        AlfaObject mbs = this._getAlfaObject(bc, expectedType, preProcessors, cm, row);
        return (T)mbs;
    }

    private AlfaObject _getAlfaObject(CodecConfig bc, String expectedType, Map<String, Function<Object, Object>> preProcessors, ClassUtils.ClassMeta cm, Map<String, Object> row) {
        return new MapBasedDataSupplier(bc, new RowBasedData(expectedType, preProcessors, row)).objectValue(Optional.of(cm.getTypeClass()));
    }

    @Override
    public <T extends AlfaObject> Stream<T> importRowBasedObjects(CodecConfig bc, String expectedType, Optional<List<String>> optDataColumnNames, Stream<List<Object>> rowBasedData, Map<String, Function<Object, Object>> preProcessors) {
        List<String> dataColumnNames;
        if (optDataColumnNames.isPresent()) {
            dataColumnNames = optDataColumnNames.get();
        } else {
            TypeDescriptor desc = ClassUtils.getMeta(expectedType).getModel();
            dataColumnNames = desc.getAllFieldNames();
        }
        Stream<AlfaObject> str = ((Stream)rowBasedData.parallel()).map(e -> this.importRowBasedObject(bc, expectedType, Optional.of(dataColumnNames), (List<Object>)e, "<stream>", preProcessors));
        return str;
    }

    static class RowBasedData
    implements IMapBasedRecord {
        private final Map<String, Object> data;
        private final String typeName;
        private final Map<String, Function<Object, Object>> preProcessors;

        public RowBasedData(String typeName, Map<String, Function<Object, Object>> preProcessors, Map<String, Object> dat) {
            this.typeName = typeName;
            this.data = dat;
            this.preProcessors = preProcessors;
        }

        @Override
        public String getFullName() {
            return this.typeName;
        }

        @Override
        public Set<String> getFields() {
            return this.data.keySet();
        }

        @Override
        public Object get(String fieldName) {
            Object res = this.data.get(fieldName);
            if (this.preProcessors.containsKey(fieldName)) {
                Function<Object, Object> e = this.preProcessors.get(fieldName);
                return e.apply(res);
            }
            return res;
        }
    }
}

