/*
 * Decompiled with CFR 0.152.
 */
package schemarise.alfa.runtime.model;

import com.schemarise.alfa.runtime.AlfaRuntimeException;
import com.schemarise.alfa.runtime.Builder;
import com.schemarise.alfa.runtime.DataSupplier;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.FieldMeta;
import com.schemarise.alfa.runtime.IBuilderConfig;
import com.schemarise.alfa.runtime.TypeDescriptor;
import com.schemarise.alfa.runtime.utils.DefaultTypeDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import schemarise.alfa.runtime.model.Assert;
import schemarise.alfa.runtime.model.Expression;
import schemarise.alfa.runtime.model.ModifierType;
import schemarise.alfa.runtime.model.ScalarDataType;
import schemarise.alfa.runtime.model.ScalarType;
import schemarise.alfa.runtime.model.UdtDataType;
import schemarise.alfa.runtime.model.UdtMetaType;

public enum MetaType implements Enum
{
    Entity("Entity", Optional.empty()),
    Key("Key", Optional.empty()),
    Trait("Trait", Optional.empty()),
    Union("Union", Optional.empty()),
    Record("Record", Optional.empty()),
    Enum("Enum", Optional.empty()),
    Udt("Udt", Optional.empty()),
    Service("Service", Optional.empty()),
    Annotation("Annotation", Optional.empty()),
    EntityName("EntityName", Optional.empty()),
    KeyName("KeyName", Optional.empty()),
    TraitName("TraitName", Optional.empty()),
    UnionName("UnionName", Optional.empty()),
    RecordName("RecordName", Optional.empty()),
    EnumName("EnumName", Optional.empty()),
    UdtName("UdtName", Optional.empty()),
    ServiceName("ServiceName", Optional.empty()),
    FieldName("FieldName", Optional.empty());

    private final String value;
    private final Optional<String> lexical;
    private static Map<String, MetaType> mappings;

    private MetaType(String v, Optional<String> lex) {
        this.value = v;
        this.lexical = lex;
    }

    public static MetaType fromValue(String v) {
        if (mappings == null) {
            HashMap<String, MetaType> m = new HashMap<String, MetaType>();
            for (MetaType c : MetaType.values()) {
                m.put(c.value, c);
            }
            mappings = m;
        }
        return mappings.get(v);
    }

    @Override
    public Optional<String> getLexicalValue() {
        return this.lexical;
    }

    public String value() {
        return this.value;
    }

    @Override
    public TypeDescriptor descriptor() {
        return MetaTypeDescriptor.INSTANCE;
    }

    public static final class MetaTypeDescriptor
    extends DefaultTypeDescriptor {
        public static String TYPE_NAME = "schemarise.alfa.runtime.model.MetaType";
        public static MetaTypeDescriptor INSTANCE = new MetaTypeDescriptor();
        private UdtDataType _asUdtType_ = UdtDataType.builder().setUdtType(UdtMetaType.enumType).setFullyQualifiedName(TYPE_NAME).build();
        public static final short FIELD_ID_ENTITY = 0;
        public static final String FIELD_ENTITY = "Entity";
        public static final short FIELD_ID_KEY = 1;
        public static final String FIELD_KEY = "Key";
        public static final short FIELD_ID_TRAIT = 2;
        public static final String FIELD_TRAIT = "Trait";
        public static final short FIELD_ID_UNION = 3;
        public static final String FIELD_UNION = "Union";
        public static final short FIELD_ID_RECORD = 4;
        public static final String FIELD_RECORD = "Record";
        public static final short FIELD_ID_ENUM = 5;
        public static final String FIELD_ENUM = "Enum";
        public static final short FIELD_ID_UDT = 6;
        public static final String FIELD_UDT = "Udt";
        public static final short FIELD_ID_SERVICE = 7;
        public static final String FIELD_SERVICE = "Service";
        public static final short FIELD_ID_ANNOTATION = 8;
        public static final String FIELD_ANNOTATION = "Annotation";
        public static final short FIELD_ID_ENTITYNAME = 9;
        public static final String FIELD_ENTITYNAME = "EntityName";
        public static final short FIELD_ID_KEYNAME = 10;
        public static final String FIELD_KEYNAME = "KeyName";
        public static final short FIELD_ID_TRAITNAME = 11;
        public static final String FIELD_TRAITNAME = "TraitName";
        public static final short FIELD_ID_UNIONNAME = 12;
        public static final String FIELD_UNIONNAME = "UnionName";
        public static final short FIELD_ID_RECORDNAME = 13;
        public static final String FIELD_RECORDNAME = "RecordName";
        public static final short FIELD_ID_ENUMNAME = 14;
        public static final String FIELD_ENUMNAME = "EnumName";
        public static final short FIELD_ID_UDTNAME = 15;
        public static final String FIELD_UDTNAME = "UdtName";
        public static final short FIELD_ID_SERVICENAME = 16;
        public static final String FIELD_SERVICENAME = "ServiceName";
        public static final short FIELD_ID_FIELDNAME = 17;
        public static final String FIELD_FIELDNAME = "FieldName";
        private ScalarDataType _entityType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _keyType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _traitType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _unionType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _recordType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _enumType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _udtType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _serviceType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _annotationType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _entityNameType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _keyNameType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _traitNameType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _unionNameType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _recordNameType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _enumNameType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _udtNameType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _serviceNameType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        private ScalarDataType _fieldNameType = ScalarDataType.builder().setScalarType(ScalarType.voidType).build();
        public FieldMeta entityMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._entityType, "Entity", Optional.empty());
        public FieldMeta keyMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._keyType, "Key", Optional.empty());
        public FieldMeta traitMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._traitType, "Trait", Optional.empty());
        public FieldMeta unionMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._unionType, "Union", Optional.empty());
        public FieldMeta recordMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._recordType, "Record", Optional.empty());
        public FieldMeta _enumMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._enumType, "Enum", Optional.empty());
        public FieldMeta udtMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._udtType, "Udt", Optional.empty());
        public FieldMeta serviceMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._serviceType, "Service", Optional.empty());
        public FieldMeta annotationMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._annotationType, "Annotation", Optional.empty());
        public FieldMeta entityNameMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._entityNameType, "EntityName", Optional.empty());
        public FieldMeta keyNameMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._keyNameType, "KeyName", Optional.empty());
        public FieldMeta traitNameMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._traitNameType, "TraitName", Optional.empty());
        public FieldMeta unionNameMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._unionNameType, "UnionName", Optional.empty());
        public FieldMeta recordNameMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._recordNameType, "RecordName", Optional.empty());
        public FieldMeta enumNameMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._enumNameType, "EnumName", Optional.empty());
        public FieldMeta udtNameMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._udtNameType, "UdtName", Optional.empty());
        public FieldMeta serviceNameMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._serviceNameType, "ServiceName", Optional.empty());
        public FieldMeta fieldNameMeta = new FieldMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), this._fieldNameType, "FieldName", Optional.empty());
        protected Map<String, Assert> _asserts_ = Collections.unmodifiableMap(new LinkedHashMap(){});
        protected Map<String, FieldMeta<MetaType>> _fieldsMeta_ = Collections.unmodifiableMap(new LinkedHashMap(){
            {
                this.put(MetaTypeDescriptor.FIELD_ENTITY, entityMeta);
                this.put(MetaTypeDescriptor.FIELD_KEY, keyMeta);
                this.put(MetaTypeDescriptor.FIELD_TRAIT, traitMeta);
                this.put(MetaTypeDescriptor.FIELD_UNION, unionMeta);
                this.put(MetaTypeDescriptor.FIELD_RECORD, recordMeta);
                this.put(MetaTypeDescriptor.FIELD_ENUM, _enumMeta);
                this.put(MetaTypeDescriptor.FIELD_UDT, udtMeta);
                this.put(MetaTypeDescriptor.FIELD_SERVICE, serviceMeta);
                this.put(MetaTypeDescriptor.FIELD_ANNOTATION, annotationMeta);
                this.put(MetaTypeDescriptor.FIELD_ENTITYNAME, entityNameMeta);
                this.put(MetaTypeDescriptor.FIELD_KEYNAME, keyNameMeta);
                this.put(MetaTypeDescriptor.FIELD_TRAITNAME, traitNameMeta);
                this.put(MetaTypeDescriptor.FIELD_UNIONNAME, unionNameMeta);
                this.put(MetaTypeDescriptor.FIELD_RECORDNAME, recordNameMeta);
                this.put(MetaTypeDescriptor.FIELD_ENUMNAME, enumNameMeta);
                this.put(MetaTypeDescriptor.FIELD_UDTNAME, udtNameMeta);
                this.put(MetaTypeDescriptor.FIELD_SERVICENAME, serviceNameMeta);
                this.put(MetaTypeDescriptor.FIELD_FIELDNAME, fieldNameMeta);
            }
        });

        public Optional<Function<MetaType, Supplier>> getFieldSupplier(String fieldName) {
            return Optional.empty();
        }

        @Override
        public Optional<BiConsumer<Builder, DataSupplier>> getFieldConsumer(String fieldName) {
            return Optional.empty();
        }

        @Override
        public boolean hasBuilder() {
            return false;
        }

        @Override
        public boolean convertableToBuilder() {
            return false;
        }

        @Override
        public Builder builder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder builder(IBuilderConfig cc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public UdtDataType getUdtDataType() {
            return this._asUdtType_;
        }

        @Override
        public Map<String, Assert> getAsserts() {
            return this._asserts_;
        }

        public Map<String, FieldMeta<MetaType>> getAllFieldsMeta() {
            return this._fieldsMeta_;
        }

        @Override
        public Optional<TypeDescriptor> getEntityKeyModel() {
            return Optional.empty();
        }

        @Override
        public String fieldIdName(int id) {
            switch (id) {
                case 0: {
                    return FIELD_ENTITY;
                }
                case 1: {
                    return FIELD_KEY;
                }
                case 2: {
                    return FIELD_TRAIT;
                }
                case 3: {
                    return FIELD_UNION;
                }
                case 4: {
                    return FIELD_RECORD;
                }
                case 5: {
                    return FIELD_ENUM;
                }
                case 6: {
                    return FIELD_UDT;
                }
                case 7: {
                    return FIELD_SERVICE;
                }
                case 8: {
                    return FIELD_ANNOTATION;
                }
                case 9: {
                    return FIELD_ENTITYNAME;
                }
                case 10: {
                    return FIELD_KEYNAME;
                }
                case 11: {
                    return FIELD_TRAITNAME;
                }
                case 12: {
                    return FIELD_UNIONNAME;
                }
                case 13: {
                    return FIELD_RECORDNAME;
                }
                case 14: {
                    return FIELD_ENUMNAME;
                }
                case 15: {
                    return FIELD_UDTNAME;
                }
                case 16: {
                    return FIELD_SERVICENAME;
                }
                case 17: {
                    return FIELD_FIELDNAME;
                }
            }
            throw new AlfaRuntimeException("Unknown field id " + id);
        }

        @Override
        public boolean hasAbstractTypeFieldsInClosure() {
            return false;
        }

        @Override
        public Set<String> getImmediateDescendants() {
            return Collections.emptySet();
        }

        @Override
        public Optional<Map<String, Expression>> getAnnotations() {
            return Optional.empty();
        }

        @Override
        public Set<ModifierType> getModifiers() {
            return new HashSet<ModifierType>(){};
        }

        @Override
        public String getChecksum() {
            return "c1528e8d:";
        }
    }
}

