/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime;

import com.schemarise.alfa.runtime.AlfaObject;
import com.schemarise.alfa.runtime.Entity;
import com.schemarise.alfa.runtime.Enum;
import com.schemarise.alfa.runtime.Key;
import com.schemarise.alfa.runtime.NormalizedPeriod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import schemarise.alfa.runtime.model.Either;
import schemarise.alfa.runtime.model.Pair;
import schemarise.alfa.runtime.model.Try;

public interface IBuiltinFunctions {
    public static final String FnIsNone = "isNone";
    public static final String FnIsSome = "isSome";
    public static final String FnDistinct = "distinct";
    public static final String FnFlatten = "flatten";
    public static final String FnGroupBy = "groupBy";
    public static final String FnAggregate = "aggregate";
    public static final String FnDuplicates = "duplicates";
    public static final String FnGetOrElse = "getOrElse";
    public static final String FnSome = "some";
    public static final String FnToDate = "toDate";
    public static final String FnToDatetime = "toDatetime";
    public static final String FnToDatetimetz = "toDatetimetz";
    public static final String FnToTime = "toTime";
    public static final String FnToDecimal = "toDecimal";
    public static final String FnToDouble = "toDouble";
    public static final String FnToDuration = "toDuration";
    public static final String FnToPeriod = "toPeriod";
    public static final String FnToInt = "toInt";
    public static final String FnToList = "toList";
    public static final String FnToSet = "toSet";
    public static final String FnNewEitherLeft = "newEitherLeft";
    public static final String FnNewEitherRight = "newEitherRight";
    public static final String FnIsLeft = "isLeft";
    public static final String FnIsRight = "isRight";
    public static final String FnNewTryValue = "newTryValue";
    public static final String FnNewTryFailure = "newTryFailure";
    public static final String FnIsTryFailure = "isTryFailure";
    public static final String FnNewUUID = "newUUID";
    public static final String FnNow = "now";
    public static final String FnToday = "today";
    public static final String FnYear = "year";
    public static final String FnMonth = "month";
    public static final String FnDay = "day";
    public static final String FnWeekday = "weekday";
    public static final String FnHour = "hour";
    public static final String FnMinute = "minute";
    public static final String FnMillisecond = "millisecond";
    public static final String FnSecond = "second";
    public static final String FnDateDiff = "dateDiff";
    public static final String FnStddev = "stddev";
    public static final String FnVariance = "variance";
    public static final String FnAverage = "average";
    public static final String FnQuartile = "quartile";
    public static final String FnPercentile = "percentile";
    public static final String FnToEnum = "toEnum";
    public static final String FnPublish = "publish";
    public static final String FnKeyExists = "keyExists";
    public static final String FnToUpper = "toUpper";
    public static final String FnTransform = "transform";
    public static final String FnLen = "len";
    public static final String FnAdd = "add";
    public static final String FnGet = "get";
    public static final String FnPut = "put";
    public static final String FnToString = "toString";
    public static final String FnValues = "values";
    public static final String FnAbs = "abs";
    public static final String FnSqrt = "sqrt";
    public static final String FnLog = "log";
    public static final String FnMin = "min";
    public static final String FnMax = "max";
    public static final String FnIndexOf = "indexOf";
    public static final String FnIsEmpty = "isEmpty";
    public static final String FnStartsWith = "startsWith";
    public static final String FnEndsWith = "endsWith";
    public static final String FnSubstring = "substring";
    public static final String FnMatches = "matches";
    public static final String FnContains = "contains";
    public static final String FnReplaceAll = "replaceAll";
    public static final String FnSplit = "split";
    public static final String FnCompare = "compare";
    public static final String FnToMap = "toMap";
    public static final String FnDelete = "delete";
    public static final String FnDebug = "debug";
    public static final String FnIsSet = "isSet";
    public static final String FnTimestamp = "timestamp";
    public static final String FnSave = "save";
    public static final String FnKeys = "keys";
    public static final String FnUnwrap = "unwrap";
    public static final String FnExists = "exists";
    public static final String FnQuery = "query";
    public static final String FnToLower = "toLower";
    public static final String FnSort = "sort";
    public static final String FnLookup = "lookup";
    public static final String FnFilter = "filter";
    public static final String FnCeil = "ceil";
    public static final String FnFloor = "floor";
    public static final String FnRound = "round";
    public static final String FnRandom = "random";
    public static final String FnMap = "map";
    public static final String FnLeft = "left";
    public static final String FnRight = "right";
    public static final String FnReduce = "reduce";

    @CommonFunc
    public Void debug(Object var1);

    @CommonFunc
    public <T> Void add(@NonUdtFieldReference Set<T> var1, T var2);

    @CommonFunc
    public <T> Void add(@NonUdtFieldReference List<T> var1, T var2);

    @CommonFunc
    public <T> LocalDate add(LocalDate var1, Duration var2);

    @CommonFunc
    public <T> LocalDateTime add(LocalDateTime var1, Duration var2);

    @CommonFunc
    public <T> LocalTime add(LocalTime var1, Duration var2);

    @CommonFunc
    public <T> LocalDate add(LocalDate var1, NormalizedPeriod var2);

    @CommonFunc
    public <T> LocalDateTime add(LocalDateTime var1, NormalizedPeriod var2);

    @CommonFunc
    public <T> LocalTime add(LocalTime var1, NormalizedPeriod var2);

    @CollectionFunc
    public <T> Boolean contains(List<T> var1, T var2);

    @CollectionFunc
    public <T> Boolean contains(Set<T> var1, T var2);

    @CollectionFunc
    public <K, V> Boolean contains(Map<K, V> var1, K var2);

    @CollectionFunc
    public <T> Integer indexOf(List<T> var1, T var2);

    @StringFunc
    public Integer indexOf(String var1, String var2);

    @CommonFunc
    public <T> Boolean isNone(Optional<T> var1);

    @CommonFunc
    public <T> Boolean isSome(Optional<T> var1);

    @CommonFunc
    public Boolean isSet(Supplier<Boolean> var1);

    @StringFunc
    public String left(String var1, Integer var2);

    @CollectionFunc
    public <T> List<T> left(List<T> var1, Integer var2);

    @CollectionFunc
    public <T> Integer len(List<T> var1);

    @CollectionFunc
    public <T> Integer len(Set<T> var1);

    @CollectionFunc
    public <T> Long len(Stream<T> var1);

    @CollectionFunc
    public <K, V> Integer len(Map<K, V> var1);

    @StringFunc
    public Integer len(String var1);

    @StringFunc
    public String right(String var1, Integer var2);

    @CollectionFunc
    public <T> List<T> right(List<T> var1, Integer var2);

    @CollectionFunc
    public <T> Void delete(List<T> var1, Integer var2);

    @CollectionFunc
    public <T> Void delete(Set<T> var1, T var2);

    @CollectionFunc
    public <K, V> Void delete(Map<K, V> var1, K var2);

    @CollectionFunc
    public <T> List<T> filter(List<T> var1, Predicate<T> var2);

    @CollectionFunc
    public <T> Set<T> filter(Set<T> var1, Predicate<T> var2);

    @CollectionFunc
    public <T> List<T> filter(Stream<T> var1, Predicate<T> var2);

    @CollectionFunc
    public <K, V> Map<K, V> filter(Map<K, V> var1, BiPredicate<K, V> var2);

    @CollectionFunc
    public <T> Boolean isEmpty(List<T> var1);

    @CollectionFunc
    public <T> Boolean isEmpty(Set<T> var1);

    @CollectionFunc
    public <K, T> Boolean isEmpty(Map<K, T> var1);

    @CannotInferReturnType
    public <T, R> List<R> map(List<T> var1, Function<T, R> var2);

    @CannotInferReturnType
    public <T, R> List<R> map(Stream<T> var1, Function<T, R> var2);

    @CannotInferReturnType
    public <T, R> Set<R> map(Set<T> var1, Function<T, R> var2);

    @CannotInferReturnType
    public <K, V, KR, VR> Map<KR, VR> map(Map<K, V> var1, BiFunction<K, V, KR> var2, BiFunction<K, V, VR> var3);

    @CollectionFunc
    public <K, V> Map<K, V> put(@NonUdtFieldReference Map<K, V> var1, K var2, V var3);

    @CommonFunc
    public <T> T get(Try<T> var1);

    @CommonFunc
    public <T> T getOrElse(Optional<T> var1, T var2);

    @CommonFunc
    public <T> T get(Optional<T> var1);

    @CollectionFunc
    public <K, V> Optional<V> get(Map<K, V> var1, K var2);

    @CollectionFunc
    public <K, V> V getOrElse(Map<K, V> var1, K var2, V var3);

    @CollectionFunc
    public <T> Optional<T> get(List<T> var1, Integer var2);

    @CollectionFunc
    public <R, K, V> R reduce(Map<K, V> var1, R var2, TriFunction<R, K, V, R> var3);

    @CollectionFunc
    public <T, R> R reduce(List<T> var1, R var2, BiFunction<R, T, R> var3);

    @CollectionFunc
    public <T, R> R reduce(Set<T> var1, R var2, BiFunction<R, T, R> var3);

    @CollectionFunc
    public <T, R> R reduce(Stream<T> var1, R var2, BiFunction<R, T, R> var3);

    @CollectionFunc
    public <Rv, Tv> Map<Rv, List<Tv>> groupBy(List<Tv> var1, Function<Tv, Rv> var2);

    @CollectionFunc
    public <Rv, Tv> Map<Rv, List<Tv>> duplicates(List<Tv> var1, Function<Tv, Rv> var2);

    @CollectionFunc
    public <Rv, Tv> Map<Rv, List<Tv>> duplicates(Set<Tv> var1, Function<Tv, Rv> var2);

    @CollectionFunc
    public <Rv, Tv> List<Pair<Rv, List<Tv>>> duplicates(Stream<Tv> var1, Function<Tv, Rv> var2);

    @CollectionFunc
    public <Rv, Tv> Set<Rv> distinct(Set<Tv> var1, Function<Tv, Rv> var2);

    @CollectionFunc
    public <Rv, Tv> Set<Rv> distinct(List<Tv> var1, Function<Tv, Rv> var2);

    @CollectionFunc
    public <Rv, Tv> List<Rv> distinct(Stream<Tv> var1, Function<Tv, Rv> var2);

    @CollectionFunc
    public <Rv, Tv> Map<Rv, List<Tv>> groupBy(Set<Tv> var1, Function<Tv, Rv> var2);

    @CollectionFunc
    public <Rv, Tv> List<Pair<Rv, List<Tv>>> groupBy(Stream<Tv> var1, Function<Tv, Rv> var2);

    @CollectionFunc
    public <T, K, V> Map<K, V> aggregate(List<T> var1, Function<T, K> var2, V var3, BiFunction<V, T, V> var4);

    @CollectionFunc
    public <T, K, V> Map<K, V> aggregate(Set<T> var1, Function<T, K> var2, V var3, BiFunction<V, T, V> var4);

    @CollectionFunc
    public <T, K, V> List<Pair<K, V>> aggregate(Stream<T> var1, Function<T, K> var2, V var3, BiFunction<V, T, V> var4);

    @CollectionFunc
    public <T extends Number> Double stddev(List<T> var1);

    @CollectionFunc
    public <T extends Number> Double average(List<T> var1);

    @CollectionFunc
    public <T extends Comparable> Double quartile(List<T> var1, int var2);

    @CollectionFunc
    public <T extends Comparable> Double percentile(List<T> var1, int var2);

    @CollectionFunc
    public <T extends Number> Double variance(List<T> var1);

    @CollectionFunc
    public <T extends Number> Double stddev(Stream<T> var1);

    @CollectionFunc
    public <T extends Number> Double average(Stream<T> var1);

    @CollectionFunc
    public <T extends Comparable> Double quartile(Stream<T> var1, int var2);

    @CollectionFunc
    public <T extends Comparable> Double percentile(Stream<T> var1, int var2);

    @CollectionFunc
    public <T extends Number> Double variance(Stream<T> var1);

    @CollectionFunc
    public <K, V> List<V> values(Map<K, V> var1);

    @CollectionFunc
    public <K, V> Set<K> keys(Map<K, V> var1);

    @CommonFunc
    public <T> Optional<T> some(T var1);

    @DatetimeFunc
    @ConversionFunc
    public LocalDate toDate(String var1);

    @DatetimeFunc
    @ConversionFunc
    public LocalDate toDate(ZonedDateTime var1);

    @DatetimeFunc
    @ConversionFunc
    public LocalDate toDate(LocalDateTime var1);

    @DatetimeFunc
    @ConversionFunc
    public LocalDateTime toDatetime(String var1);

    @DatetimeFunc
    @ConversionFunc
    public ZonedDateTime toDatetimetz(String var1);

    @DatetimeFunc
    @ConversionFunc
    public LocalDateTime toDatetime(LocalDate var1);

    @DatetimeFunc
    @ConversionFunc
    public LocalTime toTime(String var1);

    @DatetimeFunc
    @ConversionFunc
    public LocalTime toTime(LocalDateTime var1);

    @ConversionFunc
    public BigDecimal toDecimal(String var1);

    @ConversionFunc
    public BigDecimal toDecimal(Integer var1);

    @ConversionFunc
    public BigDecimal toDecimal(Long var1);

    @ConversionFunc
    public BigDecimal toDecimal(Double var1);

    @ConversionFunc
    public Double toDouble(String var1);

    @ConversionFunc
    public Double toDouble(Integer var1);

    @ConversionFunc
    public Double toDouble(Long var1);

    @ConversionFunc
    public Duration toDuration(String var1);

    @ConversionFunc
    public NormalizedPeriod toPeriod(String var1);

    @ConversionFunc
    public Integer toInt(String var1);

    @ConversionFunc
    public <T> List<T> toList(Set<T> var1);

    @ConversionFunc
    public <T> List<T> toList(Stream<T> var1);

    @ConversionFunc
    public <T> Set<T> toSet(List<T> var1);

    @ConversionFunc
    public <T> Set<T> toSet(Stream<T> var1);

    @CannotInferReturnType
    @ConversionFunc
    public <T, K, V> Map<K, V> toMap(List<T> var1, Function<T, K> var2, Function<T, V> var3);

    @CannotInferReturnType
    @ConversionFunc
    public <T, K, V> Map<K, V> toMap(Set<T> var1, Function<T, K> var2, Function<T, V> var3);

    @ConversionFunc
    public String toString(String var1);

    @ConversionFunc
    public String toString(UUID var1);

    @ConversionFunc
    public String toString(Integer var1);

    @ConversionFunc
    public String toString(Double var1);

    @ConversionFunc
    public String toString(Long var1);

    @ConversionFunc
    public String toString(BigDecimal var1);

    @ConversionFunc
    public String toString(Boolean var1);

    @ConversionFunc
    public String toString(LocalDate var1);

    @ConversionFunc
    public String toString(LocalDateTime var1);

    @ConversionFunc
    public String toString(LocalTime var1);

    @ConversionFunc
    public String toString(Duration var1);

    @ConversionFunc
    public <T> String toString(T var1);

    @CannotInferReturnType
    @CommonFunc
    public <L, R> Either<L, R> newEitherLeft(L var1);

    @CannotInferReturnType
    @CommonFunc
    public <L, R> Either<L, R> newEitherRight(R var1);

    @CommonFunc
    public <L, R> L left(Either<L, R> var1);

    @CommonFunc
    public <L, R> R right(Either<L, R> var1);

    @CommonFunc
    public <L, R> L left(Pair<L, R> var1);

    @CommonFunc
    public <L, R> R right(Pair<L, R> var1);

    @CommonFunc
    public <L, R> Boolean isLeft(Either<L, R> var1);

    @CommonFunc
    public <L, R> Boolean isRight(Either<L, R> var1);

    @CommonFunc
    public <T> Try<T> newTryValue(T var1);

    @CannotInferReturnType
    @CommonFunc
    public <T> Try<T> newTryFailure(String var1);

    @CommonFunc
    public <T> Boolean isTryFailure(Try<T> var1);

    @CreatorFunc
    public UUID newUUID();

    @DatetimeFunc
    public LocalTime now();

    @DatetimeFunc
    public LocalDate today();

    @DatetimeFunc
    public LocalDateTime timestamp();

    @DatetimeFunc
    public Integer year(LocalDate var1);

    @DatetimeFunc
    public Integer year(LocalDateTime var1);

    @DatetimeFunc
    public Integer month(LocalDate var1);

    @DatetimeFunc
    public Integer month(LocalDateTime var1);

    @DatetimeFunc
    public Integer day(LocalDate var1);

    @DatetimeFunc
    public Integer day(Duration var1);

    @DatetimeFunc
    public Integer day(LocalDateTime var1);

    @DatetimeFunc
    public Integer weekday(LocalDateTime var1);

    @DatetimeFunc
    public Integer weekday(LocalDate var1);

    @DatetimeFunc
    public Integer hour(LocalDateTime var1);

    @DatetimeFunc
    public Integer hour(Duration var1);

    @DatetimeFunc
    public Integer hour(LocalTime var1);

    @DatetimeFunc
    public Integer minute(LocalDateTime var1);

    @DatetimeFunc
    public Integer minute(LocalTime var1);

    @DatetimeFunc
    public Integer minute(Duration var1);

    @DatetimeFunc
    public Integer millisecond(LocalDateTime var1);

    @DatetimeFunc
    public Integer millisecond(LocalTime var1);

    @DatetimeFunc
    public Integer second(LocalDateTime var1);

    @DatetimeFunc
    public Integer second(Duration var1);

    @DatetimeFunc
    public Integer second(LocalTime var1);

    @DatetimeFunc
    public Long dateDiff(LocalDate var1, LocalDate var2);

    @MathFunc
    public Integer abs(Integer var1);

    @MathFunc
    public Long abs(Long var1);

    @MathFunc
    public Double abs(Double var1);

    @MathFunc
    public Double ceil(Double var1);

    @MathFunc
    public Double floor(Double var1);

    @MathFunc
    public Double log(Double var1);

    @MathFunc
    public long round(Double var1);

    @MathFunc
    public Double sqrt(Double var1);

    @MathFunc
    public Double sqrt(Long var1);

    @MathFunc
    public Double sqrt(Integer var1);

    @MathFunc
    public Double random();

    @StringFunc
    public Boolean endsWith(String var1, String var2);

    @StringFunc
    public Boolean matches(String var1, String var2);

    @StringFunc
    public Boolean startsWith(String var1, String var2);

    @StringFunc
    public List<String> split(String var1, String var2);

    @StringFunc
    public String toLower(String var1);

    @StringFunc
    public String toUpper(String var1);

    @StringFunc
    public String replaceAll(String var1, String var2, String var3);

    @StringFunc
    public String substring(String var1, Integer var2);

    @StringFunc
    public String substring(String var1, Integer var2, Integer var3);

    @MathFunc
    public Integer min(Integer var1, Integer var2);

    @MathFunc
    public Integer max(Integer var1, Integer var2);

    @MathFunc
    public Long min(Long var1, Long var2);

    @MathFunc
    public Long max(Long var1, Long var2);

    @MathFunc
    public Double min(Double var1, Double var2);

    @MathFunc
    public Double max(Double var1, Double var2);

    @MathFunc
    public BigDecimal min(BigDecimal var1, BigDecimal var2);

    @MathFunc
    public BigDecimal max(BigDecimal var1, BigDecimal var2);

    @DatetimeFunc
    public LocalDate min(LocalDate var1, LocalDate var2);

    @DatetimeFunc
    public LocalDate max(LocalDate var1, LocalDate var2);

    @DatetimeFunc
    public LocalDateTime min(LocalDateTime var1, LocalDateTime var2);

    @DatetimeFunc
    public LocalDateTime max(LocalDateTime var1, LocalDateTime var2);

    @DatetimeFunc
    public LocalTime min(LocalTime var1, LocalTime var2);

    @DatetimeFunc
    public LocalTime max(LocalTime var1, LocalTime var2);

    @CollectionFunc
    public <T extends Comparable<T>> T min(Set<T> var1, BiFunction<T, T, Integer> var2);

    @CollectionFunc
    public <T extends Comparable<T>> T min(Set<T> var1);

    public <T extends Comparable<T>> Integer compare(T var1, T var2);

    @CollectionFunc
    public <T extends Comparable<T>> T max(Set<T> var1, BiFunction<T, T, Integer> var2);

    @CollectionFunc
    public <T extends Comparable<T>> T max(Set<T> var1);

    @CollectionFunc
    public <T extends Comparable<T>> T min(List<T> var1, BiFunction<T, T, Integer> var2);

    @CollectionFunc
    public <T extends Comparable<T>> T min(List<T> var1);

    @CollectionFunc
    public <T extends Comparable<T>> T max(List<T> var1, BiFunction<T, T, Integer> var2);

    @CollectionFunc
    public <T extends Comparable<T>> T max(List<T> var1);

    @CollectionFunc
    public <T extends Comparable<T>> T min(Stream<T> var1, BiFunction<T, T, Integer> var2);

    @CollectionFunc
    public <T extends Comparable<T>> T min(Stream<T> var1);

    @CollectionFunc
    public <T extends Comparable<T>> T max(Stream<T> var1, BiFunction<T, T, Integer> var2);

    @CollectionFunc
    public <T extends Comparable<T>> T max(Stream<T> var1);

    @CollectionFunc
    public <T> List<T> sort(Set<T> var1, BiFunction<T, T, Integer> var2);

    @CollectionFunc
    public <T extends Comparable<T>> List<T> sort(Set<T> var1);

    @CollectionFunc
    public <T> List<T> sort(List<T> var1, BiFunction<T, T, Integer> var2);

    @CollectionFunc
    public <T extends Comparable<T>> List<T> sort(List<T> var1);

    @CollectionFunc
    public <T extends Comparable<T>> List<T> sort(Stream<T> var1);

    @CollectionFunc
    public <T> List<T> sort(Stream<T> var1, BiFunction<T, T, Integer> var2);

    @CustomTypeResolution
    @PersistFunc
    public <E> List<E> query(Optional<AlfaObject> var1, E var2, Predicate<E> var3, Map<String, Integer> var4, int var5);

    @CustomTypeResolution
    @PersistFunc
    public <E> List<E> query(Optional<AlfaObject> var1, E var2, Predicate<E> var3, Map<String, Integer> var4, int var5, String var6);

    @CustomTypeResolution
    @PersistFunc
    public <E extends Entity, K extends Key> Optional<E> lookup(String var1, K var2);

    @CustomTypeResolution
    @PersistFunc
    public <E extends Entity, K extends Key> Optional<E> lookup(String var1, K var2, String var3);

    @CustomTypeResolution
    @PersistFunc
    public <E extends Entity> void save(E var1);

    @CustomTypeResolution
    @PersistFunc
    public <E extends Entity> void save(E var1, String var2);

    @CustomTypeResolution
    @PersistFunc
    public <E extends AlfaObject> void publish(String var1, E var2);

    @CustomTypeResolution
    @PersistFunc
    public <E extends Entity> Boolean exists(String var1, Predicate<E> var2);

    @CustomTypeResolution
    @PersistFunc
    public <E extends Entity> Boolean exists(String var1, Predicate<E> var2, String var3);

    @CustomTypeResolution
    @PersistFunc
    public <E extends Entity, K extends Key> Boolean keyExists(String var1, K var2);

    @CustomTypeResolution
    @PersistFunc
    public <E extends Entity, K extends Key> Boolean keyExists(String var1, K var2, String var3);

    public <T, R> List<R> flatten(List<T> var1);

    public <T, R> Set<R> flatten(Set<T> var1);

    public <T extends Enum> Optional<T> toEnum(String var1, String var2);

    public <E> Set<String> enumValues(Enum var1);

    public Set<String> enumValues(String var1);

    public Set<String> enumValues(String var1, List<String> var2);

    public String toFormattedTable(List var1);

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NonUdtFieldReference {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CustomTypeResolution {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CannotInferReturnType {
    }

    public static @interface StringFunc {
    }

    public static @interface PersistFunc {
    }

    public static @interface MathFunc {
    }

    public static @interface DatetimeFunc {
    }

    public static @interface CreatorFunc {
    }

    public static @interface ConversionFunc {
    }

    public static @interface CommonFunc {
    }

    public static @interface CollectionFunc {
    }

    public static interface TriFunction<T, U, V, R> {
    }
}

