/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime;

import java.time.Period;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.IsoChronology;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class NormalizedPeriod
implements ChronoPeriod,
Comparable<NormalizedPeriod> {
    private Period under;
    private static Map<String, NormalizedPeriod> nperiods = new WeakHashMap<String, NormalizedPeriod>();

    public static NormalizedPeriod of(String s) {
        NormalizedPeriod existing = nperiods.get(s);
        if (existing != null) {
            return existing;
        }
        Period np = Period.parse(s).normalized();
        NormalizedPeriod l = new NormalizedPeriod(np);
        nperiods.put(s, l);
        return l;
    }

    public static NormalizedPeriod of(Period p) {
        String s = p.toString();
        NormalizedPeriod existing = nperiods.get(s);
        if (existing != null) {
            return existing;
        }
        Period np = p.normalized();
        NormalizedPeriod l = new NormalizedPeriod(np);
        nperiods.put(s, l);
        return l;
    }

    private NormalizedPeriod(Period under) {
        this.under = under;
    }

    public Period getRawValue() {
        return this.under;
    }

    @Override
    public long get(TemporalUnit unit) {
        return this.under.get(unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return this.under.getUnits();
    }

    @Override
    public IsoChronology getChronology() {
        return this.under.getChronology();
    }

    @Override
    public boolean isZero() {
        return this.under.isZero();
    }

    @Override
    public boolean isNegative() {
        return this.under.isNegative();
    }

    public int getYears() {
        return this.under.getYears();
    }

    public int getMonths() {
        return this.under.getMonths();
    }

    public int getDays() {
        return this.under.getDays();
    }

    public NormalizedPeriod withYears(int years) {
        return new NormalizedPeriod(this.under.withYears(years));
    }

    public NormalizedPeriod withMonths(int months) {
        return new NormalizedPeriod(this.under.withMonths(months));
    }

    public NormalizedPeriod withDays(int days) {
        return new NormalizedPeriod(this.under.withDays(days));
    }

    @Override
    public NormalizedPeriod plus(TemporalAmount amountToAdd) {
        return new NormalizedPeriod(this.under.plus(amountToAdd));
    }

    public NormalizedPeriod plusYears(long yearsToAdd) {
        return new NormalizedPeriod(this.under.plusYears(yearsToAdd));
    }

    public NormalizedPeriod plusMonths(long monthsToAdd) {
        return new NormalizedPeriod(this.under.plusMonths(monthsToAdd));
    }

    public NormalizedPeriod plusDays(long daysToAdd) {
        return new NormalizedPeriod(this.under.plusDays(daysToAdd));
    }

    @Override
    public NormalizedPeriod minus(TemporalAmount amountToSubtract) {
        return new NormalizedPeriod(this.under.minus(amountToSubtract));
    }

    public NormalizedPeriod minusYears(long yearsToSubtract) {
        return new NormalizedPeriod(this.under.minusYears(yearsToSubtract));
    }

    public NormalizedPeriod minusMonths(long monthsToSubtract) {
        return new NormalizedPeriod(this.under.minusMonths(monthsToSubtract));
    }

    public NormalizedPeriod minusDays(long daysToSubtract) {
        return new NormalizedPeriod(this.under.minusDays(daysToSubtract));
    }

    @Override
    public NormalizedPeriod multipliedBy(int scalar) {
        return new NormalizedPeriod(this.under.multipliedBy(scalar));
    }

    @Override
    public NormalizedPeriod negated() {
        return new NormalizedPeriod(this.under.negated());
    }

    @Override
    public NormalizedPeriod normalized() {
        return this;
    }

    public long toTotalMonths() {
        return this.under.toTotalMonths();
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return this.under.addTo(temporal);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return this.under.subtractFrom(temporal);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NormalizedPeriod that = (NormalizedPeriod)o;
        return this.compareTo(that) == 0;
    }

    @Override
    public int hashCode() {
        return this.under.hashCode();
    }

    @Override
    public String toString() {
        return this.under.toString();
    }

    @Override
    public int compareTo(NormalizedPeriod o) {
        int y = Integer.compare(this.under.getYears(), o.getYears());
        if (y != 0) {
            return y;
        }
        int m = Integer.compare(this.under.getMonths(), o.getMonths());
        if (m != 0) {
            return m;
        }
        return Integer.compare(this.under.getDays(), o.getDays());
    }
}

