/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.codec.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.schemarise.alfa.runtime.DefaultValidationListener;
import com.schemarise.alfa.runtime.IValidationListener;
import com.schemarise.alfa.runtime.RuntimeContext;
import com.schemarise.alfa.runtime.ServiceFactory;
import com.schemarise.alfa.runtime.codec.CodecConfig;
import com.schemarise.alfa.runtime.codec.json.IJsonReaderRecovery;
import com.schemarise.alfa.runtime.codec.json.JsonTypeWriteMode;
import com.schemarise.alfa.runtime_int.IntImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public final class JsonCodecConfig
extends CodecConfig {
    private final boolean skipUnknownFields;
    private final ClassLoader customClassLoader;
    private final JsonFactory jsonFactory;
    private final JsonTypeWriteMode writeTypeMode;
    private final boolean writeStringifiedNumbers;
    private static JsonCodecConfig singleton = new Builder().build();
    private final boolean writeEmptyOptionalAsNull;
    private final boolean ignoreDateFormat;
    private final boolean allowOutOfOrderTypeSpecifier;
    private final boolean writeCheckSum;
    private final boolean writeModelId;
    private final Optional<IJsonReaderRecovery> jsonReaderRecovery;
    private final Function<String, String> fieldNameMapping;

    private JsonCodecConfig(Optional<Class> assignableToClass, boolean shouldValidateOnBuild, boolean assertMandatoryFieldsSet, boolean shouldCloneCollectionsOnBuild, RuntimeContext runtimeContext, boolean skipUnknownFields, ClassLoader customClassLoader, JsonFactory jsonFactory, String metaFieldPrefix, Map<String, ServiceFactory> serviceFactories, boolean writeDetectCycles, boolean writeStringifiedNumbers, JsonTypeWriteMode writeTypeMode, boolean writeMapAsObject, boolean writeEntityKeyAsObject, boolean writeEmptyOptionalAsNull, boolean verbose, IValidationListener assertListener, Set<String> excludeAsserts, boolean ignoreDateFormat, boolean allowOutOfOrderTypeSpecifier, ExecutorService executorService, boolean writeCheckSum, Optional<IJsonReaderRecovery> jsonReaderRecovery, Function<String, String> fieldNameMapping, boolean writeModelId) {
        super(serviceFactories, runtimeContext, assignableToClass, shouldValidateOnBuild, assertMandatoryFieldsSet, shouldCloneCollectionsOnBuild, writeDetectCycles, skipUnknownFields, metaFieldPrefix, verbose, writeMapAsObject, writeEntityKeyAsObject, assertListener, excludeAsserts, executorService);
        this.writeTypeMode = writeTypeMode;
        this.writeStringifiedNumbers = writeStringifiedNumbers;
        this.skipUnknownFields = skipUnknownFields;
        this.customClassLoader = customClassLoader;
        this.jsonFactory = jsonFactory;
        this.writeEmptyOptionalAsNull = writeEmptyOptionalAsNull;
        this.ignoreDateFormat = ignoreDateFormat;
        this.allowOutOfOrderTypeSpecifier = allowOutOfOrderTypeSpecifier;
        this.writeCheckSum = writeCheckSum;
        this.jsonReaderRecovery = jsonReaderRecovery;
        this.fieldNameMapping = fieldNameMapping;
        this.writeModelId = writeModelId;
    }

    public Function<String, String> getFieldNameMapper() {
        return this.fieldNameMapping;
    }

    public boolean isWriteCheckSum() {
        return this.writeCheckSum;
    }

    public boolean isWriteModelId() {
        return this.writeModelId;
    }

    public boolean isOutOfOrderTypeSpecifierAllowed() {
        return this.allowOutOfOrderTypeSpecifier;
    }

    public boolean isWriteEmptyOptionalAsNull() {
        return this.writeEmptyOptionalAsNull;
    }

    public JsonTypeWriteMode getWriteTypeMode() {
        return this.writeTypeMode;
    }

    public boolean isWriteStringifiedNumbers() {
        return this.writeStringifiedNumbers;
    }

    public Optional<IJsonReaderRecovery> getJsonReaderRecovery() {
        return this.jsonReaderRecovery;
    }

    public boolean isIgnoreDateFormat() {
        return this.ignoreDateFormat;
    }

    public static JsonCodecConfig getInstance() {
        return singleton;
    }

    public ClassLoader getCustomClassLoader() {
        return this.customClassLoader;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    @Override
    public boolean isSkipUnknownFields() {
        return this.skipUnknownFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends CodecConfig.Builder {
        private boolean shouldValidateOnBuild = true;
        private boolean assertMandatoryFieldsSet = true;
        private boolean shouldCloneCollectionsOnBuild = true;
        private Optional<Class> assignableToClass = Optional.empty();
        private RuntimeContext runtimeContext = IntImpl.defaultRuntimeContext();
        private boolean skipUnknownFields = false;
        private ClassLoader customClassLoader = JsonCodecConfig.class.getClassLoader();
        private JsonFactory jsonFactory = new JsonFactory();
        private String metaFieldPrefix = "$";
        private JsonTypeWriteMode writeTypeMode = JsonTypeWriteMode.AlwaysWriteType;
        private boolean writeDetectCycles = false;
        private boolean writeStringifiedNumbers = true;
        private Map<String, ServiceFactory> serviceFactories = new HashMap<String, ServiceFactory>();
        private boolean verbose = false;
        private boolean writeMapAsObject = true;
        private boolean writeEntityKeyAsObject = false;
        private boolean writeEmptyOptionalAsNull = false;
        private IValidationListener assertListener = new DefaultValidationListener();
        private Set<String> excludeAsserts = new HashSet<String>();
        private boolean ignoreDateFormat;
        private static final ExecutorService defaultExecutorService = CodecConfig.Builder.defaultExecutorService;
        private ExecutorService userExecutorService = null;
        private boolean allowOutOfOrderTypeSpecifier;
        private boolean writeChecksum = false;
        private IJsonReaderRecovery jsonReaderRecovery;
        private Function<String, String> fieldNameMapping = x -> null;
        private boolean writeModelId = true;

        private Builder() {
        }

        public Builder setWriteModelId(boolean writeModelId) {
            this.writeModelId = writeModelId;
            return this;
        }

        public Builder setWriteChecksum(boolean writeChecksum) {
            this.writeChecksum = writeChecksum;
            return this;
        }

        @Override
        public Builder setExecutorService(ExecutorService es) {
            this.userExecutorService = es;
            return this;
        }

        @Override
        public Builder setExcludeAsserts(Set<String> excludeAsserts) {
            this.excludeAsserts = excludeAsserts;
            return this;
        }

        @Override
        public Builder setAssertListener(IValidationListener assertListener) {
            this.assertListener = assertListener;
            return this;
        }

        public Builder setWriteMapAsJsonObject(boolean writeMapAsObject) {
            this.writeMapAsObject = writeMapAsObject;
            return this;
        }

        public Builder setIgnoreDateFormat(boolean ignoreDateFormat) {
            this.ignoreDateFormat = ignoreDateFormat;
            return this;
        }

        @Override
        public Builder setWriteEntityKeyAsObject(boolean writeEntityKeyAsObject) {
            this.writeEntityKeyAsObject = writeEntityKeyAsObject;
            return this;
        }

        public Builder setWriteEmptyOptionalAsNull(boolean writeEmptyOptionalAsNull) {
            this.writeEmptyOptionalAsNull = writeEmptyOptionalAsNull;
            return this;
        }

        @Override
        public Builder setVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        @Override
        public Builder setAssignableToClass(Optional<Class> assignableToClass) {
            this.assignableToClass = assignableToClass;
            return this;
        }

        public Builder setWriteTypeMode(JsonTypeWriteMode writeTypeMode) {
            this.writeTypeMode = writeTypeMode;
            return this;
        }

        @Override
        public Builder setWriteDetectCycles(boolean writeDetectCycles) {
            this.writeDetectCycles = writeDetectCycles;
            return this;
        }

        public Builder setWriteStringifiedNumbers(boolean writeStringifiedNumbers) {
            this.writeStringifiedNumbers = writeStringifiedNumbers;
            return this;
        }

        @Override
        public Builder setServiceFactories(Map<String, ServiceFactory> serviceFactories) {
            this.serviceFactories = serviceFactories;
            return this;
        }

        @Override
        public Builder setShouldValidateOnBuild(boolean shouldValidateOnBuild) {
            this.shouldValidateOnBuild = shouldValidateOnBuild;
            return this;
        }

        @Override
        public Builder unsafeDisableMandatoryFieldCheck() {
            this.assertMandatoryFieldsSet = false;
            return this;
        }

        @Override
        public Builder setShouldCloneCollectionsOnBuild(boolean shouldCloneCollectionsOnBuild) {
            this.shouldCloneCollectionsOnBuild = shouldCloneCollectionsOnBuild;
            return this;
        }

        public Builder setAssignableToClass(Class assignableToClass) {
            this.assignableToClass = Optional.of(assignableToClass);
            return this;
        }

        public Builder setJsonFactory(JsonFactory jf) {
            this.jsonFactory = jf;
            return this;
        }

        public Builder setCustomClassLoader(ClassLoader customClassLoader) {
            this.customClassLoader = customClassLoader;
            return this;
        }

        @Override
        public Builder setMetaFieldPrefix(String m) {
            this.metaFieldPrefix = m;
            return this;
        }

        @Override
        public Builder setRuntimeContext(RuntimeContext runtimeContext) {
            this.runtimeContext = runtimeContext;
            return this;
        }

        @Override
        public Builder setSkipUnknownFields(boolean skipUnknownFields) {
            this.skipUnknownFields = skipUnknownFields;
            return this;
        }

        public Builder addServiceFactory(Class<? extends ServiceFactory> ifc, ServiceFactory sfImpl) {
            this.serviceFactories.put(ifc.getTypeName(), sfImpl);
            return this;
        }

        public Builder setAllowOutOfOrderTypeSpecifier(boolean b) {
            this.allowOutOfOrderTypeSpecifier = b;
            return this;
        }

        public Builder setReaderRecovery(IJsonReaderRecovery rr) {
            this.jsonReaderRecovery = rr;
            return this;
        }

        @Override
        public JsonCodecConfig build() {
            ExecutorService es = defaultExecutorService;
            if (this.userExecutorService != null) {
                es = this.userExecutorService;
            }
            return new JsonCodecConfig(this.assignableToClass, this.shouldValidateOnBuild, this.assertMandatoryFieldsSet, this.shouldCloneCollectionsOnBuild, this.runtimeContext, this.skipUnknownFields, this.customClassLoader, this.jsonFactory, this.metaFieldPrefix, this.serviceFactories, this.writeDetectCycles, this.writeStringifiedNumbers, this.writeTypeMode, this.writeMapAsObject, this.writeEntityKeyAsObject, this.writeEmptyOptionalAsNull, this.verbose, this.assertListener, this.excludeAsserts, this.ignoreDateFormat, this.allowOutOfOrderTypeSpecifier, es, this.writeChecksum, Optional.ofNullable(this.jsonReaderRecovery), this.fieldNameMapping, this.writeModelId);
        }

        public Builder setFieldNameMapper(Function<String, String> m) {
            this.fieldNameMapping = m;
            return this;
        }
    }
}

