/*
 * Decompiled with CFR 0.152.
 */
package com.schemarise.alfa.runtime.utils;

import com.schemarise.alfa.runtime.codec.json.JsonCodecConfig;
import com.schemarise.alfa.runtime.codec.json.JsonTypeWriteMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import schemarise.alfa.runtime.model.path.Path;
import schemarise.alfa.runtime.model.path.PathElement;

public class PathCreator {
    private Path.PathBuilder _path;
    private static Set<Class> primitives = new HashSet<Class>();
    private static JsonCodecConfig jcc;

    public PathCreator(String field) {
        this._path = Path.builder().setField(field);
    }

    public PathCreator mapKeyElement(Object k) {
        this._path.setElement(PathElement.builder().addAllMapKey(this.objToPath(k)).build());
        return this;
    }

    private List<PathElement> objToPath(Object k) {
        ArrayList<PathElement> pel = new ArrayList<PathElement>();
        if (primitives.contains(k.getClass())) {
            pel.add(PathElement.builder().setScalarValue(String.valueOf(k)).build());
        } else {
            pel.add(PathElement.builder().setScalarValue("<unhandled path " + k.getClass().getSimpleName() + ">").build());
        }
        return pel;
    }

    public PathCreator mapEntryElement(Map.Entry v) {
        return this;
    }

    public PathCreator listIdxElement(int idx) {
        return this;
    }

    public PathCreator setEntryElement(Object e0) {
        return this;
    }

    public Path toReportablePath() {
        Path p = this._path.build();
        return p;
    }

    public String toString() {
        return this._path.toString();
    }

    public PathCreator scalarElement(Object v) {
        this._path.setElement(PathElement.builder().setScalarValue(String.valueOf(v)).build());
        return this;
    }

    static {
        primitives.add(String.class);
        primitives.add(Long.class);
        primitives.add(Integer.class);
        primitives.add(Boolean.class);
        primitives.add(Double.class);
        primitives.add(Float.class);
        primitives.add(Short.class);
        primitives.add(LocalDate.class);
        primitives.add(Duration.class);
        primitives.add(LocalDateTime.class);
        primitives.add(LocalTime.class);
        jcc = JsonCodecConfig.builder().setWriteTypeMode(JsonTypeWriteMode.NeverWriteType).build();
    }
}

